/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmRefTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;

public class JvmRefTypeConstantsGen {
    private final String typeRefVarConstantsClass;
    private JvmRefTypeGen jvmRefTypeGen;
    private final ClassWriter cw;
    private MethodVisitor mv;
    private final Map<BTypeReferenceType, String> typeRefVarMap;
    private final List<String> funcNames = new ArrayList<String>();
    private int typeDefCount = 0;
    private int methodCount = 1;

    public JvmRefTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator) {
        this.typeRefVarConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "constants/$_typeref_type_constants");
        this.cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(this.cw, this.typeRefVarConstantsClass);
        this.mv = this.cw.visitMethod(9, "$typeref_type_init", "()V", null, null);
        this.typeRefVarMap = new TreeMap<BType, String>(bTypeHashComparator);
    }

    public void setJvmRefTypeGen(JvmRefTypeGen jvmRefTypeGen) {
        this.jvmRefTypeGen = jvmRefTypeGen;
    }

    public String add(BTypeReferenceType type) {
        String varName = this.typeRefVarMap.get(type);
        if (varName == null) {
            varName = this.generateTypeRefTypeInitMethod(type);
            this.typeRefVarMap.put(type, varName);
        }
        return varName;
    }

    private String generateTypeRefTypeInitMethod(BTypeReferenceType type) {
        String varName = JvmCodeGenUtil.getRefTypeConstantName(type);
        if (this.typeDefCount % 100 == 0 && this.typeDefCount != 0) {
            this.mv.visitMethodInsn(184, this.typeRefVarConstantsClass, "$typeref_type_init" + this.methodCount, "()V", false);
            JvmConstantGenCommons.genMethodReturn(this.mv);
            this.mv = this.cw.visitMethod(8, "$typeref_type_init" + this.methodCount++, "()V", null, null);
        }
        this.visitTypeRefField(varName);
        this.createTypeRefType(type, varName);
        this.genPopulateMethod(type, varName);
        ++this.typeDefCount;
        return varName;
    }

    private void visitRefTypePopulateInitMethod() {
        int populateFuncCount = 0;
        int populateInitMethodCount = 1;
        MethodVisitor mv = this.cw.visitMethod(9, "$populate_typeref_types", "()V", null, null);
        for (String funcName : this.funcNames) {
            if (populateFuncCount % 100 == 0 && populateFuncCount != 0) {
                mv.visitMethodInsn(184, this.typeRefVarConstantsClass, "$populate_typeref_types" + populateInitMethodCount, "()V", false);
                JvmConstantGenCommons.genMethodReturn(mv);
                mv = this.cw.visitMethod(8, "$populate_typeref_types" + populateInitMethodCount++, "()V", null, null);
            }
            mv.visitMethodInsn(184, this.typeRefVarConstantsClass, funcName, "()V", false);
            ++populateFuncCount;
        }
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void genPopulateMethod(BTypeReferenceType referenceType, String varName) {
        String methodName = "$populate" + varName;
        this.funcNames.add(methodName);
        MethodVisitor methodVisitor = this.cw.visitMethod(8, methodName, "()V", null, null);
        methodVisitor.visitCode();
        this.generateGetBTypeRefType(methodVisitor, varName);
        this.jvmRefTypeGen.populateTypeRef(methodVisitor, referenceType);
        JvmConstantGenCommons.genMethodReturn(methodVisitor);
    }

    private void createTypeRefType(BTypeReferenceType type, String varName) {
        this.jvmRefTypeGen.createTypeRefType(this.mv, type);
        this.mv.visitFieldInsn(179, this.typeRefVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BTypeReferenceType;");
    }

    private void visitTypeRefField(String varName) {
        FieldVisitor fv = this.cw.visitField(9, varName, "Lio/ballerina/runtime/internal/types/BTypeReferenceType;", null, null);
        fv.visitEnd();
    }

    public void generateGetBTypeRefType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.typeRefVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BTypeReferenceType;");
    }

    public void generateClass(JarEntries jarEntries) {
        JvmConstantGenCommons.genMethodReturn(this.mv);
        this.visitRefTypePopulateInitMethod();
        this.cw.visitEnd();
        jarEntries.put(this.typeRefVarConstantsClass + ".class", this.cw.toByteArray());
    }

    public String getRefTypeConstantsClass() {
        return this.typeRefVarConstantsClass;
    }
}

