/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.bir.BIRGenUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.optimizer.BIROptimizer;

public class BIRBasicBlockOptimizer
extends BIRVisitor {
    private BIROptimizer.OptimizerEnv env;
    private final Map<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>> predecessorMap = new HashMap<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>>();

    public void optimizeNode(BIRNode node, BIROptimizer.OptimizerEnv env) {
        if (node == null) {
            return;
        }
        BIROptimizer.OptimizerEnv oldEnv = this.env;
        this.env = env;
        node.accept(this);
        this.env = oldEnv;
    }

    public void optimizeTerm(BIRTerminator term, BIROptimizer.OptimizerEnv env) {
        this.optimizeNode(term, env);
    }

    @Override
    public void visit(BIRNode.BIRPackage birPackage) {
        birPackage.typeDefs.forEach(tDef -> tDef.accept(this));
        birPackage.functions.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRTypeDefinition birTypeDefinition) {
        birTypeDefinition.attachedFuncs.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRFunction birFunction) {
        BIRGenUtils.rearrangeBasicBlocks(birFunction);
        BIROptimizer.OptimizerEnv funcEnv = new BIROptimizer.OptimizerEnv();
        this.populatePredecessorMap(birFunction.basicBlocks);
        Set<BIRNode.BIRBasicBlock> removableGOTOBasicBlocks = this.getRemovableBasicBlocks(birFunction, funcEnv);
        this.resetEndBasicBlock(birFunction, removableGOTOBasicBlocks);
        birFunction.basicBlocks.removeAll(removableGOTOBasicBlocks);
        BIRGenUtils.rearrangeBasicBlocks(birFunction);
    }

    private void populatePredecessorMap(List<BIRNode.BIRBasicBlock> basicBlocks) {
        this.predecessorMap.clear();
        for (BIRNode.BIRBasicBlock basicBlock : basicBlocks) {
            this.predecessorMap.computeIfAbsent(basicBlock, k -> new ArrayList());
            for (BIRNode.BIRBasicBlock bb : basicBlock.terminator.getNextBasicBlocks()) {
                this.predecessorMap.computeIfAbsent(bb, k -> new ArrayList()).add(basicBlock);
            }
        }
    }

    private void updatePredecessorMap(BIRNode.BIRBasicBlock removable) {
        this.predecessorMap.remove(removable);
        for (Map.Entry<BIRNode.BIRBasicBlock, List<BIRNode.BIRBasicBlock>> entry : this.predecessorMap.entrySet()) {
            BIRNode.BIRBasicBlock key = entry.getKey();
            List<BIRNode.BIRBasicBlock> predecessorList = entry.getValue();
            if (!predecessorList.contains(removable)) continue;
            this.predecessorMap.get(key).remove(removable);
        }
    }

    private Set<BIRNode.BIRBasicBlock> getRemovableBasicBlocks(BIRNode.BIRFunction birFunction, BIROptimizer.OptimizerEnv funcEnv) {
        HashSet<BIRNode.BIRBasicBlock> errorTableTargetBBs = new HashSet<BIRNode.BIRBasicBlock>();
        for (BIRNode.BIRErrorEntry birErrorEntry : birFunction.errorTable) {
            errorTableTargetBBs.add(birErrorEntry.targetBB);
        }
        HashSet<BIRNode.BIRBasicBlock> removableBasicBlocks = new HashSet<BIRNode.BIRBasicBlock>();
        for (int i = birFunction.basicBlocks.size() - 1; i >= 0; --i) {
            BIRNode.BIRBasicBlock basicBlock = birFunction.basicBlocks.get(i);
            if (!(basicBlock.terminator instanceof BIRTerminator.GOTO) || !basicBlock.instructions.isEmpty() || basicBlock.terminator.pos != null || errorTableTargetBBs.contains(basicBlock)) continue;
            boolean isLoopBB = false;
            BIRNode.BIRBasicBlock targetBB = ((BIRTerminator.GOTO)basicBlock.terminator).targetBB;
            List<BIRNode.BIRBasicBlock> predecessorBBs = this.predecessorMap.get(targetBB);
            for (BIRNode.BIRBasicBlock bb : predecessorBBs) {
                if (targetBB.number >= bb.number) continue;
                isLoopBB = true;
                break;
            }
            if (isLoopBB) continue;
            funcEnv.currentBB = basicBlock;
            funcEnv.nextBB = targetBB;
            this.optimizeNode(basicBlock, funcEnv);
            birFunction.errorTable.forEach(errorEntry -> this.optimizeNode((BIRNode)errorEntry, funcEnv));
            this.updatePredecessorMap(basicBlock);
            removableBasicBlocks.add(basicBlock);
        }
        return removableBasicBlocks;
    }

    private void resetEndBasicBlock(BIRNode.BIRFunction birFunc, Set<BIRNode.BIRBasicBlock> removableBBs) {
        for (BIRNode.BIRVariableDcl localVar : birFunc.localVars) {
            if (localVar.endBB == null || !removableBBs.contains(localVar.endBB)) continue;
            int index = birFunc.basicBlocks.indexOf(localVar.endBB);
            localVar.endBB = this.getLocalVarEndBB(birFunc, removableBBs, index);
        }
    }

    private BIRNode.BIRBasicBlock getLocalVarEndBB(BIRNode.BIRFunction birFunc, Set<BIRNode.BIRBasicBlock> removableBBs, int index) {
        if (!removableBBs.contains(birFunc.basicBlocks.get(++index))) {
            return birFunc.basicBlocks.get(index);
        }
        return this.getLocalVarEndBB(birFunc, removableBBs, index);
    }

    @Override
    public void visit(BIRNode.BIRBasicBlock basicBlock) {
        this.predecessorMap.get(basicBlock).forEach(bb -> this.optimizeTerm(bb.terminator, this.env));
    }

    @Override
    public void visit(BIRNode.BIRErrorEntry errorEntry) {
        if (errorEntry.endBB == this.env.currentBB) {
            errorEntry.endBB = this.env.nextBB;
        }
        if (errorEntry.trapBB == this.env.currentBB) {
            errorEntry.trapBB = this.env.nextBB;
        }
        if (errorEntry.targetBB == this.env.currentBB) {
            errorEntry.targetBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.GOTO birGoto) {
        if (birGoto.targetBB == this.env.currentBB) {
            birGoto.targetBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Call birCall) {
        if (birCall.thenBB == this.env.currentBB) {
            birCall.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.AsyncCall birCall) {
        if (birCall.thenBB == this.env.currentBB) {
            birCall.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.FPCall fpCall) {
        if (fpCall.thenBB == this.env.currentBB) {
            fpCall.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Return birReturn) {
    }

    @Override
    public void visit(BIRTerminator.Branch birBranch) {
        if (birBranch.trueBB == this.env.currentBB) {
            birBranch.trueBB = this.env.nextBB;
        }
        if (birBranch.falseBB == this.env.currentBB) {
            birBranch.falseBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Lock lock) {
        if (lock.lockedBB == this.env.currentBB) {
            lock.lockedBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.FieldLock lock) {
        if (lock.lockedBB == this.env.currentBB) {
            lock.lockedBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Unlock unlock) {
        if (unlock.unlockBB == this.env.currentBB) {
            unlock.unlockBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Panic birPanic) {
    }

    @Override
    public void visit(BIRTerminator.Wait birWait) {
        if (birWait.thenBB == this.env.currentBB) {
            birWait.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.WaitAll waitAll) {
        if (waitAll.thenBB == this.env.currentBB) {
            waitAll.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.Flush birFlush) {
        if (birFlush.thenBB == this.env.currentBB) {
            birFlush.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.WorkerReceive workerReceive) {
        if (workerReceive.thenBB == this.env.currentBB) {
            workerReceive.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.WorkerSend workerSend) {
        if (workerSend.thenBB == this.env.currentBB) {
            workerSend.thenBB = this.env.nextBB;
        }
    }

    @Override
    public void visit(BIRTerminator.WorkerAlternateReceive workerAlternateReceive) {
        if (workerAlternateReceive.thenBB == this.env.currentBB) {
            workerAlternateReceive.thenBB = this.env.nextBB;
        }
    }
}

