/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;

public class BIRLockOptimizer
extends BIRVisitor {
    private final List<BIRTerminator.Lock> lockList = new ArrayList<BIRTerminator.Lock>();
    private final Map<BIRTerminator.Lock, Integer> lockToSetMap = new HashMap<BIRTerminator.Lock, Integer>();
    private final Map<Integer, List<BIRTerminator.Lock>> setToLockMap = new HashMap<Integer, List<BIRTerminator.Lock>>();
    private int setId = -1;

    public void optimizeNode(BIRNode node) {
        node.accept(this);
        this.optimizeLocks();
    }

    private void optimizeLocks() {
        this.analyzeLocks();
        this.propagateLocks();
    }

    private void analyzeLocks() {
        for (int lockListIndex = 0; lockListIndex < this.lockList.size(); ++lockListIndex) {
            if (!this.lockToSetMap.containsKey(this.lockList.get(lockListIndex))) {
                this.analyzeUnvisitedLock(lockListIndex);
                continue;
            }
            this.analyzeVisitedLock(lockListIndex);
        }
    }

    private void propagateLocks() {
        for (Map.Entry<Integer, List<BIRTerminator.Lock>> entry : this.setToLockMap.entrySet()) {
            Integer lockId = entry.getKey();
            for (BIRTerminator.Lock lock : entry.getValue()) {
                lock.lockId = lockId;
            }
        }
    }

    private void analyzeVisitedLock(int lockListIndex) {
        BIRTerminator.Lock currentLock = this.lockList.get(lockListIndex);
        int previousSetId = this.setId;
        Integer currentSetIdLocal = this.lockToSetMap.get(currentLock);
        List<BIRTerminator.Lock> currentSet = this.setToLockMap.get(currentSetIdLocal);
        this.setId = currentSetIdLocal;
        this.populateLockSet(currentSet, currentLock, lockListIndex);
        this.setId = previousSetId;
    }

    private void analyzeUnvisitedLock(int lockListIndex) {
        BIRTerminator.Lock currentLock = this.lockList.get(lockListIndex);
        LinkedList<BIRTerminator.Lock> currentSet = new LinkedList<BIRTerminator.Lock>();
        this.lockToSetMap.put(currentLock, ++this.setId);
        currentSet.add(currentLock);
        this.populateLockSet(currentSet, currentLock, lockListIndex);
        this.setToLockMap.put(this.setId, currentSet);
    }

    private void populateLockSet(List<BIRTerminator.Lock> currentSet, BIRTerminator.Lock currentLock, int lockListIndex) {
        for (int i = lockListIndex + 1; i < this.lockList.size(); ++i) {
            BIRTerminator.Lock comparedLock = this.lockList.get(i);
            Set<BIRNode.BIRGlobalVariableDcl> globalVarSetOfComparedLock = comparedLock.lockVariables;
            if (!this.isSharedLock(currentLock, globalVarSetOfComparedLock) || !this.isNotInSameSet(currentLock, comparedLock)) continue;
            this.populateLockSet(currentSet, comparedLock);
        }
    }

    private boolean isNotInSameSet(BIRTerminator.Lock currentLock, BIRTerminator.Lock comparedLock) {
        Integer currentLockSetId = this.lockToSetMap.get(currentLock);
        Integer comparedLockSetId = this.lockToSetMap.get(comparedLock);
        if (currentLockSetId == null || comparedLockSetId == null) {
            return true;
        }
        return currentLockSetId.compareTo(comparedLockSetId) != 0;
    }

    private void populateLockSet(List<BIRTerminator.Lock> currentSet, BIRTerminator.Lock comparedLock) {
        if (this.lockToSetMap.containsKey(comparedLock)) {
            Integer comparedLocksSetId = this.lockToSetMap.get(comparedLock);
            List<BIRTerminator.Lock> previousSet = this.setToLockMap.get(comparedLocksSetId);
            currentSet.addAll(previousSet);
            this.setToLockMap.remove(comparedLocksSetId);
            for (BIRTerminator.Lock lock : previousSet) {
                this.lockToSetMap.put(lock, this.setId);
            }
        } else {
            currentSet.add(comparedLock);
        }
        this.lockToSetMap.put(comparedLock, this.setId);
    }

    private boolean isSharedLock(BIRTerminator.Lock currentLock, Set<BIRNode.BIRGlobalVariableDcl> globalVarSetOfComparedLock) {
        for (BIRNode.BIRGlobalVariableDcl globalVarOfCurLock : currentLock.lockVariables) {
            if (!globalVarSetOfComparedLock.contains(globalVarOfCurLock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BIRNode.BIRPackage birPackage) {
        birPackage.typeDefs.forEach(tDef -> tDef.accept(this));
        birPackage.functions.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRTypeDefinition birTypeDefinition) {
        birTypeDefinition.attachedFuncs.forEach(func -> func.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRFunction birFunction) {
        birFunction.basicBlocks.forEach(bb -> bb.accept(this));
    }

    @Override
    public void visit(BIRTerminator.GOTO birGoto) {
    }

    @Override
    public void visit(BIRTerminator.Call birCall) {
    }

    @Override
    public void visit(BIRTerminator.AsyncCall birCall) {
    }

    @Override
    public void visit(BIRTerminator.Return birReturn) {
    }

    @Override
    public void visit(BIRTerminator.Branch birBranch) {
    }

    @Override
    public void visit(BIRTerminator.FPCall fpCall) {
    }

    @Override
    public void visit(BIRTerminator.Lock lock) {
        this.lockList.add(lock);
    }

    @Override
    public void visit(BIRTerminator.FieldLock lock) {
    }

    @Override
    public void visit(BIRTerminator.Unlock unlock) {
    }

    @Override
    public void visit(BIRTerminator.Panic birPanic) {
    }

    @Override
    public void visit(BIRTerminator.Wait birWait) {
    }

    @Override
    public void visit(BIRTerminator.WaitAll waitAll) {
    }

    @Override
    public void visit(BIRTerminator.Flush birFlush) {
    }

    @Override
    public void visit(BIRTerminator.WorkerReceive workerReceive) {
    }

    @Override
    public void visit(BIRTerminator.WorkerSend workerSend) {
    }

    @Override
    public void visit(BIRTerminator.WorkerAlternateReceive workerAlternateReceive) {
    }

    @Override
    public void visit(BIRTerminator.WorkerMultipleReceive workerMultipleReceive) {
    }

    @Override
    public void visit(BIRNode.BIRBasicBlock birBasicBlock) {
        BIRTerminator terminator = birBasicBlock.terminator;
        terminator.accept(this);
    }
}

