/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.util.Name;

public final class BIRWriterUtils {
    private BIRWriterUtils() {
    }

    public static void writePosition(Location pos, ByteBuf buf, ConstantPool cp) {
        int sLine = Integer.MIN_VALUE;
        int eLine = Integer.MIN_VALUE;
        int sCol = Integer.MIN_VALUE;
        int eCol = Integer.MIN_VALUE;
        String sourceFileName = "";
        if (pos != null) {
            sLine = pos.lineRange().startLine().line();
            eLine = pos.lineRange().endLine().line();
            sCol = pos.lineRange().startLine().offset();
            eCol = pos.lineRange().endLine().offset();
            if (pos.lineRange().fileName() != null) {
                sourceFileName = pos.lineRange().fileName();
            }
        }
        buf.writeInt(BIRWriterUtils.addStringCPEntry(sourceFileName, cp));
        buf.writeInt(sLine);
        buf.writeInt(sCol);
        buf.writeInt(eLine);
        buf.writeInt(eCol);
    }

    public static int addStringCPEntry(String value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    public static int addPkgCPEntry(PackageID packageID, ConstantPool cp) {
        int orgCPIndex = BIRWriterUtils.addStringCPEntry(packageID.orgName.getValue(), cp);
        int pkgNameCPIndex = BIRWriterUtils.addStringCPEntry(packageID.pkgName.getValue(), cp);
        int moduleNameCPIndex = BIRWriterUtils.addStringCPEntry(packageID.name.getValue(), cp);
        int versionCPIndex = BIRWriterUtils.addStringCPEntry(packageID.version.getValue(), cp);
        return cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, pkgNameCPIndex, moduleNameCPIndex, versionCPIndex));
    }

    public static void writeConstValue(ConstantPool cp, ByteBuf buf, BIRNode.ConstValue constValue) {
        BIRWriterUtils.writeConstValue(cp, buf, constValue.value, constValue.type);
    }

    public static void writeConstValue(ConstantPool cp, ByteBuf buf, Object value, BType type) {
        switch (Types.getImpliedType((BType)type).tag) {
            case 1: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                buf.writeInt(BIRWriterUtils.addIntCPEntry((Long)value, cp));
                break;
            }
            case 2: {
                int byteValue = ((Number)value).intValue();
                buf.writeInt(BIRWriterUtils.addByteCPEntry(byteValue, cp));
                break;
            }
            case 3: {
                double doubleVal = value instanceof String ? Double.parseDouble((String)value) : (Double)value;
                buf.writeInt(BIRWriterUtils.addFloatCPEntry(doubleVal, cp));
                break;
            }
            case 4: 
            case 5: 
            case 45: {
                buf.writeInt(BIRWriterUtils.addStringCPEntry((String)value, cp));
                break;
            }
            case 6: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                Map mapConstVal = (Map)value;
                buf.writeInt(mapConstVal.size());
                mapConstVal.forEach((key, fieldValue) -> {
                    buf.writeInt(BIRWriterUtils.addStringCPEntry(key, cp));
                    BIRWriterUtils.writeType(cp, buf, fieldValue.type);
                    BIRWriterUtils.writeConstValue(cp, buf, fieldValue);
                });
                break;
            }
            case 31: {
                BIRNode.ConstValue[] tupleConstVal = (BIRNode.ConstValue[])value;
                buf.writeInt(tupleConstVal.length);
                for (BIRNode.ConstValue memValue : tupleConstVal) {
                    BIRWriterUtils.writeType(cp, buf, memValue.type);
                    BIRWriterUtils.writeConstValue(cp, buf, memValue);
                }
                break;
            }
            case 22: {
                BType effectiveType = ((BIntersectionType)type).effectiveType;
                BIRWriterUtils.writeConstValue(cp, buf, new BIRNode.ConstValue(value, effectiveType));
                break;
            }
            default: {
                throw new UnsupportedOperationException("finite type value is not supported for type: " + String.valueOf(type));
            }
        }
    }

    public static int addIntCPEntry(long value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.IntegerCPEntry(value));
    }

    public static int addFloatCPEntry(double value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.FloatCPEntry(value));
    }

    public static int addByteCPEntry(int value, ConstantPool cp) {
        return cp.addCPEntry(new CPEntry.ByteCPEntry(value));
    }

    public static void writeType(ConstantPool cp, ByteBuf buf, BType type) {
        buf.writeInt(cp.addShapeCPEntry(type));
    }

    public static void writeAnnotAttachments(ConstantPool cp, ByteBuf buff, List<BIRNode.BIRAnnotationAttachment> annotAttachments) {
        ByteBuf annotBuf = Unpooled.buffer();
        annotBuf.writeInt(annotAttachments.size());
        for (BIRNode.BIRAnnotationAttachment annotAttachment : annotAttachments) {
            BIRWriterUtils.writeAnnotAttachment(cp, annotBuf, annotAttachment);
        }
        int length = annotBuf.nioBuffer().limit();
        buff.writeLong((long)length);
        buff.writeBytes(annotBuf.nioBuffer().array(), 0, length);
    }

    public static void writeAnnotAttachment(ConstantPool cp, ByteBuf annotBuf, BIRNode.BIRAnnotationAttachment annotAttachment) {
        annotBuf.writeInt(BIRWriterUtils.addPkgCPEntry(annotAttachment.annotPkgId, cp));
        BIRWriterUtils.writePosition(annotAttachment.pos, annotBuf, cp);
        annotBuf.writeInt(BIRWriterUtils.addStringCPEntry(annotAttachment.annotTagRef.value, cp));
        if (!(annotAttachment instanceof BIRNode.BIRConstAnnotationAttachment)) {
            annotBuf.writeBoolean(false);
            return;
        }
        annotBuf.writeBoolean(true);
        BIRNode.ConstValue constValue = ((BIRNode.BIRConstAnnotationAttachment)annotAttachment).annotValue;
        BIRWriterUtils.writeType(cp, annotBuf, constValue.type);
        BIRWriterUtils.writeConstValue(cp, annotBuf, constValue);
    }

    public static List<BIRNode.BIRAnnotationAttachment> getBIRAnnotAttachments(List<? extends AnnotationAttachmentSymbol> astAnnotAttachments) {
        ArrayList<BIRNode.BIRAnnotationAttachment> annotationAttachments = new ArrayList<BIRNode.BIRAnnotationAttachment>(astAnnotAttachments.size());
        for (AnnotationAttachmentSymbol annotationAttachmentSymbol : astAnnotAttachments) {
            annotationAttachments.add(BIRWriterUtils.createBIRAnnotationAttachment((BAnnotationAttachmentSymbol)annotationAttachmentSymbol));
        }
        return annotationAttachments;
    }

    public static BIRNode.BIRAnnotationAttachment createBIRAnnotationAttachment(BAnnotationAttachmentSymbol annotAttachmentSymbol) {
        Location pos = annotAttachmentSymbol.pos;
        PackageID annotPkgID = annotAttachmentSymbol.annotPkgID;
        Name annotTag = annotAttachmentSymbol.annotTag;
        if (!annotAttachmentSymbol.isConstAnnotation()) {
            return new BIRNode.BIRAnnotationAttachment(pos, annotPkgID, annotTag);
        }
        BLangConstantValue attachmentValue = ((BAnnotationAttachmentSymbol.BConstAnnotationAttachmentSymbol)annotAttachmentSymbol).attachmentValueSymbol.value;
        return new BIRNode.BIRConstAnnotationAttachment(pos, annotPkgID, annotTag, BIRWriterUtils.getBIRConstantVal(attachmentValue));
    }

    public static BIRNode.ConstValue getBIRConstantVal(BLangConstantValue constValue) {
        BType type = constValue.type;
        int tag = Types.getImpliedType((BType)type).tag;
        if (tag == 12) {
            HashMap mapConstVal = new HashMap();
            ((Map)constValue.value).forEach((key, value) -> mapConstVal.put(key, BIRWriterUtils.getBIRConstantVal(value)));
            return new BIRNode.ConstValue(mapConstVal, type);
        }
        if (tag == 31) {
            List constantValueList = (List)constValue.value;
            BIRNode.ConstValue[] tupleConstVal = new BIRNode.ConstValue[constantValueList.size()];
            for (int exprIndex = 0; exprIndex < constantValueList.size(); ++exprIndex) {
                tupleConstVal[exprIndex] = BIRWriterUtils.getBIRConstantVal((BLangConstantValue)constantValueList.get(exprIndex));
            }
            return new BIRNode.ConstValue(tupleConstVal, type);
        }
        return new BIRNode.ConstValue(constValue.value, constValue.type);
    }
}

