/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class LargeMethodSplitter {
    private static final String SPLIT_START_FUNCTIONS_CLASS_NAME = "$_start";
    private static final String SPLIT_STOP_FUNCTIONS_CLASS_NAME = "$_stop";
    private int initFuncIndex = 0;
    private int startFuncIndex = 0;
    private int stopFuncIndex = 0;
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final Names names;
    private final SymbolResolver symResolver;
    private static final CompilerContext.Key<LargeMethodSplitter> LARGE_METHOD_SPLITTER_KEY = new CompilerContext.Key();

    public static LargeMethodSplitter getInstance(CompilerContext context) {
        LargeMethodSplitter largeMethodSplitter = context.get(LARGE_METHOD_SPLITTER_KEY);
        if (largeMethodSplitter == null) {
            largeMethodSplitter = new LargeMethodSplitter(context);
        }
        return largeMethodSplitter;
    }

    private LargeMethodSplitter(CompilerContext context) {
        context.put(LARGE_METHOD_SPLITTER_KEY, this);
        this.desugar = Desugar.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
    }

    void splitLargeFunctions(BLangPackage pkgNode, SymbolEnv env) {
        pkgNode.initFunction = this.splitInitFunction(pkgNode, env);
        pkgNode.startFunction = this.splitStartFunction(pkgNode, env);
        pkgNode.stopFunction = this.splitStopFunction(pkgNode, env);
    }

    private static BLangDiagnosticLocation getNewFuncPos(Location packageNodePos, String packageFileName, int splitInitFuncClassCount) {
        LineRange lineRange = packageNodePos.lineRange();
        TextRange textRange = packageNodePos.textRange();
        LinePosition startLine = lineRange.startLine();
        LinePosition endLine = lineRange.endLine();
        return new BLangDiagnosticLocation(packageFileName + "$" + splitInitFuncClassCount, startLine.line(), endLine.line(), startLine.offset(), endLine.offset(), textRange.startOffset(), textRange.length());
    }

    private BLangFunction splitInitFunction(BLangPackage packageNode, SymbolEnv env) {
        BLangStatement statement;
        int splitInitFuncClassCount = 1;
        int splitFuncCount = 0;
        Location packageNodePos = packageNode.pos;
        String packageFileName = packageNodePos.lineRange().fileName();
        BLangDiagnosticLocation newFuncPos = LargeMethodSplitter.getNewFuncPos(packageNodePos, packageFileName, splitInitFuncClassCount);
        ++splitInitFuncClassCount;
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)packageNode.initFunction.body;
        BLangFunction initFunction = packageNode.initFunction;
        ArrayList<BLangFunction> generatedFunctions = new ArrayList<BLangFunction>();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(funcBody.stmts);
        funcBody.stmts.clear();
        BLangFunction newFunc = initFunction;
        BLangBlockFunctionBody newFuncBody = (BLangBlockFunctionBody)newFunc.body;
        int varDefIndex = 0;
        for (int i = 0; i < stmts.size() && (statement = (BLangStatement)stmts.get(i)).getKind() != NodeKind.VARIABLE_DEF; ++i) {
            ++varDefIndex;
            if (i > 0 && (i % 50 == 0 || this.isAssignmentWithInitOrRecordLiteralExpr(statement))) {
                generatedFunctions.add(newFunc);
                newFunc = this.createIntermediateInitFunction(packageNode, env);
                if (++splitFuncCount % 100 == 0) {
                    newFuncPos = LargeMethodSplitter.getNewFuncPos(packageNodePos, packageFileName, splitInitFuncClassCount);
                    ++splitInitFuncClassCount;
                }
                newFunc.pos = newFuncPos;
                newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
            }
            newFuncBody.stmts.add((BLangStatement)stmts.get(i));
        }
        newFuncBody.stmts.addAll(stmts.subList(varDefIndex, stmts.size()));
        generatedFunctions.add(newFunc);
        for (int j = 0; j < generatedFunctions.size() - 1; ++j) {
            BLangFunction thisFunction = (BLangFunction)generatedFunctions.get(j);
            BLangCheckedExpr checkedExpr = ASTBuilderUtil.createCheckExpr(initFunction.pos, this.desugar.createInvocationNode(((BLangFunction)generatedFunctions.get((int)(j + 1))).name.value, new ArrayList<BLangExpression>(), this.symTable.errorOrNilType), this.symTable.nilType);
            checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
            BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(thisFunction.pos, (BLangBlockFunctionBody)thisFunction.body);
            expressionStmt.expr = checkedExpr;
            expressionStmt.expr.pos = initFunction.pos;
            if (j <= 0) continue;
            thisFunction = this.desugar.rewrite(thisFunction, env);
            packageNode.functions.add(thisFunction);
            packageNode.topLevelNodes.add(thisFunction);
        }
        this.rewriteLastSplitFunction(packageNode, env, generatedFunctions);
        this.initFuncIndex = 0;
        return (BLangFunction)generatedFunctions.get(0);
    }

    private boolean isAssignmentWithInitOrRecordLiteralExpr(BLangStatement statement) {
        if (statement.getKind() == NodeKind.ASSIGNMENT) {
            return this.desugar.isMappingOrObjectConstructorOrObjInit(((BLangAssignment)statement).getExpression());
        }
        return false;
    }

    private BLangFunction splitStartFunction(BLangPackage packageNode, SymbolEnv env) {
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)packageNode.startFunction.body;
        BLangFunction startFunction = packageNode.startFunction;
        ArrayList<BLangFunction> generatedFunctions = new ArrayList<BLangFunction>();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(funcBody.stmts);
        funcBody.stmts.clear();
        BLangFunction newFunc = startFunction;
        BLangBlockFunctionBody newFuncBody = (BLangBlockFunctionBody)newFunc.body;
        for (int i = 0; i < stmts.size() - 1; ++i) {
            if (i > 0 && i % 25 == 0) {
                generatedFunctions.add(newFunc);
                newFunc = this.createIntermediateStartFunction(packageNode, env);
                newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
            }
            newFuncBody.stmts.add((BLangStatement)stmts.get(i));
        }
        newFuncBody.stmts.add((BLangStatement)stmts.get(stmts.size() - 1));
        generatedFunctions.add(newFunc);
        for (int j = 0; j < generatedFunctions.size() - 1; ++j) {
            BLangFunction thisFunction = (BLangFunction)generatedFunctions.get(j);
            BLangCheckedExpr checkedExpr = ASTBuilderUtil.createCheckExpr(startFunction.pos, this.desugar.createInvocationNode(((BLangFunction)generatedFunctions.get((int)(j + 1))).name.value, new ArrayList<BLangExpression>(), this.symTable.errorOrNilType), this.symTable.nilType);
            checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
            BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(thisFunction.pos, (BLangBlockFunctionBody)thisFunction.body);
            expressionStmt.expr = checkedExpr;
            expressionStmt.expr.pos = startFunction.pos;
            if (j <= 0) continue;
            thisFunction = this.desugar.rewrite(thisFunction, env);
            packageNode.functions.add(thisFunction);
            packageNode.topLevelNodes.add(thisFunction);
        }
        this.rewriteLastSplitFunction(packageNode, env, generatedFunctions);
        this.startFuncIndex = 0;
        return (BLangFunction)generatedFunctions.get(0);
    }

    private BLangFunction splitStopFunction(BLangPackage packageNode, SymbolEnv env) {
        BLangBlockFunctionBody funcBody = (BLangBlockFunctionBody)packageNode.stopFunction.body;
        BLangFunction stopFunction = packageNode.stopFunction;
        ArrayList<BLangFunction> generatedFunctions = new ArrayList<BLangFunction>();
        ArrayList<BLangStatement> stmts = new ArrayList<BLangStatement>(funcBody.stmts);
        funcBody.stmts.clear();
        BLangFunction newFunc = stopFunction;
        BLangBlockFunctionBody newFuncBody = (BLangBlockFunctionBody)newFunc.body;
        for (int i = 0; i < stmts.size() - 1; ++i) {
            if (i > 0 && i % 25 == 0) {
                generatedFunctions.add(newFunc);
                newFunc = this.createIntermediateStopFunction(packageNode, env);
                newFuncBody = (BLangBlockFunctionBody)newFunc.body;
                this.symTable.rootScope.define(this.names.fromIdNode(newFunc.name), newFunc.symbol);
            }
            newFuncBody.stmts.add((BLangStatement)stmts.get(i));
        }
        newFuncBody.stmts.add((BLangStatement)stmts.get(stmts.size() - 1));
        generatedFunctions.add(newFunc);
        for (int j = 0; j < generatedFunctions.size() - 1; ++j) {
            BLangFunction thisFunction = (BLangFunction)generatedFunctions.get(j);
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)this.symTable.rootScope.lookup((Name)new Name((String)((BLangFunction)generatedFunctions.get((int)(j + 1))).name.value)).symbol;
            BLangInvocation invocationExpr = ASTBuilderUtil.createInvocationExpr(stopFunction.pos, invokableSymbol, new ArrayList<BLangSimpleVariable>(), this.symResolver);
            BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(thisFunction.pos, (BLangBlockFunctionBody)thisFunction.body);
            expressionStmt.expr = invocationExpr;
            expressionStmt.expr.pos = stopFunction.pos;
            if (j <= 0) continue;
            thisFunction = this.desugar.rewrite(thisFunction, env);
            packageNode.functions.add(thisFunction);
            packageNode.topLevelNodes.add(thisFunction);
        }
        this.rewriteLastSplitFunction(packageNode, env, generatedFunctions);
        this.stopFuncIndex = 0;
        return (BLangFunction)generatedFunctions.get(0);
    }

    private void rewriteLastSplitFunction(BLangPackage packageNode, SymbolEnv env, List<BLangFunction> generatedFunctions) {
        if (generatedFunctions.size() > 1) {
            BLangFunction lastFunc = generatedFunctions.get(generatedFunctions.size() - 1);
            lastFunc = this.desugar.rewrite(lastFunc, env);
            packageNode.functions.add(lastFunc);
            packageNode.topLevelNodes.add(lastFunc);
        }
    }

    private BLangFunction createIntermediateInitFunction(BLangPackage pkgNode, SymbolEnv env) {
        String alias = pkgNode.symbol.pkgID.toString();
        BLangFunction initFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(pkgNode.pos, alias, new Name(Names.INIT_FUNCTION_SUFFIX.value + this.initFuncIndex++), this.symTable);
        this.desugar.createInvokableSymbol(initFunction, env);
        return initFunction;
    }

    private BLangFunction createIntermediateStartFunction(BLangPackage pkgNode, SymbolEnv env) {
        String alias = pkgNode.symbol.pkgID.toString();
        BLangFunction startFunction = ASTBuilderUtil.createInitFunctionWithErrorOrNilReturn(new BLangDiagnosticLocation(SPLIT_START_FUNCTIONS_CLASS_NAME, 0, 0, 0, 0, 0, 0), alias, new Name(Names.START_FUNCTION_SUFFIX.value + this.startFuncIndex++), this.symTable);
        this.desugar.createInvokableSymbol(startFunction, env);
        return startFunction;
    }

    private BLangFunction createIntermediateStopFunction(BLangPackage pkgNode, SymbolEnv env) {
        String alias = pkgNode.symbol.pkgID.toString();
        BLangFunction stopFunction = ASTBuilderUtil.createInitFunctionWithNilReturn(new BLangDiagnosticLocation(SPLIT_STOP_FUNCTIONS_CLASS_NAME, 0, 0, 0, 0, 0, 0), alias, new Name(Names.STOP_FUNCTION_SUFFIX.value + this.stopFuncIndex++));
        this.desugar.createInvokableSymbol(stopFunction, env);
        return stopFunction;
    }
}

