/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.diagnostic;

import io.ballerina.compiler.api.impl.SymbolFactory;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnostic;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BCollectionProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BNumericProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BStringProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BSymbolicProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.NonCatProperty;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;

public class BLangDiagnosticLog
implements DiagnosticLog {
    private static final CompilerContext.Key<BLangDiagnosticLog> DIAGNOSTIC_LOG_KEY = new CompilerContext.Key();
    private static final String ERROR_PREFIX = "error";
    private static final String WARNING_PREFIX = "warning";
    private static final String NOTE_PREFIX = "note";
    private static final String HINT_PREFIX = "hint";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("compiler", Locale.getDefault());
    private int errorCount = 0;
    private final PackageCache packageCache;
    private final TypesFactory typesFactory;
    private final SymbolFactory symbolFactory;
    private PackageID currentPackageId;
    private boolean isMute = false;

    private BLangDiagnosticLog(CompilerContext context) {
        context.put(DIAGNOSTIC_LOG_KEY, this);
        this.packageCache = PackageCache.getInstance(context);
        this.typesFactory = TypesFactory.getInstance(context);
        this.symbolFactory = SymbolFactory.getInstance(context);
    }

    public static BLangDiagnosticLog getInstance(CompilerContext context) {
        BLangDiagnosticLog dLogger = context.get(DIAGNOSTIC_LOG_KEY);
        if (dLogger == null) {
            dLogger = new BLangDiagnosticLog(context);
        }
        return dLogger;
    }

    public void setCurrentPackageId(PackageID packageID) {
        this.currentPackageId = packageID;
    }

    public void error(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(ERROR_PREFIX, code, args);
        this.reportDiagnostic((ModuleDescriptor)null, code, location, msg, DiagnosticSeverity.ERROR, args);
    }

    public void warning(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(WARNING_PREFIX, code, args);
        this.reportDiagnostic((ModuleDescriptor)null, code, location, msg, DiagnosticSeverity.WARNING, args);
    }

    public void note(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(NOTE_PREFIX, code, args);
        this.reportDiagnostic((ModuleDescriptor)null, code, location, msg, DiagnosticSeverity.INFO, args);
    }

    public void hint(Location location, DiagnosticCode code, Object ... args) {
        String msg = this.formatMessage(HINT_PREFIX, code, args);
        this.reportDiagnostic((ModuleDescriptor)null, code, location, msg, DiagnosticSeverity.HINT, args);
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void resetErrorCount() {
        this.errorCount = 0;
    }

    public void mute() {
        this.isMute = true;
    }

    public void unmute() {
        this.isMute = false;
    }

    @Override
    @Deprecated
    public void logDiagnostic(DiagnosticSeverity severity, Location location, CharSequence message) {
        this.logDiagnostic(severity, (ModuleDescriptor)null, location, message);
    }

    @Override
    @Deprecated
    public void logDiagnostic(DiagnosticSeverity severity, PackageID pkgId, Location location, CharSequence message) {
        this.reportDiagnostic(pkgId, null, location, message.toString(), severity, new Object[0]);
    }

    @Override
    public void logDiagnostic(DiagnosticSeverity severity, ModuleDescriptor moduleDescriptor, Location location, CharSequence message) {
        this.reportDiagnostic(moduleDescriptor, null, location, message.toString(), severity, new Object[0]);
    }

    public void logDiagnostic(PackageID pkgId, Diagnostic diagnostic) {
        if (diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR) {
            ++this.errorCount;
        }
        this.storeDiagnosticInModule(pkgId, diagnostic);
    }

    private String formatMessage(String prefix, DiagnosticCode code, Object[] args) {
        String msgKey = MESSAGES.getString(prefix + "." + code.messageKey());
        return MessageFormat.format(msgKey, args);
    }

    private void reportDiagnostic(ModuleDescriptor moduleDescriptor, DiagnosticCode diagnosticCode, Location location, String msg, DiagnosticSeverity severity, Object[] args) {
        PackageID pkgId = null;
        if (moduleDescriptor != null) {
            pkgId = new PackageID(new Name(moduleDescriptor.org().value()), new Name(moduleDescriptor.name().toString()), new Name(moduleDescriptor.version().toString()));
        }
        this.reportDiagnostic(pkgId, diagnosticCode, location, msg, severity, args);
    }

    private void reportDiagnostic(PackageID packageID, DiagnosticCode diagnosticCode, Location location, String msg, DiagnosticSeverity severity, Object[] args) {
        if (severity == DiagnosticSeverity.ERROR) {
            ++this.errorCount;
        }
        if (this.isMute) {
            return;
        }
        DiagnosticInfo diagInfo = diagnosticCode != null ? new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), diagnosticCode.severity()) : new DiagnosticInfo(null, msg, severity);
        List<DiagnosticProperty<?>> argList = this.convertDiagArgsToProps(args);
        BLangDiagnostic diagnostic = new BLangDiagnostic(location, msg, diagInfo, diagnosticCode, argList);
        if (packageID != null) {
            this.storeDiagnosticInModule(packageID, diagnostic);
        } else {
            this.storeDiagnosticInModule(this.currentPackageId, diagnostic);
        }
    }

    private List<DiagnosticProperty<?>> convertDiagArgsToProps(Object[] args) {
        ArrayList diagArgs = new ArrayList();
        for (Object arg : args) {
            Object dArg;
            if (arg instanceof BType) {
                BType bType = (BType)arg;
                TypeSymbol tsybol = this.typesFactory.getTypeDescriptor(bType);
                dArg = new BSymbolicProperty(tsybol);
            } else if (arg instanceof BSymbol) {
                BSymbol symbolArg = (BSymbol)arg;
                Symbol symbol = this.symbolFactory.getBCompiledSymbol(symbolArg, symbolArg.getOriginalName().getValue());
                dArg = new BSymbolicProperty(symbol);
            } else if (arg instanceof String) {
                String s = (String)arg;
                dArg = new BStringProperty(s);
            } else if (arg instanceof Number) {
                Number n = (Number)arg;
                dArg = new BNumericProperty(n);
            } else if (arg instanceof Collection) {
                Collection collection = (Collection)arg;
                List<DiagnosticProperty<?>> diagProperties = this.convertDiagArgsToProps(collection.toArray());
                dArg = new BCollectionProperty(diagProperties);
            } else {
                dArg = new NonCatProperty(arg);
            }
            diagArgs.add((DiagnosticProperty<?>)dArg);
        }
        return diagArgs;
    }

    private void storeDiagnosticInModule(PackageID pkgId, Diagnostic diagnostic) {
        BLangPackage pkgNode = this.packageCache.get(pkgId);
        pkgNode.addDiagnostic(diagnostic);
    }
}

