/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.types.Core;
import io.ballerina.types.SemType;
import io.ballerina.types.Value;
import java.util.Optional;
import org.ballerinalang.model.tree.OperatorKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;

public final class ConditionResolver {
    private ConditionResolver() {
    }

    static BType checkConstCondition(Types types, SymbolTable symTable, BLangExpression condition) {
        switch (condition.getKind()) {
            case GROUP_EXPR: {
                return ConditionResolver.checkConstCondition(types, symTable, ((BLangGroupExpr)condition).expression);
            }
            case LITERAL: {
                Object value = ((BLangLiteral)condition).value;
                if (value instanceof Boolean) {
                    return value == Boolean.TRUE ? symTable.trueType : symTable.falseType;
                }
                return BFiniteType.newSingletonBFiniteType(null, SemTypeHelper.resolveSingletonType((BLangLiteral)condition));
            }
            case NUMERIC_LITERAL: {
                return BFiniteType.newSingletonBFiniteType(null, SemTypeHelper.resolveSingletonType((BLangLiteral)condition));
            }
            case TYPE_TEST_EXPR: {
                BLangTypeTestExpr typeTestExpr = (BLangTypeTestExpr)condition;
                BType exprType = typeTestExpr.expr.getBType();
                boolean isAssignable = types.isAssignable(exprType, typeTestExpr.typeNode.getBType());
                if (typeTestExpr.isNegation) {
                    return isAssignable ? symTable.falseType : (exprType == symTable.semanticError ? symTable.trueType : symTable.semanticError);
                }
                return isAssignable ? symTable.trueType : (exprType == symTable.semanticError ? symTable.falseType : symTable.semanticError);
            }
            case BINARY_EXPR: {
                boolean operatorIsNotEqual;
                BLangBinaryExpr binaryExpr = (BLangBinaryExpr)condition;
                boolean operatorIsAND = binaryExpr.opKind == OperatorKind.AND;
                boolean operatorIsOR = binaryExpr.opKind == OperatorKind.OR;
                boolean operatorIsEqual = binaryExpr.opKind == OperatorKind.EQUAL;
                boolean bl = operatorIsNotEqual = binaryExpr.opKind == OperatorKind.NOT_EQUAL;
                if (!(operatorIsAND || operatorIsOR || operatorIsEqual || operatorIsNotEqual)) {
                    return symTable.semanticError;
                }
                BType lhsConst = ConditionResolver.checkConstCondition(types, symTable, binaryExpr.lhsExpr);
                if (operatorIsOR && lhsConst == symTable.trueType) {
                    return lhsConst;
                }
                BType rhsConst = ConditionResolver.checkConstCondition(types, symTable, binaryExpr.rhsExpr);
                if (operatorIsOR) {
                    if (rhsConst == symTable.trueType) {
                        return rhsConst;
                    }
                    if (lhsConst == rhsConst && lhsConst == symTable.falseType) {
                        return lhsConst;
                    }
                    return symTable.semanticError;
                }
                if (operatorIsAND) {
                    if (lhsConst == symTable.falseType || rhsConst == symTable.falseType) {
                        return symTable.falseType;
                    }
                    if (lhsConst == symTable.semanticError || rhsConst == symTable.semanticError) {
                        return symTable.semanticError;
                    }
                    return lhsConst == rhsConst && lhsConst == symTable.trueType ? symTable.trueType : symTable.falseType;
                }
                if (!types.isSingletonType(lhsConst) || !types.isSingletonType(rhsConst)) {
                    return symTable.semanticError;
                }
                if (operatorIsEqual) {
                    return types.isSameSingletonType((BFiniteType)lhsConst, (BFiniteType)rhsConst) ? symTable.trueType : symTable.falseType;
                }
                return !types.isSameSingletonType((BFiniteType)lhsConst, (BFiniteType)rhsConst) ? symTable.trueType : symTable.falseType;
            }
            case UNARY_EXPR: {
                BType conditionValue = ConditionResolver.checkConstCondition(types, symTable, ((BLangUnaryExpr)condition).expr);
                if (conditionValue == symTable.trueType) {
                    return symTable.falseType;
                }
                if (conditionValue == symTable.falseType) {
                    return symTable.trueType;
                }
                return symTable.semanticError;
            }
            case SIMPLE_VARIABLE_REF: {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)condition;
                BType type = (simpleVarRef.symbol.tag & 0x100001CL) == 0x100001CL ? simpleVarRef.symbol.type : condition.getBType();
                BType baseType = Types.getImpliedType(type);
                if (baseType.tag != 33) {
                    return symTable.semanticError;
                }
                Optional val = Core.singleShape((SemType)baseType.semType());
                if (val.isEmpty()) {
                    return symTable.semanticError;
                }
                if (((Value)val.get()).value instanceof Boolean) {
                    return ((Value)val.get()).value == Boolean.TRUE ? symTable.trueType : symTable.falseType;
                }
                return baseType;
            }
        }
        return symTable.semanticError;
    }
}

