/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConditionResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.analyzer.cyclefind.GlobalVariableRefAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeySpecifier;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReTerm;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class DataflowAnalyzer
extends BLangNodeVisitor {
    private final SymbolResolver symResolver;
    private final Names names;
    private SymbolEnv env;
    private final SymbolTable symTable;
    private final BLangDiagnosticLog dlog;
    private final Types types;
    private Map<BSymbol, InitStatus> uninitializedVars;
    private Map<BSymbol, Location> unusedErrorVarsDeclaredWithVar;
    private Map<BSymbol, Location> unusedLocalVariables;
    private Map<BSymbol, Set<BSymbol>> globalNodeDependsOn;
    private Map<BSymbol, Set<BSymbol>> functionToDependency;
    private Map<BLangOnFailClause, Map<BSymbol, InitStatus>> possibleFailureUnInitVars;
    private Deque<BLangOnFailClause> enclosingOnFailClause;
    private boolean flowTerminated = false;
    private boolean possibleFailureReached = false;
    private boolean definiteFailureReached = false;
    private static final CompilerContext.Key<DataflowAnalyzer> DATAFLOW_ANALYZER_KEY = new CompilerContext.Key();
    private final Deque<BSymbol> currDependentSymbolDeque;
    private final GlobalVariableRefAnalyzer globalVariableRefAnalyzer;

    private DataflowAnalyzer(CompilerContext context) {
        context.put(DATAFLOW_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.types = Types.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.currDependentSymbolDeque = new ArrayDeque<BSymbol>();
        this.globalVariableRefAnalyzer = GlobalVariableRefAnalyzer.getInstance(context);
        this.unusedLocalVariables = new HashMap<BSymbol, Location>();
    }

    public static DataflowAnalyzer getInstance(CompilerContext context) {
        DataflowAnalyzer dataflowAnalyzer = context.get(DATAFLOW_ANALYZER_KEY);
        if (dataflowAnalyzer == null) {
            dataflowAnalyzer = new DataflowAnalyzer(context);
        }
        return dataflowAnalyzer;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.uninitializedVars = new LinkedHashMap<BSymbol, InitStatus>();
        this.globalNodeDependsOn = new LinkedHashMap<BSymbol, Set<BSymbol>>();
        this.functionToDependency = new HashMap<BSymbol, Set<BSymbol>>();
        this.possibleFailureUnInitVars = new LinkedHashMap<BLangOnFailClause, Map<BSymbol, InitStatus>>();
        this.enclosingOnFailClause = new ArrayDeque<BLangOnFailClause>();
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        this.analyzeNode(pkgNode, pkgEnv);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DATAFLOW_ANALYZE)) {
            return;
        }
        Map<BSymbol, Location> prevUnusedErrorVarsDeclaredWithVar = this.unusedErrorVarsDeclaredWithVar;
        this.unusedErrorVarsDeclaredWithVar = new HashMap<BSymbol, Location>();
        Map<BSymbol, Location> prevUnusedLocalVariables = this.unusedLocalVariables;
        this.unusedLocalVariables = new HashMap<BSymbol, Location>();
        ArrayList<TopLevelNode> sortedListOfNodes = new ArrayList<TopLevelNode>(pkgNode.globalVars);
        this.addModuleInitToSortedNodeList(pkgNode, sortedListOfNodes);
        this.addNodesToSortedNodeList(pkgNode, sortedListOfNodes);
        for (TopLevelNode topLevelNode : sortedListOfNodes) {
            if (this.isModuleInitFunction((BLangNode)((Object)topLevelNode))) {
                this.analyzeModuleInitFunc((BLangFunction)topLevelNode);
                continue;
            }
            if (topLevelNode.getKind() == NodeKind.CLASS_DEFN) {
                BLangClassDefinition classDef = (BLangClassDefinition)topLevelNode;
                if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR)) continue;
            }
            this.analyzeNode((BLangNode)((Object)topLevelNode), this.env);
        }
        this.checkForUninitializedGlobalVars(pkgNode.globalVars);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.visit((BLangPackage)testablePackage));
        this.globalVariableRefAnalyzer.analyzeAndReOrder(pkgNode, this.globalNodeDependsOn);
        this.globalVariableRefAnalyzer.populateFunctionDependencies(this.functionToDependency, pkgNode.globalVars);
        pkgNode.globalVariableDependencies = this.globalVariableRefAnalyzer.getGlobalVariablesDependsOn();
        this.checkUnusedImports(pkgNode.imports);
        this.emitUnusedVariableWarnings(this.unusedLocalVariables);
        this.unusedLocalVariables = prevUnusedLocalVariables;
        this.checkUnusedErrorVarsDeclaredWithVar();
        this.unusedErrorVarsDeclaredWithVar = prevUnusedErrorVarsDeclaredWithVar;
        pkgNode.completedPhases.add(CompilerPhase.DATAFLOW_ANALYZE);
    }

    private void addModuleInitToSortedNodeList(BLangPackage pkgNode, List<TopLevelNode> sortedListOfNodes) {
        for (TopLevelNode node : pkgNode.topLevelNodes) {
            if (!this.isModuleInitFunction((BLangNode)((Object)node))) continue;
            sortedListOfNodes.add(node);
            break;
        }
    }

    private void addNodesToSortedNodeList(BLangPackage pkgNode, List<TopLevelNode> sortedListOfNodes) {
        pkgNode.topLevelNodes.forEach(topLevelNode -> {
            if (!sortedListOfNodes.contains(topLevelNode)) {
                sortedListOfNodes.add((TopLevelNode)topLevelNode);
            }
        });
    }

    private boolean isModuleInitFunction(BLangNode node) {
        return node.getKind() == NodeKind.FUNCTION && Names.USER_DEFINED_INIT_SUFFIX.value.equals(((BLangFunction)node).name.value);
    }

    private void analyzeModuleInitFunc(BLangFunction funcNode) {
        Map<BSymbol, Location> prevUnusedLocalVariables = this.unusedLocalVariables;
        this.unusedLocalVariables = new HashMap<BSymbol, Location>();
        this.currDependentSymbolDeque.push(funcNode.symbol);
        SymbolEnv moduleInitFuncEnv = SymbolEnv.createModuleInitFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        for (BLangAnnotationAttachment bLangAnnotationAttachment : funcNode.annAttachments) {
            this.analyzeNode(bLangAnnotationAttachment.expr, this.env);
        }
        this.analyzeNode(funcNode.body, moduleInitFuncEnv);
        this.currDependentSymbolDeque.pop();
        this.emitUnusedVariableWarnings(this.unusedLocalVariables);
        this.unusedLocalVariables = prevUnusedLocalVariables;
    }

    private void checkForUninitializedGlobalVars(List<BLangVariable> globalVars) {
        for (BLangVariable globalVar : globalVars) {
            if (globalVar.getKind() != NodeKind.VARIABLE || !this.uninitializedVars.containsKey(globalVar.symbol)) continue;
            this.dlog.error(globalVar.pos, DiagnosticErrorCode.UNINITIALIZED_VARIABLE, globalVar.symbol);
        }
    }

    @Override
    public void visit(BLangResourceFunction funcNode) {
        this.visit((BLangFunction)funcNode);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        Map<BSymbol, Location> prevUnusedLocalVariables = this.unusedLocalVariables;
        this.unusedLocalVariables = new HashMap<BSymbol, Location>();
        this.currDependentSymbolDeque.push(funcNode.symbol);
        funcNode.annAttachments.forEach(bLangAnnotationAttachment -> this.analyzeNode(bLangAnnotationAttachment.expr, this.env));
        funcNode.requiredParams.forEach(param -> this.analyzeNode((BLangNode)param, funcEnv));
        this.analyzeNode(funcNode.restParam, funcEnv);
        if (funcNode.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            this.visitFunctionBodyWithDynamicEnv(funcNode, funcEnv);
        } else {
            this.analyzeBranch(funcNode.body, funcEnv);
        }
        this.currDependentSymbolDeque.pop();
        this.emitUnusedVariableWarnings(this.unusedLocalVariables);
        this.unusedLocalVariables = prevUnusedLocalVariables;
    }

    private void visitFunctionBodyWithDynamicEnv(BLangFunction funcNode, SymbolEnv funcEnv) {
        Map<BSymbol, Location> prevUnusedLocalVariables = this.unusedLocalVariables;
        this.unusedLocalVariables = new HashMap<BSymbol, Location>();
        this.unusedLocalVariables.putAll(prevUnusedLocalVariables);
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        this.uninitializedVars = this.copyUninitializedVars();
        this.flowTerminated = false;
        this.possibleFailureReached = false;
        this.definiteFailureReached = false;
        this.analyzeNode(funcNode.body, funcEnv);
        this.uninitializedVars = prevUninitializedVars;
        prevUnusedLocalVariables.keySet().removeIf(bSymbol -> !this.unusedLocalVariables.containsKey(bSymbol));
        this.unusedLocalVariables.keySet().removeAll(prevUnusedLocalVariables.keySet());
        this.emitUnusedVariableWarnings(this.unusedLocalVariables);
        this.unusedLocalVariables = prevUnusedLocalVariables;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        bodyEnv.isModuleInit = this.env.isModuleInit;
        for (BLangStatement statement : body.stmts) {
            this.analyzeNode(statement, bodyEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.analyzeNode(body.expr, bodyEnv);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts.forEach(statement -> this.analyzeNode((BLangNode)statement, blockEnv));
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        for (BLangLetVariable letVarDeclaration : letExpression.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), letExpression.env);
        }
        this.analyzeNode(letExpression.expr, letExpression.env);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangService service) {
        this.currDependentSymbolDeque.push(service.serviceClass.symbol);
        this.visit(service.serviceClass);
        for (BLangExpression attachedExpr : service.attachedExprs) {
            this.analyzeNode(attachedExpr, this.env);
        }
        service.annAttachments.forEach(bLangAnnotationAttachment -> this.analyzeNode(bLangAnnotationAttachment.expr, this.env));
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        BSymbol symbol = typeDefinition.symbol;
        if (typeDefinition.symbol.kind == SymbolKind.TYPE_DEF) {
            symbol = symbol.type.tsymbol;
        }
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(typeDefinition.typeNode, symbol.scope, this.env);
        this.currDependentSymbolDeque.push(symbol);
        this.analyzeNode(typeDefinition.typeNode, typeDefEnv);
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangClassDefinition classDef) {
        SymbolEnv preEnv = this.env;
        SymbolEnv env = this.env;
        Map<BSymbol, Location> prevUnusedLocalVariables = null;
        Map<BSymbol, InitStatus> prevUninitializedVars = null;
        boolean visitedOCE = false;
        if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR) && classDef.oceEnvData.capturedClosureEnv != null) {
            env = classDef.oceEnvData.capturedClosureEnv;
            prevUnusedLocalVariables = this.unusedLocalVariables;
            prevUninitializedVars = this.uninitializedVars;
            this.unusedLocalVariables = new HashMap<BSymbol, Location>();
            this.unusedLocalVariables.putAll(prevUnusedLocalVariables);
            this.uninitializedVars = this.copyUninitializedVars();
            this.flowTerminated = false;
            this.possibleFailureReached = false;
            this.definiteFailureReached = false;
            visitedOCE = true;
        }
        SymbolEnv objectEnv = SymbolEnv.createClassEnv(classDef, classDef.symbol.scope, env);
        this.currDependentSymbolDeque.push(classDef.symbol);
        for (BLangAnnotationAttachment bLangAnnotationAttachment : classDef.annAttachments) {
            this.analyzeNode(bLangAnnotationAttachment.expr, env);
        }
        classDef.fields.forEach(field -> this.analyzeNode((BLangNode)field, objectEnv));
        classDef.referencedFields.forEach(field -> this.analyzeNode((BLangNode)field, objectEnv));
        if (classDef.initFunction != null) {
            if (classDef.initFunction.body == null) {
                Optional<BLangFunction> outerFuncDef = objectEnv.enclPkg.functions.stream().filter(f -> f.symbol.name.equals(classDef.initFunction.symbol.name)).findFirst();
                outerFuncDef.ifPresent(bLangFunction -> {
                    classDef.initFunction = bLangFunction;
                });
            }
            if (classDef.initFunction.body != null) {
                Map<BSymbol, Location> prevUnusedLocalVars = this.unusedLocalVariables;
                this.unusedLocalVariables = new HashMap<BSymbol, Location>();
                if (classDef.initFunction.body.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
                    for (BLangStatement statement : ((BLangBlockFunctionBody)classDef.initFunction.body).stmts) {
                        this.analyzeNode(statement, objectEnv);
                    }
                } else if (classDef.initFunction.body.getKind() == NodeKind.EXPR_FUNCTION_BODY) {
                    this.analyzeNode(((BLangExprFunctionBody)classDef.initFunction.body).expr, objectEnv);
                }
                this.emitUnusedVariableWarnings(this.unusedLocalVariables);
                this.unusedLocalVariables = prevUnusedLocalVars;
            }
        }
        Stream.concat(classDef.fields.stream(), classDef.referencedFields.stream()).map(field -> {
            this.addTypeDependency(classDef.symbol, field.getBType(), new HashSet<BType>());
            return field;
        }).filter(field -> !Symbols.isPrivate(field.symbol)).forEach(field -> {
            if (this.uninitializedVars.containsKey(field.symbol)) {
                this.dlog.error(field.pos, DiagnosticErrorCode.OBJECT_UNINITIALIZED_FIELD, field.symbol);
            }
        });
        for (BLangFunction bLangFunction2 : classDef.functions) {
            this.analyzeNode(bLangFunction2, env);
        }
        for (BLangType bLangType : classDef.typeRefs) {
            this.analyzeNode(bLangType, env);
        }
        this.env = preEnv;
        if (visitedOCE) {
            this.uninitializedVars = prevUninitializedVars;
            prevUnusedLocalVariables.keySet().removeIf(bSymbol -> !this.unusedLocalVariables.containsKey(bSymbol));
            this.unusedLocalVariables = prevUnusedLocalVariables;
        }
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        BLangClassDefinition classDef = objectConstructorExpression.classNode;
        if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
            for (BSymbol symbol : oceData.closureFuncSymbols) {
                this.unusedLocalVariables.remove(symbol);
            }
            for (BSymbol symbol : oceData.closureBlockSymbols) {
                this.unusedLocalVariables.remove(symbol);
            }
        }
        this.visit(objectConstructorExpression.classNode);
        this.visit(objectConstructorExpression.typeInit);
        this.addDependency(objectConstructorExpression.getBType().tsymbol, objectConstructorExpression.classNode.symbol);
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        BLangSimpleVariable var = varDefNode.var;
        if (var.expr == null) {
            this.addUninitializedVar(var);
            this.analyzeNode(var.typeNode, this.env);
            BVarSymbol symbol = var.symbol;
            if (var.getKind() == NodeKind.VARIABLE && this.isLocalVariableDefinedWithNonWildCardBindingPattern(var)) {
                this.unusedLocalVariables.put(symbol, var.pos);
            }
            return;
        }
        this.analyzeNode(var, this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(BLangSimpleVariable variable) {
        boolean withInModuleVarLetExpr;
        BVarSymbol symbol = variable.symbol;
        this.analyzeNode(variable.typeNode, this.env);
        if (symbol == null) {
            if (variable.expr != null) {
                this.analyzeNode(variable.expr, this.env);
            }
            return;
        }
        this.currDependentSymbolDeque.push(symbol);
        if (variable.typeNode != null && variable.typeNode.getBType() != null) {
            BType type = variable.typeNode.getBType();
            this.recordGlobalVariableReferenceRelationship(Types.getImpliedType((BType)type).tsymbol);
        }
        boolean bl = withInModuleVarLetExpr = symbol.owner.tag == 0x8000000L && this.isGlobalVarSymbol(this.env.enclVarSym);
        if (withInModuleVarLetExpr) {
            BVarSymbol dependentVar = this.env.enclVarSym;
            this.currDependentSymbolDeque.push(dependentVar);
        }
        try {
            boolean varWithInferredTypeIncludingError = false;
            if (variable.isDeclaredWithVar) {
                varWithInferredTypeIncludingError = this.addVarIfInferredTypeIncludesError(variable);
            }
            if (!varWithInferredTypeIncludingError && this.isLocalVariableDefinedWithNonWildCardBindingPattern(variable) && !this.isVariableDeclaredForWorkerDeclaration(variable)) {
                this.unusedLocalVariables.put(symbol, variable.pos);
            }
            if (variable.expr != null) {
                this.analyzeNode(variable.expr, this.env);
                this.uninitializedVars.remove(symbol);
                return;
            }
            long varFlags = symbol.flags;
            if (Symbols.isFlagOn(varFlags, 0x80000000L) && Symbols.isFlagOn(varFlags, 256L)) {
                return;
            }
            BSymbol owner = symbol.owner;
            if (owner.tag != 4097L && owner.tag != 98396L) {
                return;
            }
            this.addUninitializedVar(variable);
        }
        finally {
            if (withInModuleVarLetExpr) {
                this.currDependentSymbolDeque.pop();
            }
            this.currDependentSymbolDeque.pop();
        }
    }

    private boolean isVariableDeclaredForWorkerDeclaration(BLangSimpleVariable variable) {
        BLangExpression expr = variable.expr;
        if (expr == null) {
            return false;
        }
        if (Symbols.isFlagOn(variable.symbol.flags, 0x800000L)) {
            return true;
        }
        return expr.getKind() == NodeKind.LAMBDA && ((BLangLambdaFunction)expr).function.flagSet.contains((Object)Flag.WORKER);
    }

    @Override
    public void visit(BLangAssignment assignment) {
        this.analyzeNode(assignment.expr, this.env);
        this.checkAssignment(assignment.varRef);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.analyzeNode(compoundAssignNode.expr, this.env);
        this.analyzeNode(compoundAssignNode.varRef, this.env);
        boolean resetOnFailInits = false;
        Map<BSymbol, InitStatus> onFailInitStatus = null;
        if (this.isOnFailEnclosed()) {
            onFailInitStatus = this.copyOnFailUninitializedVars(this.enclosingOnFailClause.peek());
            resetOnFailInits = onFailInitStatus.containsKey(compoundAssignNode.varRef.symbol);
        }
        this.checkAssignment(compoundAssignNode.varRef);
        if (resetOnFailInits) {
            this.updateUnInitVarsForOnFailClause(onFailInitStatus);
        }
        this.uninitializedVars.remove(compoundAssignNode.varRef.symbol);
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.terminateFlow();
    }

    @Override
    public void visit(BLangReturn returnNode) {
        this.analyzeNode(returnNode.expr, this.env);
        this.definiteFailureReached = true;
        this.terminateFlow();
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmt) {
        this.analyzeNode(xmlnsStmt.xmlnsDecl, this.env);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.analyzeNode(ifNode.expr, this.env);
        BranchResult ifResult = this.analyzeBranch(ifNode.body, this.env);
        BranchResult elseResult = this.analyzeBranch(ifNode.elseStmt, this.env);
        if (ifResult.possibleFailureUnInitVars != null && elseResult.possibleFailureUnInitVars != null) {
            this.updateUnInitVarsForOnFailClause(this.mergeUninitializedVars(ifResult.possibleFailureUnInitVars, elseResult.possibleFailureUnInitVars));
        }
        if (!(this.isOnFailEnclosed() && ifResult.definiteFailureReached && elseResult.definiteFailureReached)) {
            boolean ifExprConst;
            boolean bl = ifExprConst = ConditionResolver.checkConstCondition(this.types, this.symTable, ifNode.expr) == this.symTable.trueType;
            if (ifResult.flowTerminated) {
                this.uninitializedVars = elseResult.uninitializedVars;
                this.possibleFailureReached = ifResult.possibleFailureReached;
                if (ifExprConst) {
                    this.flowTerminated = true;
                    this.definiteFailureReached = ifResult.definiteFailureReached;
                }
                return;
            }
            if (elseResult.flowTerminated || ifExprConst) {
                this.uninitializedVars = ifResult.uninitializedVars;
                if (ifResult.possibleFailureUnInitVars != null) {
                    this.updateUnInitVarsForOnFailClause(ifResult.possibleFailureUnInitVars);
                }
                return;
            }
        }
        this.uninitializedVars = this.mergeUninitializedVars(ifResult.uninitializedVars, elseResult.uninitializedVars);
        this.flowTerminated = ifResult.flowTerminated && elseResult.flowTerminated;
        this.definiteFailureReached = this.isDefiniteFailureCase(ifResult, elseResult);
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        this.analyzeNode(matchStatement.expr, this.env);
        if (matchStatement.onFailClause != null) {
            this.analyzeNode(matchStatement.onFailClause, this.env);
        }
        Map<BSymbol, InitStatus> uninitVars = new HashMap<BSymbol, InitStatus>();
        BranchResult lastPatternResult = null;
        for (int i = 0; i < matchStatement.getMatchClauses().size(); ++i) {
            BLangMatchClause matchClause = matchStatement.getMatchClauses().get(i);
            if (this.isLastPatternContainsIn(matchClause)) {
                lastPatternResult = this.analyzeBranch(matchClause, this.env);
                continue;
            }
            BranchResult result = this.analyzeBranch(matchClause, this.env);
            if (result.flowTerminated) continue;
            uninitVars = this.mergeUninitializedVars(uninitVars, result.uninitializedVars);
        }
        if (lastPatternResult != null) {
            uninitVars = this.mergeUninitializedVars(uninitVars, lastPatternResult.uninitializedVars);
            this.uninitializedVars = uninitVars;
            return;
        }
        uninitVars = this.mergeUninitializedVars(new HashMap<BSymbol, InitStatus>(), this.uninitializedVars);
        this.uninitializedVars = uninitVars;
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        Location pos = matchClause.pos;
        for (BVarSymbol symbol : matchClause.declaredVars.values()) {
            if (this.isWildCardBindingPattern(symbol)) continue;
            this.unusedLocalVariables.put(symbol, pos);
        }
        this.analyzeNode(matchClause.matchGuard, this.env);
        this.analyzeNode(matchClause.blockStmt, this.env);
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.analyzeNode(matchGuard.expr, this.env);
    }

    private boolean isLastPatternContainsIn(BLangMatchClause matchClause) {
        for (BLangMatchPattern pattern : matchClause.matchPatterns) {
            if (!pattern.isLastPattern) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangForeach foreach) {
        BLangExpression collection = foreach.collection;
        if (this.isNotRangeExpr(collection)) {
            this.populateUnusedVariableMapForMembers(this.unusedLocalVariables, (BLangVariable)foreach.variableDefinitionNode.getVariable());
        }
        this.analyzeNode(collection, this.env);
        this.analyzeStmtWithOnFail(foreach.body, foreach.onFailClause);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        for (BLangNode clause : queryAction.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
    }

    @Override
    public void visit(BLangWhile whileNode) {
        boolean failuresSelfHandled;
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        this.analyzeNode(whileNode.expr, this.env);
        BType constCondition = ConditionResolver.checkConstCondition(this.types, this.symTable, whileNode.expr);
        boolean ifExprConst = constCondition == this.symTable.trueType;
        boolean bl = failuresSelfHandled = whileNode.onFailClause != null;
        if (ifExprConst) {
            this.analyzeStmtWithOnFail(whileNode.body, whileNode.onFailClause);
        } else {
            this.createUninitializedVarsForOnFailClause(whileNode.onFailClause);
            BranchResult whileResult = this.analyzeBranch(whileNode.body, this.env);
            if (constCondition == this.symTable.falseType) {
                this.uninitializedVars = prevUninitializedVars;
                this.removeEnclosingOnFail(failuresSelfHandled);
                return;
            }
            this.uninitializedVars = this.mergeUninitializedVars(this.uninitializedVars, whileResult.uninitializedVars);
            if (failuresSelfHandled) {
                BranchResult onfailResult = this.analyzeOnFailBranch(whileNode.onFailClause, whileResult);
                this.uninitializedVars = whileResult.definiteFailureReached ? onfailResult.uninitializedVars : this.mergeUninitializedVars(this.uninitializedVars, onfailResult.uninitializedVars);
                this.updateEnclosingOnFailUnInits(this.uninitializedVars);
                this.removeEnclosingOnFail(true);
            }
        }
    }

    private void createUninitializedVarsForOnFailClause(BLangOnFailClause onFailClause) {
        if (onFailClause != null) {
            this.enclosingOnFailClause.push(onFailClause);
            this.possibleFailureUnInitVars.put(onFailClause, this.copyUninitializedVars());
        }
    }

    private void updateUnInitVarsForOnFailClause(Map<BSymbol, InitStatus> uninitializedVars) {
        if (this.isOnFailEnclosed()) {
            this.possibleFailureUnInitVars.put(this.enclosingOnFailClause.peek(), uninitializedVars);
        }
    }

    private void removeEnclosingOnFail(boolean onFailAvailable) {
        if (onFailAvailable) {
            this.possibleFailureUnInitVars.remove(this.enclosingOnFailClause.pop());
        }
    }

    @Override
    public void visit(BLangDo doNode) {
        this.analyzeStmtWithOnFail(doNode.body, doNode.onFailClause);
    }

    private void analyzeStmtWithOnFail(BLangBlockStmt blockStmt, BLangOnFailClause onFailClause) {
        this.createUninitializedVarsForOnFailClause(onFailClause);
        BranchResult doResult = this.analyzeBranch(blockStmt, this.env);
        this.uninitializedVars = doResult.uninitializedVars;
        if (onFailClause == null) {
            this.updateUnInitVarsForOnFailClause(doResult.possibleFailureUnInitVars);
            return;
        }
        BranchResult onFailResult = this.analyzeOnFailBranch(onFailClause, doResult);
        if (blockStmt.failureBreakMode == BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE) {
            this.uninitializedVars = this.mergeUninitializedVars(doResult.uninitializedVars, doResult.possibleFailureUnInitVars);
            this.removeEnclosingOnFail(true);
            return;
        }
        Map<BSymbol, InitStatus> mergedUninitializedVars = this.mergeUninitializedVars(doResult.uninitializedVars, onFailResult.uninitializedVars);
        this.uninitializedVars = onFailResult.flowTerminated || onFailResult.possibleFailureReached ? doResult.uninitializedVars : (doResult.definiteFailureReached ? onFailResult.uninitializedVars : mergedUninitializedVars);
        this.updateEnclosingOnFailUnInits(mergedUninitializedVars);
        this.removeEnclosingOnFail(true);
    }

    private void updateEnclosingOnFailUnInits(Map<BSymbol, InitStatus> possibleUninitializedVars) {
        int enclosingOnFailSize = this.enclosingOnFailClause.size();
        if (enclosingOnFailSize > 1) {
            Iterator<BLangOnFailClause> iterator = this.enclosingOnFailClause.iterator();
            iterator.next();
            BLangOnFailClause enclosingOnFail = iterator.next();
            this.possibleFailureUnInitVars.put(enclosingOnFail, possibleUninitializedVars);
        }
    }

    private BranchResult analyzeOnFailBranch(BLangOnFailClause onFailClause, BranchResult doResult) {
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        if (doResult.possibleFailureUnInitVars != null) {
            this.uninitializedVars = this.mergeUninitializedVars(this.uninitializedVars, doResult.possibleFailureUnInitVars);
        }
        this.possibleFailureUnInitVars.put(onFailClause, this.copyUninitializedVars());
        BranchResult onFailResult = this.analyzeBranch(onFailClause, this.env);
        if (!onFailResult.possibleFailureUnInitVars.isEmpty()) {
            onFailResult.uninitializedVars = this.mergeUninitializedVars(onFailResult.uninitializedVars, onFailResult.possibleFailureUnInitVars);
        }
        this.uninitializedVars = prevUninitializedVars;
        return onFailResult;
    }

    private boolean isOnFailEnclosed() {
        return !this.enclosingOnFailClause.isEmpty();
    }

    private boolean isDefiniteFailureCase(BranchResult ifResult, BranchResult elseResult) {
        return ifResult.definiteFailureReached && elseResult.definiteFailureReached;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (this.isOnFailEnclosed()) {
            this.possibleFailureReached = true;
            this.definiteFailureReached = true;
        }
        this.terminateFlow();
        this.analyzeNode(failNode.expr, this.env);
    }

    @Override
    public void visit(BLangLock lockNode) {
        this.analyzeStmtWithOnFail(lockNode.body, lockNode.onFailClause);
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.analyzeStmtWithOnFail(transactionNode.transactionBody, transactionNode.onFailClause);
        Name transactionPkgName = Names.fromString(Names.DOT.value + Names.TRANSACTION_PACKAGE.value);
        Name compUnitName = Names.fromString(transactionNode.pos.lineRange().fileName());
        this.symResolver.resolvePrefixSymbol(this.env, transactionPkgName, compUnitName);
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.analyzeNode(rollbackNode.expr, this.env);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        this.analyzeNode(stmt.expr, this.env);
        this.checkAssignment(stmt.varRef);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        this.analyzeNode(asyncSendExpr.expr, this.env);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        this.analyzeNode(syncSendExpr.expr, this.env);
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        for (BLangWorkerReceive workerReceive : altWorkerReceive.getWorkerReceives()) {
            this.analyzeNode(workerReceive, this.env);
        }
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        for (BLangMultipleWorkerReceive.BLangReceiveField rvField : multipleWorkerReceive.getReceiveFields()) {
            this.analyzeNode(rvField.getKey(), this.env);
            this.analyzeNode(rvField.getWorkerReceive(), this.env);
        }
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                expr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            }
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        tableConstructorExpr.recordLiteralList.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        this.checkForDuplicateKeys(tableConstructorExpr);
    }

    private void checkForDuplicateKeys(BLangTableConstructorExpr tableConstructorExpr) {
        HashSet<Integer> keyHashSet = new HashSet<Integer>();
        List<String> fieldNames = this.getFieldNames(tableConstructorExpr);
        HashMap<Integer, List<BLangExpression>> keyValues = new HashMap<Integer, List<BLangExpression>>();
        if (!fieldNames.isEmpty()) {
            for (BLangRecordLiteral literal : tableConstructorExpr.recordLiteralList) {
                List<BLangExpression> keyArray = this.createKeyArray(literal, fieldNames);
                int hashInt = this.generateHash(keyArray);
                if (!keyHashSet.add(hashInt) && this.checkForKeyEquality(keyValues, keyArray, hashInt)) {
                    String fields = String.join((CharSequence)", ", fieldNames);
                    String values = keyArray.stream().map(Object::toString).collect(Collectors.joining(", "));
                    this.dlog.error(literal.pos, DiagnosticErrorCode.DUPLICATE_KEY_IN_TABLE_LITERAL, fields, values);
                }
                keyValues.put(hashInt, keyArray);
            }
        }
    }

    private boolean checkForKeyEquality(HashMap<Integer, List<BLangExpression>> keyValues, List<BLangExpression> keyArray, int hash) {
        List<BLangExpression> existingExpList = keyValues.get(hash);
        boolean isEqual = false;
        if (existingExpList.size() == keyArray.size()) {
            isEqual = true;
            for (int i = 0; i < keyArray.size(); ++i) {
                isEqual = isEqual && this.equality(keyArray.get(i), existingExpList.get(i));
            }
        }
        return isEqual;
    }

    private int generateHash(List<BLangExpression> keyArray) {
        int result = 0;
        for (BLangExpression expr : keyArray) {
            result = 31 * result + this.hash(expr);
        }
        return result;
    }

    public boolean equality(Node nodeA, Node nodeB) {
        if (nodeA == null || nodeB == null) {
            return nodeA == nodeB;
        }
        if (nodeA.getKind() != nodeB.getKind()) {
            return false;
        }
        boolean isEqual = true;
        switch (nodeA.getKind()) {
            case RECORD_LITERAL_EXPR: {
                BLangRecordLiteral recordLiteralA = (BLangRecordLiteral)nodeA;
                BLangRecordLiteral recordLiteralB = (BLangRecordLiteral)nodeB;
                for (int i = 0; isEqual && i < recordLiteralA.fields.size(); ++i) {
                    RecordLiteralNode.RecordField exprA = recordLiteralA.fields.get(i);
                    RecordLiteralNode.RecordField exprB = recordLiteralB.fields.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case RECORD_LITERAL_KEY_VALUE: {
                BLangRecordLiteral.BLangRecordKeyValueField fieldA = (BLangRecordLiteral.BLangRecordKeyValueField)nodeA;
                BLangRecordLiteral.BLangRecordKeyValueField fieldB = (BLangRecordLiteral.BLangRecordKeyValueField)nodeB;
                return this.equality(fieldA.valueExpr, fieldB.valueExpr);
            }
            case LITERAL: 
            case NUMERIC_LITERAL: {
                BLangLiteral literalA = (BLangLiteral)nodeA;
                BLangLiteral literalB = (BLangLiteral)nodeB;
                return Objects.equals(literalA.value, literalB.value);
            }
            case XML_TEXT_LITERAL: {
                BLangXMLTextLiteral textLiteralA = (BLangXMLTextLiteral)nodeA;
                BLangXMLTextLiteral textLiteralB = (BLangXMLTextLiteral)nodeB;
                isEqual = this.equality(textLiteralA.concatExpr, textLiteralB.concatExpr);
                for (int i = 0; isEqual && i < textLiteralA.textFragments.size(); ++i) {
                    BLangExpression exprA = textLiteralA.textFragments.get(i);
                    BLangExpression exprB = textLiteralB.textFragments.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case XML_ATTRIBUTE: {
                BLangXMLAttribute attributeA = (BLangXMLAttribute)nodeA;
                BLangXMLAttribute attributeB = (BLangXMLAttribute)nodeB;
                return this.equality(attributeA.name, attributeB.name) && this.equality(attributeA.value, attributeB.value);
            }
            case XML_QNAME: {
                BLangXMLQName xmlqNameA = (BLangXMLQName)nodeA;
                BLangXMLQName xmlqNameB = (BLangXMLQName)nodeA;
                return this.equality(xmlqNameA.localname, xmlqNameB.localname) && this.equality(xmlqNameA.prefix, xmlqNameB.prefix);
            }
            case XML_ELEMENT_LITERAL: {
                BLangExpression exprB;
                BLangExpression exprA;
                int i;
                BLangXMLElementLiteral eleLiteralA = (BLangXMLElementLiteral)nodeA;
                BLangXMLElementLiteral eleLiteralB = (BLangXMLElementLiteral)nodeB;
                isEqual = this.equality(eleLiteralA.startTagName, eleLiteralB.startTagName) && this.equality(eleLiteralA.endTagName, eleLiteralB.endTagName);
                for (i = 0; isEqual && i < eleLiteralA.attributes.size(); ++i) {
                    exprA = eleLiteralA.attributes.get(i);
                    exprB = eleLiteralB.attributes.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                for (i = 0; isEqual && i < eleLiteralA.children.size(); ++i) {
                    exprA = eleLiteralA.children.get(i);
                    exprB = eleLiteralB.children.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case XML_COMMENT_LITERAL: {
                BLangXMLCommentLiteral commentliteralA = (BLangXMLCommentLiteral)nodeA;
                BLangXMLCommentLiteral commentliteralB = (BLangXMLCommentLiteral)nodeB;
                isEqual = this.equality(commentliteralA.concatExpr, commentliteralB.concatExpr);
                for (int i = 0; isEqual && i < commentliteralA.textFragments.size(); ++i) {
                    BLangExpression exprA = commentliteralA.textFragments.get(i);
                    BLangExpression exprB = commentliteralB.textFragments.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case XML_QUOTED_STRING: {
                BLangXMLQuotedString quotedLiteralA = (BLangXMLQuotedString)nodeA;
                BLangXMLQuotedString quotedLiteralB = (BLangXMLQuotedString)nodeB;
                isEqual = this.equality(quotedLiteralA.concatExpr, quotedLiteralB.concatExpr);
                for (int i = 0; isEqual && i < quotedLiteralA.textFragments.size(); ++i) {
                    BLangExpression exprA = quotedLiteralA.textFragments.get(i);
                    BLangExpression exprB = quotedLiteralB.textFragments.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case XMLNS: {
                BLangXMLNS xmlnsA = (BLangXMLNS)nodeA;
                BLangXMLNS xmlnsB = (BLangXMLNS)nodeB;
                return this.equality(xmlnsA.prefix, xmlnsB.prefix) && this.equality(xmlnsA.namespaceURI, xmlnsB.namespaceURI);
            }
            case XML_PI_LITERAL: {
                BLangXMLProcInsLiteral insLiteralA = (BLangXMLProcInsLiteral)nodeA;
                BLangXMLProcInsLiteral insLiteralB = (BLangXMLProcInsLiteral)nodeB;
                isEqual = this.equality(insLiteralA.target, insLiteralB.target) && this.equality(insLiteralA.dataConcatExpr, insLiteralB.dataConcatExpr);
                for (int i = 0; isEqual && i < insLiteralA.dataFragments.size(); ++i) {
                    BLangExpression exprA = insLiteralA.dataFragments.get(i);
                    BLangExpression exprB = insLiteralB.dataFragments.get(i);
                    isEqual = this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case IDENTIFIER: {
                BLangIdentifier identifierA = (BLangIdentifier)nodeA;
                BLangIdentifier identifierB = (BLangIdentifier)nodeB;
                return identifierA.value.equals(identifierB.value);
            }
            case SIMPLE_VARIABLE_REF: {
                BLangSimpleVarRef simpleVarRefA = (BLangSimpleVarRef)nodeA;
                BLangSimpleVarRef simpleVarRefB = (BLangSimpleVarRef)nodeB;
                BSymbol symbolA = simpleVarRefA.symbol;
                BSymbol symbolB = simpleVarRefB.symbol;
                if (symbolA != null && symbolB != null && Symbols.isFlagOn(symbolA.flags, 16384L) && Symbols.isFlagOn(symbolB.flags, 16384L)) {
                    return ((BConstantSymbol)symbolA).value.value.equals(((BConstantSymbol)symbolB).value.value);
                }
                return simpleVarRefA.variableName.equals(simpleVarRefB.variableName);
            }
            case STRING_TEMPLATE_LITERAL: {
                BLangStringTemplateLiteral stringTemplateLiteralA = (BLangStringTemplateLiteral)nodeA;
                BLangStringTemplateLiteral stringTemplateLiteralB = (BLangStringTemplateLiteral)nodeB;
                for (int i = 0; isEqual && i < stringTemplateLiteralA.exprs.size(); ++i) {
                    BLangExpression exprA = stringTemplateLiteralA.exprs.get(i);
                    BLangExpression exprB = stringTemplateLiteralB.exprs.get(i);
                    isEqual = this.getTypeEquality(exprA.getBType(), exprB.getBType()) && this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                BLangListConstructorExpr listConstructorExprA = (BLangListConstructorExpr)nodeA;
                BLangListConstructorExpr listConstructorExprB = (BLangListConstructorExpr)nodeB;
                for (int i = 0; isEqual && i < listConstructorExprA.exprs.size(); ++i) {
                    BLangExpression exprA = listConstructorExprA.exprs.get(i);
                    BLangExpression exprB = listConstructorExprB.exprs.get(i);
                    isEqual = this.getTypeEquality(exprA.getBType(), exprB.getBType()) && this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case TABLE_CONSTRUCTOR_EXPR: {
                BLangTableConstructorExpr tableConstructorExprA = (BLangTableConstructorExpr)nodeA;
                BLangTableConstructorExpr tableConstructorExprB = (BLangTableConstructorExpr)nodeB;
                for (int i = 0; isEqual && i < tableConstructorExprA.recordLiteralList.size(); ++i) {
                    BLangExpression exprA = tableConstructorExprA.recordLiteralList.get(i);
                    BLangExpression exprB = tableConstructorExprB.recordLiteralList.get(i);
                    isEqual = this.getTypeEquality(exprA.getBType(), exprB.getBType()) && this.equality(exprA, exprB);
                }
                return isEqual;
            }
            case TYPE_CONVERSION_EXPR: {
                BLangTypeConversionExpr typeConversionExprA = (BLangTypeConversionExpr)nodeA;
                BLangTypeConversionExpr typeConversionExprB = (BLangTypeConversionExpr)nodeB;
                return this.equality(typeConversionExprA.expr, typeConversionExprB.expr);
            }
            case BINARY_EXPR: {
                BLangBinaryExpr binaryExprA = (BLangBinaryExpr)nodeA;
                BLangBinaryExpr binaryExprB = (BLangBinaryExpr)nodeB;
                return this.equality(binaryExprA.lhsExpr, binaryExprB.lhsExpr) && this.equality(binaryExprA.rhsExpr, binaryExprB.rhsExpr);
            }
            case UNARY_EXPR: {
                BLangUnaryExpr unaryExprA = (BLangUnaryExpr)nodeA;
                BLangUnaryExpr unaryExprB = (BLangUnaryExpr)nodeB;
                return this.equality(unaryExprA.expr, unaryExprB.expr);
            }
            case TYPE_TEST_EXPR: {
                BLangTypeTestExpr typeTestExprA = (BLangTypeTestExpr)nodeA;
                BLangTypeTestExpr typeTestExprB = (BLangTypeTestExpr)nodeB;
                return this.equality(typeTestExprA.expr, typeTestExprB.expr);
            }
            case TERNARY_EXPR: {
                BLangTernaryExpr ternaryExprA = (BLangTernaryExpr)nodeA;
                BLangTernaryExpr ternaryExprB = (BLangTernaryExpr)nodeB;
                return this.equality(ternaryExprA.expr, ternaryExprB.expr) && this.equality(ternaryExprA.thenExpr, ternaryExprB.thenExpr) && this.equality(ternaryExprA.elseExpr, ternaryExprB.elseExpr);
            }
            case GROUP_EXPR: {
                BLangGroupExpr groupExprA = (BLangGroupExpr)nodeA;
                BLangGroupExpr groupExprB = (BLangGroupExpr)nodeA;
                return this.equality(groupExprA.expression, groupExprB.expression);
            }
        }
        return false;
    }

    public Integer hash(Node node) {
        int result = 0;
        if (node == null) {
            return result;
        }
        if (node.getKind() == NodeKind.RECORD_LITERAL_EXPR) {
            BLangRecordLiteral recordLiteral = (BLangRecordLiteral)node;
            for (RecordLiteralNode.RecordField recordField : recordLiteral.fields) {
                result = 31 * result + this.hash(recordField);
            }
        } else if (node.getKind() == NodeKind.RECORD_LITERAL_KEY_VALUE) {
            BLangRecordLiteral.BLangRecordKeyValueField field = (BLangRecordLiteral.BLangRecordKeyValueField)node;
            result = this.hash(field.key.expr) + this.hash(field.valueExpr);
        } else if (node.getKind() == NodeKind.ARRAY_LITERAL_EXPR) {
            BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = (BLangListConstructorExpr.BLangArrayLiteral)node;
            for (BLangExpression bLangExpression : arrayLiteral.exprs) {
                result = 31 * result + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.LITERAL | node.getKind() == NodeKind.NUMERIC_LITERAL) {
            BLangLiteral literal = (BLangLiteral)node;
            result = Objects.hash(literal.value);
        } else if (node.getKind() == NodeKind.XML_TEXT_LITERAL) {
            BLangXMLTextLiteral literal = (BLangXMLTextLiteral)node;
            result = this.hash(literal.concatExpr);
            for (BLangExpression bLangExpression : literal.textFragments) {
                result = result * 31 + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.XML_ATTRIBUTE) {
            BLangXMLAttribute attribute = (BLangXMLAttribute)node;
            result = this.hash(attribute.name) + this.hash(attribute.value);
        } else if (node.getKind() == NodeKind.XML_QNAME) {
            BLangXMLQName xmlqName = (BLangXMLQName)node;
            result = this.hash(xmlqName.localname) + this.hash(xmlqName.prefix);
        } else if (node.getKind() == NodeKind.XML_COMMENT_LITERAL) {
            BLangXMLCommentLiteral literal = (BLangXMLCommentLiteral)node;
            result = this.hash(literal.concatExpr);
            for (BLangExpression bLangExpression : literal.textFragments) {
                result = result * 31 + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.XML_ELEMENT_LITERAL) {
            BLangXMLElementLiteral literal = (BLangXMLElementLiteral)node;
            result = this.hash(literal.startTagName) + this.hash(literal.endTagName);
            for (BLangExpression bLangExpression : literal.attributes) {
                result = 31 * result + this.hash(bLangExpression);
            }
            for (BLangExpression bLangExpression : literal.children) {
                result = 31 * result + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.XML_QUOTED_STRING) {
            BLangXMLQuotedString literal = (BLangXMLQuotedString)node;
            result = this.hash(literal.concatExpr);
            for (BLangExpression bLangExpression : literal.textFragments) {
                result = result * 31 + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.XMLNS) {
            BLangXMLNS xmlns = (BLangXMLNS)node;
            result = this.hash(xmlns.prefix) + this.hash(xmlns.namespaceURI);
        } else if (node.getKind() == NodeKind.XML_PI_LITERAL) {
            BLangXMLProcInsLiteral literal = (BLangXMLProcInsLiteral)node;
            result = this.hash(literal.target) + this.hash(literal.dataConcatExpr);
            for (BLangExpression bLangExpression : literal.dataFragments) {
                result = result * 31 + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.IDENTIFIER) {
            BLangIdentifier identifier = (BLangIdentifier)node;
            result = identifier.value.hashCode();
        } else if (node.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)node;
            BSymbol symbol = simpleVarRef.symbol;
            if (symbol != null && Symbols.isFlagOn(symbol.flags, 16384L)) {
                BConstantSymbol bConstantSymbol = (BConstantSymbol)symbol;
                result = Objects.hash(bConstantSymbol.value.value);
            } else {
                result = simpleVarRef.variableName.hashCode();
            }
        } else if (node.getKind() == NodeKind.STRING_TEMPLATE_LITERAL) {
            BLangStringTemplateLiteral stringTemplateLiteral = (BLangStringTemplateLiteral)node;
            for (BLangExpression bLangExpression : stringTemplateLiteral.exprs) {
                result = result * 31 + this.getTypeHash(stringTemplateLiteral.getBType()) + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
            BLangListConstructorExpr listConstructorExpr = (BLangListConstructorExpr)node;
            for (BLangExpression bLangExpression : listConstructorExpr.exprs) {
                result = result * 31 + this.getTypeHash(listConstructorExpr.getBType()) + this.hash(bLangExpression);
            }
        } else if (node.getKind() == NodeKind.TABLE_CONSTRUCTOR_EXPR) {
            BLangTableConstructorExpr tableConstructorExpr = (BLangTableConstructorExpr)node;
            for (BLangRecordLiteral bLangRecordLiteral : tableConstructorExpr.recordLiteralList) {
                result = result * 31 + this.getTypeHash(tableConstructorExpr.getBType()) + this.hash(bLangRecordLiteral);
            }
        } else if (node.getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
            BLangTypeConversionExpr typeConversionExpr = (BLangTypeConversionExpr)node;
            result = this.hash(typeConversionExpr.expr);
        } else if (node.getKind() == NodeKind.BINARY_EXPR) {
            BLangBinaryExpr binaryExpr = (BLangBinaryExpr)node;
            result = this.hash(binaryExpr.lhsExpr) + this.hash(binaryExpr.rhsExpr);
        } else if (node.getKind() == NodeKind.UNARY_EXPR) {
            BLangUnaryExpr unaryExpr = (BLangUnaryExpr)node;
            result = this.hash(unaryExpr.expr);
        } else if (node.getKind() == NodeKind.TYPE_TEST_EXPR) {
            BLangTypeTestExpr typeTestExpr = (BLangTypeTestExpr)node;
            result = this.hash(typeTestExpr.expr);
        } else if (node.getKind() == NodeKind.TERNARY_EXPR) {
            BLangTernaryExpr ternaryExpr = (BLangTernaryExpr)node;
            result = this.hash(ternaryExpr.expr) + this.hash(ternaryExpr.thenExpr) + this.hash(ternaryExpr.elseExpr);
        } else if (node.getKind() == NodeKind.GROUP_EXPR) {
            BLangGroupExpr groupExpr = (BLangGroupExpr)node;
            result = this.hash(groupExpr.expression);
        } else if (node.getKind() == NodeKind.REG_EXP_TEMPLATE_LITERAL) {
            result = this.generateHashForRegExp(((BLangRegExpTemplateLiteral)node).reDisjunction.sequenceList);
        } else {
            this.dlog.error(((BLangExpression)node).pos, DiagnosticErrorCode.EXPRESSION_IS_NOT_A_CONSTANT_EXPRESSION, new Object[0]);
        }
        return result;
    }

    private Integer generateHashForRegExp(List<BLangExpression> exprs) {
        int regexpHash = 0;
        for (BLangExpression expr : exprs) {
            if (expr.getKind() == NodeKind.REG_EXP_SEQUENCE) {
                BLangReSequence reSequence = (BLangReSequence)expr;
                for (BLangReTerm term : reSequence.termList) {
                    if (term.getKind() == NodeKind.REG_EXP_ASSERTION) {
                        regexpHash += this.hash(((BLangReAssertion)term).assertion).intValue();
                        continue;
                    }
                    regexpHash += this.generateHashForReAtomQuantifier((BLangReAtomQuantifier)term).intValue();
                }
                continue;
            }
            regexpHash += this.hash(expr).intValue();
        }
        return regexpHash;
    }

    private Integer generateHashForReAtomQuantifier(BLangReAtomQuantifier reAtomQuantifier) {
        int regexpHash = 0;
        BLangExpression reAtom = reAtomQuantifier.atom;
        if (reAtom.getKind() == NodeKind.REG_EXP_ATOM_CHAR_ESCAPE) {
            regexpHash += this.hash(((BLangReAtomCharOrEscape)reAtom).charOrEscape).intValue();
        } else if (reAtom.getKind() == NodeKind.REG_EXP_CHARACTER_CLASS) {
            regexpHash += this.generateHashForReCharacterClass((BLangReCharacterClass)reAtom).intValue();
        } else if (reAtom.getKind() == NodeKind.REG_EXP_CAPTURING_GROUP) {
            regexpHash += this.generateHashForReCapturingGroup((BLangReCapturingGroups)reAtom).intValue();
        }
        if (reAtomQuantifier.quantifier != null) {
            BLangReQuantifier reQuantifier = reAtomQuantifier.quantifier;
            regexpHash += this.hash(reQuantifier.quantifier).intValue();
            if (reQuantifier.nonGreedyChar != null) {
                return regexpHash + this.hash(reQuantifier.nonGreedyChar);
            }
        }
        return regexpHash;
    }

    private Integer generateHashForReCharacterClass(BLangReCharacterClass reCharacterClass) {
        int regexpHash = this.hash(reCharacterClass.characterClassStart) + this.hash(reCharacterClass.characterClassEnd);
        if (reCharacterClass.negation != null) {
            regexpHash += this.hash(reCharacterClass.negation).intValue();
        }
        if (reCharacterClass.charSet == null) {
            return regexpHash;
        }
        BLangReCharSet charSet = reCharacterClass.charSet;
        for (BLangExpression charSetAtom : charSet.charSetAtoms) {
            if (charSetAtom.getKind() == NodeKind.REG_EXP_CHAR_SET_RANGE) {
                BLangReCharSetRange charSetRange = (BLangReCharSetRange)charSetAtom;
                regexpHash = regexpHash + this.hash(charSetRange.lhsCharSetAtom) + this.hash(charSetRange.dash) + this.hash(charSetRange.rhsCharSetAtom);
                continue;
            }
            regexpHash += this.hash(charSetAtom).intValue();
        }
        return regexpHash;
    }

    private Integer generateHashForReCapturingGroup(BLangReCapturingGroups reCapturingGroup) {
        int regexpHash = this.hash(reCapturingGroup.openParen) + this.generateHashForRegExp(reCapturingGroup.disjunction.sequenceList) + this.hash(reCapturingGroup.closeParen);
        if (reCapturingGroup.flagExpr == null) {
            return regexpHash;
        }
        BLangReFlagExpression flagExpr = (BLangReFlagExpression)reCapturingGroup.flagExpr;
        regexpHash = regexpHash + this.hash(flagExpr.questionMark) + this.hash(flagExpr.colon);
        return regexpHash + this.hash(flagExpr.flagsOnOff.flags);
    }

    private Integer getTypeHash(BType type) {
        return Objects.hash(type.tag, type.name);
    }

    private boolean getTypeEquality(BType typeA, BType typeB) {
        return this.types.isAssignable(typeA, typeB) || this.types.isAssignable(typeB, typeA);
    }

    private List<BLangExpression> createKeyArray(BLangRecordLiteral literal, List<String> fieldNames) {
        HashMap<String, BLangExpression> fieldMap = new HashMap<String, BLangExpression>();
        for (RecordLiteralNode.RecordField recordField : literal.fields) {
            if (recordField.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyVal = (BLangRecordLiteral.BLangRecordKeyValueField)recordField;
                fieldMap.put(keyVal.key.expr.toString(), keyVal.valueExpr);
                continue;
            }
            if (recordField.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
            BLangRecordLiteral.BLangRecordVarNameField recordVarNameField = (BLangRecordLiteral.BLangRecordVarNameField)recordField;
            fieldMap.put(recordVarNameField.getVariableName().value, recordVarNameField);
        }
        return fieldNames.stream().map(fieldMap::get).toList();
    }

    private List<String> getFieldNames(BLangTableConstructorExpr constructorExpr) {
        List<String> fieldNames = null;
        if (Types.getImpliedType((BType)constructorExpr.getBType()).tag == 9 && (fieldNames = ((BTableType)Types.getImpliedType((BType)constructorExpr.getBType())).fieldNameList) != null) {
            return fieldNames;
        }
        if (constructorExpr.tableKeySpecifier != null && !constructorExpr.tableKeySpecifier.fieldNameIdentifierList.isEmpty()) {
            BLangTableKeySpecifier tableKeySpecifier = constructorExpr.tableKeySpecifier;
            return tableKeySpecifier.fieldNameIdentifierList.stream().map(identifier -> ((BLangIdentifier)identifier).value).toList();
        }
        return new ArrayList<String>();
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (keyValuePair.key.computedKey) {
                    this.analyzeNode(keyValuePair.key.expr, this.env);
                }
                this.analyzeNode(keyValuePair.valueExpr, this.env);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeNode((BLangRecordLiteral.BLangRecordVarNameField)field, this.env);
                continue;
            }
            this.analyzeNode(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, this.env);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        this.unusedErrorVarsDeclaredWithVar.remove(varRefExpr.symbol);
        if (this.isNotVariableReferenceLVExpr(varRefExpr)) {
            this.unusedLocalVariables.remove(varRefExpr.symbol);
        }
        this.checkVarRef(varRefExpr.symbol, varRefExpr.pos);
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        if (!fieldAccessExpr.isLValue && this.isObjectMemberAccessWithSelf(fieldAccessExpr)) {
            this.checkVarRef(fieldAccessExpr.symbol, fieldAccessExpr.pos);
        }
        this.analyzeNode(fieldAccessExpr.expr, this.env);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        if (!prefixedFieldBasedAccess.isLValue && this.isObjectMemberAccessWithSelf(prefixedFieldBasedAccess)) {
            this.checkVarRef(prefixedFieldBasedAccess.symbol, prefixedFieldBasedAccess.pos);
        }
        this.analyzeNode(prefixedFieldBasedAccess.expr, this.env);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeNode(indexAccessExpr.expr, this.env);
        this.analyzeNode(indexAccessExpr.indexExpr, this.env);
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        this.analyzeNode(xmlElementAccess.expr, this.env);
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        this.analyzeNode(xmlNavigation.expr, this.env);
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        this.analyzeNode(extendedXmlNavigationAccess.stepExpr, this.env);
        extendedXmlNavigationAccess.extensions.forEach(extension -> this.analyzeNode((BLangNode)extension, this.env));
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        this.analyzeNode(xmlIndexedStepExtend.indexExpr, this.env);
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        this.analyzeNode(xmlMethodCallStepExtend.invocation, this.env);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeNode(invocationExpr.expr, this.env);
        BSymbol symbol = invocationExpr.symbol;
        this.unusedLocalVariables.remove(symbol);
        if (this.isFunctionOrMethodDefinedInCurrentModule(symbol.owner, this.env) && !this.isGlobalVarsInitialized(invocationExpr.pos, invocationExpr)) {
            this.checkVarRef(symbol, invocationExpr.pos);
            return;
        }
        if (!this.isFieldsInitializedForSelfArgument(invocationExpr)) {
            return;
        }
        if (!this.isFieldsInitializedForSelfInvocation(invocationExpr.requiredArgs, invocationExpr.pos)) {
            return;
        }
        if (!this.isFieldsInitializedForSelfInvocation(invocationExpr.restArgs, invocationExpr.pos)) {
            return;
        }
        this.checkVarRef(symbol, invocationExpr.pos);
        invocationExpr.requiredArgs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        invocationExpr.restArgs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        BSymbol owner = this.env.scope.owner;
        if (owner.kind == SymbolKind.FUNCTION) {
            BInvokableSymbol invokableOwnerSymbol = (BInvokableSymbol)owner;
            if (symbol != this.symTable.notFoundSymbol) {
                this.addDependency(invokableOwnerSymbol, symbol);
            }
        } else if (symbol.kind == SymbolKind.FUNCTION) {
            BInvokableSymbol invokableProviderSymbol = (BInvokableSymbol)symbol;
            BSymbol curDependent = this.currDependentSymbolDeque.peek();
            if (this.isGlobalVarSymbol(curDependent)) {
                this.addDependency(curDependent, invokableProviderSymbol);
            }
        }
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation) {
        this.analyzeNode(collectContextInvocation.invocation, this.env);
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        for (BLangExpression positionalArg : errorConstructorExpr.positionalArgs) {
            this.analyzeNode(positionalArg, this.env);
        }
        for (BLangNamedArgsExpression namedArg : errorConstructorExpr.namedArgs) {
            this.analyzeNode(namedArg, this.env);
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation) {
        this.visit((BLangInvocation)actionInvocation);
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        this.analyzeNode(resourceAccessInvocation.resourceAccessPathSegments, this.env);
        this.visit((BLangInvocation)resourceAccessInvocation);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        BLangExpression collection = fromClause.collection;
        if (this.isNotRangeExpr(collection)) {
            this.populateUnusedVariableMapForMembers(this.unusedLocalVariables, (BLangVariable)fromClause.variableDefinitionNode.getVariable());
        }
        this.analyzeNode(collection, this.env);
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.populateUnusedVariableMapForMembers(this.unusedLocalVariables, (BLangVariable)joinClause.variableDefinitionNode.getVariable());
        this.analyzeNode(joinClause.collection, this.env);
        if (joinClause.onClause != null) {
            this.analyzeNode(joinClause.onClause, this.env);
        }
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVariable.definitionNode), this.env);
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeNode(whereClause.expression, this.env);
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.analyzeNode(onClause.lhsExpr, this.env);
        this.analyzeNode(onClause.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.analyzeNode(orderKeyClause.expression, this.env);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        orderByClause.orderByKeyList.forEach(value -> this.analyzeNode((BLangNode)((Object)value), this.env));
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        groupByClause.groupingKeyList.forEach(value -> this.analyzeNode((BLangNode)value, this.env));
        this.replaceWithSeqSymbol(groupByClause.env);
    }

    private void replaceWithSeqSymbol(SymbolEnv env) {
        for (Map.Entry<Name, Scope.ScopeEntry> symbolEntry : env.scope.entries.entrySet()) {
            BSymbol sym = null;
            Location loc = null;
            for (Map.Entry<BSymbol, Location> unusedLocalVariable : this.unusedLocalVariables.entrySet()) {
                BSymbol unusedVarSymbol = unusedLocalVariable.getKey();
                if (!unusedVarSymbol.name.equals(symbolEntry.getKey())) continue;
                sym = unusedLocalVariable.getKey();
                loc = unusedLocalVariable.getValue();
                break;
            }
            if (sym == null) continue;
            this.unusedLocalVariables.remove(sym);
            this.unusedLocalVariables.put(symbolEntry.getValue().symbol, loc);
        }
    }

    @Override
    public void visit(BLangGroupingKey groupingKey) {
        this.analyzeNode((BLangNode)groupingKey.getGroupingKey(), this.env);
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeNode(selectClause.expression, this.env);
    }

    @Override
    public void visit(BLangCollectClause bLangCollectClause) {
        this.replaceWithSeqSymbol(bLangCollectClause.env);
        this.analyzeNode(bLangCollectClause.expression, this.env);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.analyzeNode(onConflictClause.expression, this.env);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.analyzeNode(limitClause.expression, this.env);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, this.env);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        VariableDefinitionNode onFailVarDefNode = onFailClause.variableDefinitionNode;
        if (onFailVarDefNode != null) {
            this.analyzeNode((BLangVariable)onFailVarDefNode.getVariable(), this.env);
        }
        this.analyzeNode(onFailClause.body, this.env);
    }

    private boolean isFieldsInitializedForSelfArgument(BLangInvocation invocationExpr) {
        if (invocationExpr.expr == null || !this.isSelfKeyWordExpr(invocationExpr.expr)) {
            return true;
        }
        StringBuilder uninitializedFields = this.getUninitializedFieldsForSelfKeyword((BObjectType)((BLangSimpleVarRef)invocationExpr.expr).symbol.type);
        if (!uninitializedFields.isEmpty()) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.CONTAINS_UNINITIALIZED_FIELDS, uninitializedFields.toString());
            return false;
        }
        return true;
    }

    private boolean isFieldsInitializedForSelfInvocation(List<BLangExpression> argExpressions, Location location) {
        for (BLangExpression expr : argExpressions) {
            StringBuilder uninitializedFields;
            if (!this.isSelfKeyWordExpr(expr) || (uninitializedFields = this.getUninitializedFieldsForSelfKeyword((BObjectType)((BLangSimpleVarRef)expr).symbol.type)).isEmpty()) continue;
            this.dlog.error(location, DiagnosticErrorCode.CONTAINS_UNINITIALIZED_FIELDS, uninitializedFields.toString());
            return false;
        }
        return true;
    }

    private boolean isGlobalVarsInitialized(Location pos, BLangInvocation invocation) {
        if (this.env.isModuleInit) {
            boolean isFirstUninitializedField = true;
            StringBuilder uninitializedFields = new StringBuilder();
            BLangExpression expr = invocation.expr;
            boolean methodCallOnVarRef = expr != null && expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF;
            for (BSymbol symbol : this.uninitializedVars.keySet()) {
                if (symbol.owner.getKind() != SymbolKind.PACKAGE || symbol == invocation.symbol || methodCallOnVarRef && ((BLangSimpleVarRef)expr).symbol == symbol) continue;
                if (isFirstUninitializedField) {
                    uninitializedFields = new StringBuilder(symbol.getName().value);
                    isFirstUninitializedField = false;
                    continue;
                }
                uninitializedFields.append(", ").append(symbol.getName().value);
            }
            if (!uninitializedFields.isEmpty()) {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_FUNCTION_CALL_WITH_UNINITIALIZED_VARIABLES, uninitializedFields.toString());
                return false;
            }
        }
        return true;
    }

    private boolean isSelfKeyWordExpr(BLangExpression expr) {
        return expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && Names.SELF.value.equals(((BLangSimpleVarRef)expr).getVariableName().getValue());
    }

    private StringBuilder getUninitializedFieldsForSelfKeyword(BObjectType objType) {
        boolean isFirstUninitializedField = true;
        StringBuilder uninitializedFields = new StringBuilder();
        for (BField field : objType.fields.values()) {
            if (!this.uninitializedVars.containsKey(field.symbol)) continue;
            if (isFirstUninitializedField) {
                uninitializedFields = new StringBuilder(field.symbol.getName().value);
                isFirstUninitializedField = false;
                continue;
            }
            uninitializedFields.append(", ").append(field.symbol.getName().value);
        }
        return uninitializedFields;
    }

    private boolean isGlobalVarSymbol(BSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (symbol.owner == null) {
            return false;
        }
        if (symbol.owner.tag != 4097L) {
            return false;
        }
        return this.isVariableOrConstant(symbol);
    }

    private boolean isVariableOrConstant(BSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        return (symbol.tag & 0x34L) == 52L || (symbol.tag & 0x100001CL) == 0x100001CL;
    }

    private void addDependency(BSymbol dependent, BSymbol provider) {
        if (provider == null || dependent == null || dependent.pkgID != provider.pkgID) {
            return;
        }
        Set providers = this.globalNodeDependsOn.computeIfAbsent(dependent, s -> new LinkedHashSet());
        providers.add(provider);
        this.addFunctionToGlobalVarDependency(dependent, provider);
    }

    private void addFunctionToGlobalVarDependency(BSymbol dependent, BSymbol provider) {
        if (dependent.kind != SymbolKind.FUNCTION && !this.isGlobalVarSymbol(dependent)) {
            return;
        }
        if (this.isVariableOrConstant(provider) && !this.isGlobalVarSymbol(provider)) {
            return;
        }
        Set providers = this.functionToDependency.computeIfAbsent(dependent, s -> new HashSet());
        providers.add(provider);
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.argsExpr.forEach(argExpr -> this.analyzeNode((BLangNode)argExpr, this.env));
        if (this.currDependentSymbolDeque.peek() != null) {
            this.addDependency(this.currDependentSymbolDeque.peek(), Types.getImpliedType((BType)typeInitExpr.getBType()).tsymbol);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.analyzeNode(ternaryExpr.expr, this.env);
        this.analyzeNode(ternaryExpr.thenExpr, this.env);
        this.analyzeNode(ternaryExpr.elseExpr, this.env);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.analyzeNode(waitExpr.getExpression(), this.env);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        waitForAllExpr.keyValuePairs.forEach(keyValue -> {
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            this.analyzeNode(expr, this.env);
        });
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.analyzeNode(binaryExpr.lhsExpr, this.env);
        this.analyzeNode(binaryExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeNode(elvisExpr.lhsExpr, this.env);
        this.analyzeNode(elvisExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeNode(groupExpr.expression, this.env);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeNode(unaryExpr.expr, this.env);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeNode(conversionExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeNode(xmlAttribute.value, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.children.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        xmlElementLiteral.attributes.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
        xmlElementLiteral.inlineNamespaces.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.dataFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.textFragments.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        for (BLangLiteral string : rawTemplateLiteral.strings) {
            this.analyzeNode(string, this.env);
        }
        for (BLangExpression expr : rawTemplateLiteral.insertions) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        BLangFunction funcNode = bLangLambdaFunction.function;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        this.visitFunctionBodyWithDynamicEnv(funcNode, funcEnv);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeNode(bLangVarArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeNode(bLangNamedArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        if (this.isOnFailEnclosed()) {
            this.possibleFailureReached = true;
        }
        this.analyzeNode(checkedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanicExpr) {
        this.analyzeNode(checkPanicExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
        bLangXMLSequenceLiteral.xmlItems.forEach(xml -> this.analyzeNode((BLangNode)xml, this.env));
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.analyzeNode(exprStmtNode.expr, this.env);
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.analyzeStmtWithOnFail(retryNode.retryBody, retryNode.onFailClause);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.analyzeNode(retryTransaction.transaction, this.env);
    }

    @Override
    public void visit(BLangContinue continueNode) {
        this.terminateFlow();
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        for (ClosureVarSymbol closureVarSymbol : bLangArrowFunction.closureVarSymbols) {
            BSymbol symbol = closureVarSymbol.bSymbol;
            if (this.uninitializedVars.containsKey(symbol)) {
                this.dlog.error(closureVarSymbol.diagnosticLocation, DiagnosticErrorCode.USAGE_OF_UNINITIALIZED_VARIABLE, symbol);
            }
            this.unusedErrorVarsDeclaredWithVar.remove(symbol);
            this.unusedLocalVariables.remove(symbol);
        }
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangConstant constant) {
        boolean validVariable;
        boolean bl = validVariable = constant.symbol != null;
        if (validVariable) {
            this.currDependentSymbolDeque.push(constant.symbol);
        }
        try {
            this.analyzeNode(constant.expr, this.env);
        }
        finally {
            if (validVariable) {
                this.currDependentSymbolDeque.pop();
            }
        }
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeNode(arrayType.getElementType(), this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeNode(streamType.constraint, this.env);
        this.analyzeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.analyzeNode(tableType.constraint, this.env);
        if (tableType.tableKeyTypeConstraint != null) {
            this.analyzeNode(tableType.tableKeyTypeConstraint.keyType, this.env);
        }
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        if (this.currDependentSymbolDeque.isEmpty()) {
            return;
        }
        BType resolvedType = Types.getImpliedType(userDefinedType.getBType());
        if (resolvedType == this.symTable.semanticError) {
            return;
        }
        BTypeSymbol tsymbol = resolvedType.tsymbol;
        this.recordGlobalVariableReferenceRelationship(tsymbol);
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        if (functionTypeNode.flagSet.contains((Object)Flag.ANY_FUNCTION)) {
            return;
        }
        functionTypeNode.params.forEach(param -> this.analyzeNode(param.typeNode, this.env));
        this.analyzeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        unionTypeNode.memberTypeNodes.forEach(typeNode -> this.analyzeNode((BLangNode)typeNode, this.env));
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeNode(constituentTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        BTypeSymbol tsymbol = Types.getImpliedType((BType)recordTypeNode.getBType()).tsymbol;
        for (TypeNode typeNode : recordTypeNode.getTypeReferences()) {
            BLangType bLangType = (BLangType)typeNode;
            this.analyzeNode(bLangType, this.env);
            this.recordGlobalVariableReferenceRelationship(Types.getImpliedType((BType)bLangType.getBType()).tsymbol);
        }
        for (BLangSimpleVariable bLangSimpleVariable : recordTypeNode.fields) {
            this.addTypeDependency(tsymbol, Types.getImpliedType(bLangSimpleVariable.getBType()), new HashSet<BType>());
            this.analyzeNode(bLangSimpleVariable, this.env);
            for (BLangAnnotationAttachment annotationAttachment : bLangSimpleVariable.annAttachments) {
                this.analyzeNode(annotationAttachment.expr, this.env);
            }
            this.recordGlobalVariableReferenceRelationship(bLangSimpleVariable.symbol);
        }
    }

    private void addTypeDependency(BTypeSymbol dependentTypeSymbol, BType providerType, Set<BType> unresolvedTypes) {
        if (unresolvedTypes.contains(providerType = Types.getImpliedType(providerType))) {
            return;
        }
        unresolvedTypes.add(providerType);
        switch (providerType.tag) {
            case 21: {
                for (BType memberType : ((BUnionType)providerType).getMemberTypes()) {
                    BType effectiveType = this.types.getTypeWithEffectiveIntersectionTypes(memberType);
                    this.addTypeDependency(dependentTypeSymbol, effectiveType, unresolvedTypes);
                }
                break;
            }
            case 20: {
                this.addTypeDependency(dependentTypeSymbol, this.types.getTypeWithEffectiveIntersectionTypes(((BArrayType)providerType).getElementType()), unresolvedTypes);
                break;
            }
            case 16: {
                this.addTypeDependency(dependentTypeSymbol, this.types.getTypeWithEffectiveIntersectionTypes(((BMapType)providerType).getConstraint()), unresolvedTypes);
                break;
            }
            default: {
                this.addDependency(dependentTypeSymbol, providerType.tsymbol);
            }
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        finiteTypeNode.valueSpace.forEach(value -> this.analyzeNode((BLangNode)value, this.env));
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        for (BLangSimpleVariable member : tupleTypeNode.members) {
            this.analyzeNode(member, this.env);
            for (BLangAnnotationAttachment annotationAttachment : member.annAttachments) {
                this.analyzeNode(annotationAttachment.expr, this.env);
            }
        }
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    @Override
    public void visit(BLangTestablePackage testablePkgNode) {
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.analyzeNode(panicNode.expr, this.env);
        this.terminateFlow();
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeNode(trapExpr.expr, this.env);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        if (this.currDependentSymbolDeque.peek() != null) {
            this.addDependency(this.currDependentSymbolDeque.peek(), Types.getImpliedType((BType)serviceConstructorExpr.getBType()).tsymbol);
        }
        this.addDependency(Types.getImpliedType((BType)serviceConstructorExpr.getBType()).tsymbol, serviceConstructorExpr.serviceNode.symbol);
        this.analyzeNode(serviceConstructorExpr.serviceNode, this.env);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        this.analyzeNode(typeTestExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.analyzeNode(annotAccessExpr.expr, this.env);
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr) {
    }

    @Override
    public void visit(BLangErrorType errorType) {
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.analyzeNode(recordDestructure.expr, this.env);
        this.checkAssignment(recordDestructure.varRef);
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.analyzeNode(errorDestructure.expr, this.env);
        this.checkAssignment(errorDestructure.varRef);
    }

    @Override
    public void visit(BLangTupleVarRef tupleVarRefExpr) {
        tupleVarRefExpr.expressions.forEach(expr -> this.analyzeNode((BLangNode)expr, this.env));
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        varRefExpr.recordRefFields.forEach(expr -> this.analyzeNode(expr.variableReference, this.env));
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.analyzeNode(varRefExpr.message, this.env);
        if (varRefExpr.cause != null) {
            this.analyzeNode(varRefExpr.cause, this.env);
        }
        for (BLangNamedArgsExpression args : varRefExpr.detail) {
            this.analyzeNode(args.expr, this.env);
        }
        this.analyzeNode(varRefExpr.restVar, this.env);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.analyzeNode(bLangTupleVariable.typeNode, this.env);
        this.populateUnusedVariableMapForNonSimpleBindingPatternVariables(this.unusedLocalVariables, bLangTupleVariable);
        this.currDependentSymbolDeque.push(bLangTupleVariable.symbol);
        this.analyzeNode(bLangTupleVariable.expr, this.env);
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.analyzeNode(bLangTupleVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        this.analyzeNode(bLangRecordVariable.typeNode, this.env);
        this.populateUnusedVariableMapForNonSimpleBindingPatternVariables(this.unusedLocalVariables, bLangRecordVariable);
        this.currDependentSymbolDeque.push(bLangRecordVariable.symbol);
        this.analyzeNode(bLangRecordVariable.expr, this.env);
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.analyzeNode(bLangRecordVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.analyzeNode(bLangErrorVariable.typeNode, this.env);
        this.populateUnusedVariableMapForNonSimpleBindingPatternVariables(this.unusedLocalVariables, bLangErrorVariable);
        this.currDependentSymbolDeque.push(bLangErrorVariable.symbol);
        this.analyzeNode(bLangErrorVariable.expr, this.env);
        this.currDependentSymbolDeque.pop();
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.analyzeNode(bLangErrorVariableDef.errorVariable, this.env);
    }

    private void addUninitializedVar(BLangVariable variable) {
        if (!this.uninitializedVars.containsKey(variable.symbol)) {
            this.uninitializedVars.put(variable.symbol, InitStatus.UN_INIT);
        }
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(interpolation -> this.analyzeNode((BLangNode)interpolation, this.env));
    }

    private BranchResult analyzeBranch(BLangNode node, SymbolEnv env) {
        Map<BSymbol, InitStatus> prevUninitializedVars = this.uninitializedVars;
        Map<BSymbol, InitStatus> prevOnFailUninitializedVars = this.getPossibleFailureUnInitVars();
        if (node != null && this.isOnFailEnclosed()) {
            BLangOnFailClause onFailClause = this.enclosingOnFailClause.peek();
            prevOnFailUninitializedVars = this.possibleFailureUnInitVars.get(onFailClause);
            this.possibleFailureUnInitVars.put(onFailClause, this.copyOnFailUninitializedVars(onFailClause));
        }
        boolean prevFlowTerminated = this.flowTerminated;
        boolean prevFailureReached = this.possibleFailureReached;
        boolean prevDefiniteFailureReached = this.definiteFailureReached;
        this.uninitializedVars = this.copyUninitializedVars();
        this.flowTerminated = false;
        this.possibleFailureReached = false;
        this.definiteFailureReached = false;
        this.analyzeNode(node, env);
        BranchResult branchResult = new BranchResult(this.uninitializedVars, this.getPossibleFailureUnInitVars(), this.flowTerminated, this.possibleFailureReached, this.definiteFailureReached);
        this.uninitializedVars = prevUninitializedVars;
        this.flowTerminated = prevFlowTerminated;
        this.possibleFailureReached = prevFailureReached;
        this.definiteFailureReached = prevDefiniteFailureReached;
        this.updateUnInitVarsForOnFailClause(prevOnFailUninitializedVars);
        return branchResult;
    }

    private Map<BSymbol, InitStatus> copyUninitializedVars() {
        return new LinkedHashMap<BSymbol, InitStatus>(this.uninitializedVars);
    }

    private Map<BSymbol, InitStatus> copyOnFailUninitializedVars(BLangOnFailClause onFailClause) {
        return new LinkedHashMap<BSymbol, InitStatus>(this.possibleFailureUnInitVars.get(onFailClause));
    }

    private Map<BSymbol, InitStatus> getPossibleFailureUnInitVars() {
        if (this.isOnFailEnclosed()) {
            return this.possibleFailureUnInitVars.get(this.enclosingOnFailClause.peek());
        }
        return null;
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        if (node != null) {
            node.accept(this);
        }
        this.env = prevEnv;
    }

    private Map<BSymbol, InitStatus> mergeUninitializedVars(Map<BSymbol, InitStatus> firstUninitVars, Map<BSymbol, InitStatus> secondUninitVars) {
        ArrayList<BSymbol> intersection = new ArrayList<BSymbol>(firstUninitVars.keySet());
        intersection.retainAll(secondUninitVars.keySet());
        return Stream.concat(firstUninitVars.entrySet().stream(), secondUninitVars.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, entry -> intersection.contains(entry.getKey()) ? (InitStatus)((Object)((Object)entry.getValue())) : InitStatus.PARTIAL_INIT, (a, b) -> {
            if (a == InitStatus.PARTIAL_INIT || b == InitStatus.PARTIAL_INIT) {
                return InitStatus.PARTIAL_INIT;
            }
            return InitStatus.UN_INIT;
        }, LinkedHashMap::new));
    }

    private void checkVarRef(BSymbol symbol, Location pos) {
        this.recordGlobalVariableReferenceRelationship(symbol);
        InitStatus initStatus = this.uninitializedVars.get(symbol);
        if (initStatus == null) {
            return;
        }
        if (initStatus == InitStatus.UN_INIT) {
            this.dlog.error(pos, DiagnosticErrorCode.USAGE_OF_UNINITIALIZED_VARIABLE, symbol);
            return;
        }
        this.dlog.error(pos, DiagnosticErrorCode.PARTIALLY_INITIALIZED_VARIABLE, symbol);
    }

    private void recordGlobalVariableReferenceRelationship(BSymbol symbol) {
        boolean isInPkgLevel;
        if (this.env.scope == null) {
            return;
        }
        boolean globalVarSymbol = this.isGlobalVarSymbol(symbol);
        BSymbol ownerSymbol = this.env.scope.owner;
        boolean bl = isInPkgLevel = ownerSymbol.getKind() == SymbolKind.PACKAGE;
        if (isInPkgLevel && (globalVarSymbol || symbol instanceof BTypeSymbol) || ownerSymbol.tag == 0x8000000L && globalVarSymbol) {
            BSymbol dependent = this.currDependentSymbolDeque.peek();
            this.addDependency(dependent, symbol);
        } else if (ownerSymbol.kind == SymbolKind.FUNCTION && globalVarSymbol) {
            BInvokableSymbol invokableOwnerSymbol = (BInvokableSymbol)ownerSymbol;
            this.addDependency(invokableOwnerSymbol, symbol);
        } else if (ownerSymbol.kind == SymbolKind.OBJECT && globalVarSymbol) {
            this.addDependency(ownerSymbol, symbol);
        } else if (ownerSymbol.kind == SymbolKind.RECORD && globalVarSymbol) {
            this.addDependency(ownerSymbol, symbol);
        }
    }

    private boolean isObjectMemberAccessWithSelf(BLangAccessExpression fieldAccessExpr) {
        if (fieldAccessExpr.expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        return Names.SELF.value.equals(((BLangSimpleVarRef)fieldAccessExpr.expr).variableName.value);
    }

    private void checkAssignment(BLangExpression varRef) {
        BSymbol symbol;
        NodeKind kind = varRef.getKind();
        switch (kind) {
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)varRef;
                recordVarRef.recordRefFields.forEach(field -> this.checkAssignment(field.variableReference));
                if (recordVarRef.restParam != null) {
                    this.checkAssignment(recordVarRef.restParam);
                }
                return;
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)varRef;
                tupleVarRef.expressions.forEach(this::checkAssignment);
                if (tupleVarRef.restParam != null) {
                    this.checkAssignment(tupleVarRef.restParam);
                }
                return;
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)varRef;
                if (errorVarRef.message != null) {
                    this.checkAssignment(errorVarRef.message);
                }
                if (errorVarRef.cause != null) {
                    this.checkAssignment(errorVarRef.cause);
                }
                for (BLangNamedArgsExpression expression : errorVarRef.detail) {
                    this.checkAssignment(expression);
                    this.uninitializedVars.remove(((BLangVariableReference)expression.expr).symbol);
                }
                if (errorVarRef.restVar != null) {
                    this.checkAssignment(errorVarRef.restVar);
                }
                return;
            }
            case INDEX_BASED_ACCESS_EXPR: 
            case FIELD_BASED_ACCESS_EXPR: {
                BLangAccessExpression accessExpr = (BLangAccessExpression)varRef;
                BLangExpression expr = accessExpr.expr;
                BType type = Types.getImpliedType(expr.getBType());
                if (this.isObjectMemberAccessWithSelf(accessExpr)) {
                    BObjectType objectType = (BObjectType)type;
                    BSymbol symbol2 = accessExpr.symbol;
                    if (this.uninitializedVars.containsKey(symbol2)) {
                        this.uninitializedVars.remove(symbol2);
                        return;
                    }
                    String fieldName = ((BLangFieldBasedAccess)varRef).field.value;
                    this.checkFinalEntityUpdate(varRef.pos, fieldName, ((BField)objectType.fields.get((Object)fieldName)).symbol);
                    return;
                }
                if (accessExpr.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
                    this.checkFinalObjectFieldUpdate((BLangFieldBasedAccess)accessExpr);
                }
                this.analyzeNode(expr, this.env);
                if (kind == NodeKind.INDEX_BASED_ACCESS_EXPR) {
                    this.analyzeNode(((BLangIndexBasedAccess)varRef).indexExpr, this.env);
                }
                return;
            }
        }
        if (kind != NodeKind.SIMPLE_VARIABLE_REF && kind != NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
            return;
        }
        if (kind == NodeKind.SIMPLE_VARIABLE_REF) {
            symbol = ((BLangSimpleVarRef)varRef).symbol;
            this.checkFinalEntityUpdate(varRef.pos, varRef, symbol);
            BSymbol owner = this.currDependentSymbolDeque.peek();
            this.addFunctionToGlobalVarDependency(owner, ((BLangSimpleVarRef)varRef).symbol);
        }
        symbol = ((BLangVariableReference)varRef).symbol;
        if (this.possibleFailureReached && this.uninitializedVars.containsKey(symbol)) {
            this.getPossibleFailureUnInitVars().put(symbol, InitStatus.PARTIAL_INIT);
        } else if (!this.possibleFailureUnInitVars.isEmpty() && !this.possibleFailureReached) {
            this.getPossibleFailureUnInitVars().remove(symbol);
        }
        this.uninitializedVars.remove(symbol);
    }

    private void checkFinalObjectFieldUpdate(BLangFieldBasedAccess fieldAccess) {
        BLangExpression expr = fieldAccess.expr;
        BType exprType = Types.getImpliedType(expr.getBType());
        if (this.types.isSubTypeOfBaseType(exprType, PredefinedType.OBJECT) && this.isFinalFieldInAllObjects(fieldAccess.pos, exprType, fieldAccess.field.value)) {
            this.dlog.error(fieldAccess.pos, DiagnosticErrorCode.CANNOT_UPDATE_FINAL_OBJECT_FIELD, fieldAccess.symbol.originalName);
        }
    }

    private boolean isFinalFieldInAllObjects(Location pos, BType btype, String fieldName) {
        BType type = Types.getImpliedType(btype);
        if (type.tag == 34) {
            BField field = (BField)((BObjectType)type).fields.get(fieldName);
            if (field != null) {
                return Symbols.isFlagOn(field.symbol.flags, 4L);
            }
            BObjectTypeSymbol objTypeSymbol = (BObjectTypeSymbol)type.tsymbol;
            Name funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(objTypeSymbol.name.value, fieldName));
            BSymbol funcSymbol = this.symResolver.resolveObjectMethod(pos, this.env, funcName, objTypeSymbol);
            return funcSymbol != null;
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isFinalFieldInAllObjects(pos, memberType, fieldName)) continue;
            return false;
        }
        return true;
    }

    private void checkFinalEntityUpdate(Location pos, Object field, BSymbol symbol) {
        if (symbol == null || !Symbols.isFlagOn(symbol.flags, 4L)) {
            return;
        }
        if (!this.uninitializedVars.containsKey(symbol)) {
            this.dlog.error(pos, DiagnosticErrorCode.CANNOT_ASSIGN_VALUE_FINAL, symbol);
            return;
        }
        InitStatus initStatus = this.uninitializedVars.get(symbol);
        if (initStatus == InitStatus.PARTIAL_INIT) {
            this.dlog.error(pos, DiagnosticErrorCode.CANNOT_ASSIGN_VALUE_TO_POTENTIALLY_INITIALIZED_FINAL, symbol);
        }
    }

    private void terminateFlow() {
        this.flowTerminated = true;
    }

    private void checkUnusedImports(List<BLangImportPackage> imports) {
        for (BLangImportPackage importStmt : imports) {
            BLangIdentifier prefix = importStmt.alias;
            String prefixValue = prefix.value;
            Location location = prefix.pos;
            BPackageSymbol symbol = importStmt.symbol;
            if (symbol == null || symbol.isUsed || Names.IGNORE.value.equals(prefixValue)) continue;
            this.dlog.error(location, DiagnosticErrorCode.UNUSED_MODULE_PREFIX, prefixValue);
        }
    }

    private void checkUnusedErrorVarsDeclaredWithVar() {
        for (Map.Entry<BSymbol, Location> entry : this.unusedErrorVarsDeclaredWithVar.entrySet()) {
            this.dlog.error(entry.getValue(), DiagnosticErrorCode.UNUSED_VARIABLE_WITH_INFERRED_TYPE_INCLUDING_ERROR, entry.getKey().name);
        }
    }

    private void emitUnusedVariableWarnings(Map<BSymbol, Location> unusedLocalVariables) {
        for (Map.Entry<BSymbol, Location> entry : unusedLocalVariables.entrySet()) {
            this.dlog.warning(entry.getValue(), DiagnosticWarningCode.UNUSED_LOCAL_VARIABLE, entry.getKey().name);
        }
    }

    private boolean addVarIfInferredTypeIncludesError(BLangSimpleVariable variable) {
        if (this.types.containsErrorType(variable.getBType().semType())) {
            this.unusedErrorVarsDeclaredWithVar.put(variable.symbol, variable.pos);
            return true;
        }
        return false;
    }

    private boolean isLocalVariableDefinedWithNonWildCardBindingPattern(BLangSimpleVariable variable) {
        if (this.isWildCardBindingPattern(variable)) {
            return false;
        }
        return this.isLocalVariable(variable.symbol);
    }

    private boolean isWildCardBindingPattern(BLangSimpleVariable variable) {
        return Names.IGNORE.value.equals(variable.name.value);
    }

    private boolean isWildCardBindingPattern(BVarSymbol symbol) {
        return Names.IGNORE == symbol.name;
    }

    private boolean isLocalVariable(BVarSymbol symbol) {
        if (symbol == null) {
            return false;
        }
        BSymbol owner = symbol.owner;
        if (owner == null || owner.tag == 4097L) {
            return false;
        }
        if (owner.tag == 0x8000000L) {
            return true;
        }
        if (owner.tag != 820L) {
            return false;
        }
        long flags = symbol.flags;
        SymbolKind kind = symbol.kind;
        if (kind == SymbolKind.PATH_PARAMETER || kind == SymbolKind.PATH_REST_PARAMETER) {
            return false;
        }
        return !Symbols.isFlagOn(flags, 0x800000000L) && !Symbols.isFlagOn(flags, 0x1000000000L) && !Symbols.isFlagOn(flags, 0x400000000L) && !Symbols.isFlagOn(flags, 0x2000000000L);
    }

    private void populateUnusedVariableMapForNonSimpleBindingPatternVariables(Map<BSymbol, Location> unusedLocalVariables, BLangVariable variable) {
        if (!this.isLocalVariable(variable.symbol)) {
            return;
        }
        this.populateUnusedVariableMapForMembers(unusedLocalVariables, variable);
    }

    private void populateUnusedVariableMapForMembers(Map<BSymbol, Location> unusedLocalVariables, BLangVariable variable) {
        if (variable == null) {
            return;
        }
        switch (variable.getKind()) {
            case VARIABLE: {
                BLangSimpleVariable simpleVariable = (BLangSimpleVariable)variable;
                if (this.isWildCardBindingPattern(simpleVariable)) break;
                unusedLocalVariables.put(simpleVariable.symbol, simpleVariable.pos);
                break;
            }
            case RECORD_VARIABLE: {
                BLangRecordVariable recordVariable = (BLangRecordVariable)variable;
                for (BLangRecordVariable.BLangRecordVariableKeyValue member : recordVariable.variableList) {
                    this.populateUnusedVariableMapForMembers(unusedLocalVariables, member.valueBindingPattern);
                }
                this.populateUnusedVariableMapForMembers(unusedLocalVariables, recordVariable.restParam);
                break;
            }
            case TUPLE_VARIABLE: {
                BLangTupleVariable tupleVariable = (BLangTupleVariable)variable;
                for (BLangVariable memberVariable : tupleVariable.memberVariables) {
                    this.populateUnusedVariableMapForMembers(unusedLocalVariables, memberVariable);
                }
                this.populateUnusedVariableMapForMembers(unusedLocalVariables, tupleVariable.restVariable);
                break;
            }
            case ERROR_VARIABLE: {
                BLangErrorVariable errorVariable = (BLangErrorVariable)variable;
                this.populateUnusedVariableMapForMembers(unusedLocalVariables, errorVariable.message);
                this.populateUnusedVariableMapForMembers(unusedLocalVariables, errorVariable.cause);
                for (BLangErrorVariable.BLangErrorDetailEntry member : errorVariable.detail) {
                    this.populateUnusedVariableMapForMembers(unusedLocalVariables, member.valueBindingPattern);
                }
                this.populateUnusedVariableMapForMembers(unusedLocalVariables, errorVariable.restDetail);
            }
        }
    }

    private boolean isNotVariableReferenceLVExpr(BLangSimpleVarRef varRefExpr) {
        if (!varRefExpr.isLValue) {
            return true;
        }
        BLangNode parent = varRefExpr.parent;
        return parent != null && parent.getKind() != NodeKind.ASSIGNMENT;
    }

    private boolean isNotRangeExpr(BLangExpression collection) {
        if (collection.getKind() != NodeKind.BINARY_EXPR) {
            return true;
        }
        OperatorKind opKind = ((BLangBinaryExpr)collection).opKind;
        return opKind != OperatorKind.HALF_OPEN_RANGE && opKind != OperatorKind.CLOSED_RANGE;
    }

    private boolean isFunctionOrMethodDefinedInCurrentModule(BSymbol owner, SymbolEnv env) {
        if (Symbols.isFlagOn(owner.flags, 0x10000000L)) {
            return owner.owner == this.getEnclPkgSymbol(env);
        }
        return owner == this.getEnclPkgSymbol(env);
    }

    private BPackageSymbol getEnclPkgSymbol(SymbolEnv env) {
        BLangPackage enclPkg = env.enclPkg;
        if (enclPkg != null) {
            return enclPkg.symbol;
        }
        SymbolEnv enclEnv = env.enclEnv;
        if (enclEnv == null) {
            return null;
        }
        return this.getEnclPkgSymbol(enclEnv);
    }

    private static class BranchResult {
        Map<BSymbol, InitStatus> uninitializedVars;
        Map<BSymbol, InitStatus> possibleFailureUnInitVars;
        boolean flowTerminated;
        boolean definiteFailureReached;
        boolean possibleFailureReached;

        BranchResult(Map<BSymbol, InitStatus> uninitializedVars, Map<BSymbol, InitStatus> possibleFailureUnInitVars, boolean flowTerminated, boolean possibleFailureReached, boolean definiteFailureReached) {
            this.uninitializedVars = uninitializedVars;
            this.possibleFailureUnInitVars = possibleFailureUnInitVars;
            this.flowTerminated = flowTerminated;
            this.possibleFailureReached = possibleFailureReached;
            this.definiteFailureReached = definiteFailureReached;
        }
    }

    private static enum InitStatus {
        UN_INIT,
        PARTIAL_INIT;

    }
}

