/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.parser.NodeCloner;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeChecker;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeNarrower;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSequenceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BSequenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangInputClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class QueryTypeChecker
extends TypeChecker {
    private static final CompilerContext.Key<QueryTypeChecker> QUERY_TYPE_CHECKER_KEY = new CompilerContext.Key();
    private final Types types;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final SemanticAnalyzer semanticAnalyzer;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final TypeNarrower typeNarrower;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private final Names names;
    private final BLangDiagnosticLog dlog;
    private final NodeCloner nodeCloner;

    public static QueryTypeChecker getInstance(CompilerContext context) {
        QueryTypeChecker queryTypeChecker = context.get(QUERY_TYPE_CHECKER_KEY);
        if (queryTypeChecker == null) {
            queryTypeChecker = new QueryTypeChecker(context);
        }
        return queryTypeChecker;
    }

    public QueryTypeChecker(CompilerContext context) {
        super(context, new CompilerContext.Key<TypeChecker>());
        context.put(QUERY_TYPE_CHECKER_KEY, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.typeNarrower = TypeNarrower.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
        this.semanticAnalyzer = SemanticAnalyzer.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.nodeCloner = NodeCloner.getInstance(context);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr, TypeChecker.AnalyzerData data) {
        this.checkQueryType(queryExpr, data);
    }

    public void checkQueryType(BLangQueryExpr queryExpr, TypeChecker.AnalyzerData data) {
        BType actualType;
        AnalyzerData prevData = data.queryData;
        data.queryData = new AnalyzerData();
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        HashSet<BType> prevCheckedErrorList = commonAnalyzerData.checkedErrorList;
        commonAnalyzerData.checkedErrorList = new HashSet();
        Deque<BLangNode> prevQueryFinalClauses = commonAnalyzerData.queryFinalClauses;
        commonAnalyzerData.queryFinalClauses = new ArrayDeque<BLangNode>();
        int prevLetCount = commonAnalyzerData.letCount;
        commonAnalyzerData.letCount = 0;
        if (commonAnalyzerData.breakToParallelQueryEnv) {
            commonAnalyzerData.queryEnvs.push(data.prevEnvs.peek());
        } else {
            commonAnalyzerData.queryEnvs.push(data.env);
            data.prevEnvs.push(data.env);
        }
        BLangNode finalClause = queryExpr.getFinalClause();
        commonAnalyzerData.queryFinalClauses.push(finalClause);
        data.queryVariables = new HashSet<String>();
        List<BLangNode> clauses = queryExpr.getQueryClauses();
        clauses.forEach(clause -> clause.accept(this, data));
        data.queryVariables.clear();
        if (finalClause.getKind() == NodeKind.SELECT) {
            actualType = this.resolveQueryType(commonAnalyzerData.queryEnvs.peek(), ((BLangSelectClause)finalClause).expression, data.expType, queryExpr, clauses, data);
            queryExpr.setDeterminedType(actualType);
            actualType = actualType == this.symTable.semanticError ? actualType : this.types.checkType(queryExpr.pos, actualType, data.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        } else {
            if (queryExpr.isTable || queryExpr.isStream || queryExpr.isMap) {
                this.dlog.error(queryExpr.pos, DiagnosticErrorCode.QUERY_CONSTRUCT_TYPES_CANNOT_BE_USED_WITH_COLLECT, new Object[0]);
            }
            BLangExpression finalClauseExpr = ((BLangCollectClause)finalClause).expression;
            BType queryType = this.checkExpr(finalClauseExpr, commonAnalyzerData.queryEnvs.peek(), data);
            List<BType> collectionTypes = this.getCollectionTypes(clauses);
            BType completionType = this.getCompletionType(collectionTypes, Types.QueryConstructType.DEFAULT, data);
            if (completionType != null) {
                queryType = BUnionType.create(this.symTable.typeEnv(), null, queryType, completionType);
            }
            queryExpr.setDeterminedType(queryType);
            actualType = this.types.checkType(finalClauseExpr.pos, queryType, data.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        }
        commonAnalyzerData.queryFinalClauses.pop();
        commonAnalyzerData.queryEnvs.pop();
        if (!commonAnalyzerData.breakToParallelQueryEnv) {
            data.prevEnvs.pop();
        }
        BType referredActualType = Types.getImpliedType(actualType);
        if (referredActualType.tag == 9) {
            BTableType tableType = (BTableType)referredActualType;
            tableType.constraintPos = queryExpr.pos;
            tableType.isTypeInlineDefined = true;
            if (!this.validateTableType(tableType, data)) {
                data.resultType = this.symTable.semanticError;
                return;
            }
        }
        commonAnalyzerData.checkedErrorList = prevCheckedErrorList;
        commonAnalyzerData.queryFinalClauses = prevQueryFinalClauses;
        commonAnalyzerData.letCount = prevLetCount;
        data.resultType = actualType;
        data.queryData = prevData;
    }

    @Override
    public void visit(BLangQueryAction queryAction, TypeChecker.AnalyzerData data) {
        this.checkQueryAction(queryAction, data);
    }

    public void checkQueryAction(BLangQueryAction queryAction, TypeChecker.AnalyzerData data) {
        AnalyzerData prevData = data.queryData;
        data.queryData = new AnalyzerData();
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        Deque<BLangNode> prevQueryFinalClauses = commonAnalyzerData.queryFinalClauses;
        commonAnalyzerData.queryFinalClauses = new ArrayDeque<BLangNode>();
        int prevLetCount = commonAnalyzerData.letCount;
        commonAnalyzerData.letCount = 0;
        if (commonAnalyzerData.breakToParallelQueryEnv) {
            commonAnalyzerData.queryEnvs.push(data.prevEnvs.peek());
        } else {
            commonAnalyzerData.queryEnvs.push(data.env);
            data.prevEnvs.push(data.env);
        }
        BLangDoClause doClause = queryAction.getDoClause();
        commonAnalyzerData.queryFinalClauses.push(doClause);
        data.queryVariables = new HashSet<String>();
        List<BLangNode> clauses = queryAction.getQueryClauses();
        clauses.forEach(clause -> clause.accept(this, data));
        data.queryVariables.clear();
        List<BType> collectionTypes = this.getCollectionTypes(clauses);
        BType completionType = this.getCompletionType(collectionTypes, Types.QueryConstructType.ACTION, data);
        this.semanticAnalyzer.analyzeNode(doClause.body, SymbolEnv.createBlockEnv(doClause.body, commonAnalyzerData.queryEnvs.peek()), data.prevEnvs, this, commonAnalyzerData);
        BType actualType = completionType == null ? this.symTable.nilType : completionType;
        data.resultType = this.types.checkType(doClause.pos, actualType, data.expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
        commonAnalyzerData.queryFinalClauses.pop();
        commonAnalyzerData.queryEnvs.pop();
        if (!commonAnalyzerData.breakToParallelQueryEnv) {
            data.prevEnvs.pop();
        }
        commonAnalyzerData.queryFinalClauses = prevQueryFinalClauses;
        commonAnalyzerData.letCount = prevLetCount;
        data.queryData = prevData;
    }

    public BType resolveQueryType(SymbolEnv env, BLangExpression selectExp, BType targetType, BLangQueryExpr queryExpr, List<BLangNode> clauses, TypeChecker.AnalyzerData data) {
        List<BType> safeResultTypes = this.types.getAllTypes(targetType, true).stream().filter(t -> !this.types.isAssignable((BType)t, this.symTable.errorType)).filter(t -> !this.types.isAssignable((BType)t, this.symTable.nilType)).toList();
        if (safeResultTypes.isEmpty()) {
            safeResultTypes = List.of(this.symTable.noType);
        }
        BType actualType = this.symTable.semanticError;
        ArrayList<BType> selectTypes = new ArrayList<BType>();
        ArrayList<BType> resolvedTypes = new ArrayList<BType>();
        BLangExpression collectionNode = (BLangExpression)((BLangFromClause)clauses.get(0)).getCollection();
        this.solveSelectTypeAndResolveType(queryExpr, selectExp, safeResultTypes, collectionNode.getBType(), selectTypes, resolvedTypes, env, data, false);
        if (selectTypes.size() == 1) {
            BType selectType = (BType)selectTypes.get(0);
            this.checkExpr(selectExp, env, selectType, data);
            List<BType> collectionTypes = this.getCollectionTypes(clauses);
            BType completionType = this.getCompletionType(collectionTypes, this.types.getQueryConstructType(queryExpr), data);
            if (queryExpr.isStream) {
                return new BStreamType(this.symTable.typeEnv(), 15, selectType, completionType, null);
            }
            if (queryExpr.isTable) {
                actualType = this.getQueryTableType(queryExpr, selectType, (BType)resolvedTypes.get(0), env);
            } else if (queryExpr.isMap) {
                BType mapConstraintType = this.getTypeOfTypeParameter(selectType, queryExpr.getSelectClause().expression.pos);
                if (mapConstraintType != this.symTable.semanticError) {
                    actualType = new BMapType(this.symTable.typeEnv(), 16, mapConstraintType, null);
                    if (Symbols.isFlagOn(((BType)resolvedTypes.get(0)).getFlags(), 32L)) {
                        actualType = ImmutableTypeCloner.getImmutableIntersectionType(null, this.types, actualType, env, this.symTable, this.anonymousModelHelper, this.names, null);
                    }
                }
            } else {
                actualType = (BType)resolvedTypes.get(0);
            }
            if (completionType != null && completionType.tag != 10) {
                return BUnionType.create(this.symTable.typeEnv(), null, actualType, this.types.getSafeType(completionType, true, false));
            }
            return actualType;
        }
        if (selectTypes.size() > 1) {
            this.dlog.error(selectExp.pos, DiagnosticErrorCode.AMBIGUOUS_TYPES, selectTypes);
            return actualType;
        }
        return actualType;
    }

    void solveSelectTypeAndResolveType(BLangQueryExpr queryExpr, BLangExpression selectExp, List<BType> expTypes, BType collectionType, List<BType> selectTypes, List<BType> resolvedTypes, SymbolEnv env, TypeChecker.AnalyzerData data, boolean isReadonly) {
        LinkedHashSet<BType> possibleSelectTypes = new LinkedHashSet<BType>();
        ArrayList<BType> possibleResolvedTypes = new ArrayList<BType>();
        LinkedHashSet<BType> errorTypes = new LinkedHashSet<BType>();
        block8: for (BType expType2 : expTypes) {
            BType resolvedType;
            BType selectType;
            BType type = Types.getReferredType(expType2);
            switch (type.tag) {
                case 20: {
                    BType elementType = ((BArrayType)type).eType;
                    selectType = this.checkExprSilent(selectExp, env, elementType, data);
                    if (selectType == this.symTable.semanticError) {
                        errorTypes.add(elementType);
                        continue block8;
                    }
                    BArrayType queryResultType = new BArrayType(this.symTable.typeEnv(), selectType);
                    resolvedType = this.getResolvedType(queryResultType, type, isReadonly, env);
                    break;
                }
                case 9: {
                    BType tableConstraint = this.types.getSafeType(((BTableType)type).constraint, true, true);
                    selectType = this.checkExprSilent(selectExp, env, tableConstraint, data);
                    if (selectType == this.symTable.semanticError) {
                        errorTypes.add(tableConstraint);
                        continue block8;
                    }
                    resolvedType = this.getResolvedType(this.symTable.tableType, type, isReadonly, env);
                    break;
                }
                case 15: {
                    BType streamConstraint = this.types.getSafeType(((BStreamType)type).constraint, true, true);
                    selectType = this.checkExprSilent(selectExp, env, streamConstraint, data);
                    if (selectType == this.symTable.semanticError) {
                        errorTypes.add(streamConstraint);
                        continue block8;
                    }
                    resolvedType = this.symTable.streamType;
                    break;
                }
                case 16: {
                    ArrayList<BTupleMember> memberTypeList = new ArrayList<BTupleMember>(2);
                    BVarSymbol stringVarSymbol = new BVarSymbol(0L, null, null, this.symTable.semanticError, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
                    memberTypeList.add(new BTupleMember(this.symTable.stringType, stringVarSymbol));
                    BType memberType = ((BMapType)type).getConstraint();
                    BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(memberType);
                    memberTypeList.add(new BTupleMember(memberType, varSymbol));
                    BTupleType newExpType = new BTupleType(this.symTable.typeEnv(), memberTypeList);
                    selectType = this.checkExprSilent(selectExp, env, newExpType, data);
                    if (selectType == this.symTable.semanticError) {
                        errorTypes.add(newExpType);
                        continue block8;
                    }
                    resolvedType = this.getResolvedType(selectType, type, isReadonly, env);
                    break;
                }
                case 5: 
                case 8: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    selectType = this.checkExprSilent(selectExp, env, type, data);
                    if (selectType == this.symTable.semanticError) {
                        errorTypes.add(type);
                        continue block8;
                    }
                    BType refSelectType = Types.getReferredType(selectType);
                    if (TypeTags.isXMLTypeTag(refSelectType.tag) || TypeTags.isStringTypeTag(refSelectType.tag)) {
                        selectType = type;
                    }
                    if (this.types.isAssignable(selectType, this.symTable.xmlType)) {
                        resolvedType = this.getResolvedType(new BXMLType(selectType, null), type, isReadonly, env);
                        break;
                    }
                    resolvedType = selectType;
                    break;
                }
                case 22: {
                    type = ((BIntersectionType)type).effectiveType;
                    this.solveSelectTypeAndResolveType(queryExpr, selectExp, List.of(type), collectionType, selectTypes, resolvedTypes, env, data, Symbols.isFlagOn(type.getFlags(), 32L));
                    return;
                }
                default: {
                    BType inferredSelectType = this.symTable.semanticError;
                    selectType = this.checkExprSilent(selectExp, env, type, data);
                    if (type != this.symTable.noType) {
                        inferredSelectType = this.checkExprSilent(selectExp, env, this.symTable.noType, data);
                    }
                    if (selectType != this.symTable.semanticError && inferredSelectType != this.symTable.semanticError && inferredSelectType != this.symTable.noType) {
                        selectType = this.types.getTypeIntersection(Types.IntersectionContext.typeTestIntersectionCalculationContext(), selectType, inferredSelectType, env);
                    } else {
                        BType checkedType = this.symTable.semanticError;
                        if (selectType == this.symTable.semanticError) {
                            checkedType = this.checkExpr(selectExp, env, data);
                        }
                        if (checkedType != this.symTable.semanticError && expTypes.size() == 1) {
                            selectType = checkedType;
                        }
                    }
                    resolvedType = queryExpr.isMap ? this.symTable.mapType : (queryExpr.isStream ? this.symTable.streamType : this.getNonContextualQueryType(selectType, collectionType, selectExp.pos));
                }
            }
            if (selectType == this.symTable.semanticError) continue;
            if (resolvedType.tag == 15) {
                queryExpr.isStream = true;
            }
            if (resolvedType.tag == 9) {
                queryExpr.isTable = true;
            }
            possibleSelectTypes.add(selectType);
            possibleResolvedTypes.add(resolvedType);
        }
        if (!possibleSelectTypes.isEmpty() && !possibleResolvedTypes.isEmpty()) {
            selectTypes.addAll(possibleSelectTypes);
            resolvedTypes.addAll(possibleResolvedTypes);
            return;
        }
        if (!errorTypes.isEmpty()) {
            BType actualQueryType;
            if (errorTypes.size() > 1 && (actualQueryType = this.silentTypeCheckExpr(queryExpr, this.symTable.noType, data)) != this.symTable.semanticError) {
                this.types.checkType(queryExpr, actualQueryType, BUnionType.create(this.symTable.typeEnv(), null, new LinkedHashSet<BType>(expTypes)));
                errorTypes.forEach(expType -> {
                    if (expType.tag == 21) {
                        this.checkExpr(this.nodeCloner.cloneNode(selectExp), env, (BType)expType, data);
                    }
                });
                this.checkExpr(selectExp, env, data);
                return;
            }
            errorTypes.forEach(expType -> {
                selectExp.typeChecked = false;
                this.checkExpr(selectExp, env, (BType)expType, data);
            });
            selectExp.typeChecked = true;
        }
    }

    private BType getQueryTableType(BLangQueryExpr queryExpr, BType constraintType, BType resolvedType, SymbolEnv env) {
        BTableType tableType = new BTableType(this.symTable.typeEnv(), constraintType, null);
        if (!queryExpr.fieldNameIdentifierList.isEmpty()) {
            this.validateKeySpecifier(queryExpr.fieldNameIdentifierList, constraintType);
            this.markReadOnlyForConstraintType(constraintType);
            tableType.fieldNameList = queryExpr.fieldNameIdentifierList.stream().map(identifier -> ((BLangIdentifier)identifier).value).toList();
        }
        if (Symbols.isFlagOn(resolvedType.getFlags(), 32L)) {
            return ImmutableTypeCloner.getImmutableIntersectionType(null, this.types, tableType, env, this.symTable, this.anonymousModelHelper, this.names, null);
        }
        return tableType;
    }

    private void validateKeySpecifier(List<IdentifierNode> fieldList, BType constraintType) {
        for (IdentifierNode identifier : fieldList) {
            BField field = this.types.getTableConstraintField(constraintType, identifier.getValue());
            if (field == null) {
                this.dlog.error(identifier.getPosition(), DiagnosticErrorCode.INVALID_FIELD_NAMES_IN_KEY_SPECIFIER, identifier.getValue(), constraintType);
                continue;
            }
            if (Symbols.isFlagOn(field.symbol.flags, 32L)) continue;
            field.symbol.flags |= 0x20L;
        }
    }

    private void markReadOnlyForConstraintType(BType constraintType) {
        if (constraintType.tag != 12) {
            return;
        }
        BRecordType recordType = (BRecordType)constraintType;
        for (BField field : recordType.fields.values()) {
            if (Symbols.isFlagOn(field.symbol.flags, 32L)) continue;
            return;
        }
        if (recordType.sealed) {
            recordType.addFlags(32L);
            recordType.tsymbol.flags |= 0x20L;
        }
    }

    private BType getTypeOfTypeParameter(BType selectType, Location pos) {
        BType referredType = Types.getImpliedType(selectType);
        if (referredType.tag == 22) {
            referredType = ((BIntersectionType)referredType).effectiveType;
        }
        if (referredType.tag == 21) {
            BUnionType unionType = (BUnionType)referredType;
            LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>(((HashSet)unionType.getMemberTypes()).size());
            for (BType type : unionType.getMemberTypes()) {
                BType mapType = this.getTypeOfTypeParameter(type, pos);
                if (mapType == this.symTable.semanticError) {
                    return this.symTable.semanticError;
                }
                memberTypes.add(mapType);
            }
            return new BUnionType(this.types.typeEnv(), null, memberTypes, false);
        }
        return this.getQueryMapConstraintType(referredType, pos);
    }

    private BType getQueryMapConstraintType(BType type, Location pos) {
        List<BType> tupleTypeList;
        if (type.tag == 20) {
            BArrayType arrayType = (BArrayType)type;
            if (arrayType.state != BArrayState.OPEN && arrayType.getSize() == 2 && this.types.isAssignable(arrayType.eType, this.symTable.stringType)) {
                return arrayType.eType;
            }
        } else if (type.tag == 31 && (tupleTypeList = ((BTupleType)type).getTupleTypes()).size() == 2 && this.types.isAssignable(tupleTypeList.get(0), this.symTable.stringType)) {
            return tupleTypeList.get(1);
        }
        this.dlog.error(pos, DiagnosticErrorCode.INCOMPATIBLE_TYPE_IN_SELECT_CLAUSE, type);
        return this.symTable.semanticError;
    }

    private BType getCompletionType(List<BType> collectionTypes, Types.QueryConstructType queryConstructType, TypeChecker.AnalyzerData data) {
        LinkedHashSet<BType> completionTypes = new LinkedHashSet<BType>();
        BType completionType = null;
        for (BType collectionType : collectionTypes) {
            BType returnType;
            block18: {
                block17: {
                    if (collectionType.tag == 28) {
                        return null;
                    }
                    collectionType = Types.getImpliedType(collectionType);
                    switch (collectionType.tag) {
                        case 15: {
                            returnType = completionType = ((BStreamType)collectionType).completionType;
                            break;
                        }
                        case 34: {
                            returnType = this.types.getVarTypeFromIterableObject((BObjectType)collectionType);
                            break;
                        }
                        default: {
                            BSymbol itrSymbol = this.symResolver.lookupLangLibMethod(collectionType, Names.fromString("iterator"), data.env);
                            if (itrSymbol == this.symTable.notFoundSymbol) {
                                return null;
                            }
                            BInvokableSymbol invokableSymbol = (BInvokableSymbol)itrSymbol;
                            returnType = this.types.getResultTypeOfNextInvocation((BObjectType)Types.getImpliedType(invokableSymbol.retType));
                        }
                    }
                    if (returnType == null) continue;
                    if (queryConstructType == Types.QueryConstructType.STREAM) break block17;
                    if (queryConstructType != Types.QueryConstructType.ACTION) break block18;
                }
                this.types.getAllTypes(returnType, true).stream().filter(t -> this.types.isAssignable((BType)t, this.symTable.errorType) || this.types.isAssignable((BType)t, this.symTable.nilType)).forEach(completionTypes::add);
                continue;
            }
            this.types.getAllTypes(returnType, true).stream().filter(t -> this.types.isAssignable((BType)t, this.symTable.errorType)).forEach(completionTypes::add);
        }
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        if (data.queryData.queryCompletesEarly) {
            if (queryConstructType == Types.QueryConstructType.TABLE || queryConstructType == Types.QueryConstructType.MAP) {
                completionTypes.addAll(data.queryData.completeEarlyErrorList);
            }
        } else if (queryConstructType == Types.QueryConstructType.STREAM) {
            completionTypes.addAll(commonAnalyzerData.checkedErrorList);
            if (completionTypes.isEmpty()) {
                completionTypes.add(this.symTable.nilType);
            }
        }
        if (!completionTypes.isEmpty()) {
            completionType = completionTypes.size() == 1 ? (BType)completionTypes.iterator().next() : BUnionType.create(this.symTable.typeEnv(), null, completionTypes.toArray(new BType[0]));
        }
        return completionType;
    }

    private List<BType> getCollectionTypes(List<BLangNode> clauses) {
        return clauses.stream().filter(clause -> clause.getKind() == NodeKind.FROM || clause.getKind() == NodeKind.JOIN).map(clause -> ((BLangInputClause)clause).collection.getBType()).toList();
    }

    private BType getResolvedType(BType initType, BType expType, boolean isReadonly, SymbolEnv env) {
        if (initType.tag != 28 && (isReadonly || Symbols.isFlagOn(expType.getFlags(), 32L))) {
            return ImmutableTypeCloner.getImmutableIntersectionType(null, this.types, initType, env, this.symTable, this.anonymousModelHelper, this.names, null);
        }
        return initType;
    }

    private BType getNonContextualQueryType(BType constraintType, BType basicType, Location pos) {
        switch (Types.getImpliedType((BType)basicType).tag) {
            case 9: {
                if (!this.types.isAssignable(constraintType, this.symTable.mapAllType)) break;
                return this.symTable.tableType;
            }
            case 15: {
                return this.symTable.streamType;
            }
            case 16: {
                this.dlog.error(pos, DiagnosticErrorCode.INVALID_QUERY_CONSTRUCT_INFERRED_MAP, new Object[0]);
                return this.symTable.semanticError;
            }
            case 8: {
                if (!this.types.isSubTypeOfBaseType(constraintType, PredefinedType.XML)) break;
                return new BXMLType(constraintType, null);
            }
            case 5: {
                if (!this.types.isSubTypeOfBaseType(constraintType, PredefinedType.STRING)) break;
                return this.symTable.stringType;
            }
            case 20: 
            case 31: 
            case 34: {
                return new BArrayType(this.symTable.typeEnv(), constraintType);
            }
            default: {
                return this.symTable.semanticError;
            }
        }
        this.dlog.error(pos, DiagnosticErrorCode.INVALID_QUERY_CONSTRUCT_TYPE, basicType, constraintType);
        return this.symTable.semanticError;
    }

    private boolean validateTableType(BTableType tableType, TypeChecker.AnalyzerData data) {
        BType constraint = Types.getImpliedType(tableType.constraint);
        if (tableType.isTypeInlineDefined && !this.types.isAssignable(constraint, this.symTable.mapAllType)) {
            this.dlog.error(tableType.constraintPos, DiagnosticErrorCode.TABLE_CONSTRAINT_INVALID_SUBTYPE, constraint);
            data.resultType = this.symTable.semanticError;
            return false;
        }
        return true;
    }

    private BType checkInvocation(BLangExpression expr, TypeChecker.AnalyzerData data) {
        return this.checkExpr(expr, data.env, this.symTable.noType, data);
    }

    private BType checkExpr(BLangExpression expr, SymbolEnv env, TypeChecker.AnalyzerData data) {
        return this.checkExpr(expr, env, this.symTable.noType, data);
    }

    private BType checkExpr(BLangExpression expr, SymbolEnv env, BType expType, TypeChecker.AnalyzerData data) {
        return this.checkExpr(expr, env, expType, DiagnosticErrorCode.INCOMPATIBLE_TYPES, data);
    }

    @Override
    public void visit(BLangFromClause fromClause, TypeChecker.AnalyzerData data) {
        SymbolEnv fromEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        boolean prevBreakToParallelEnv = commonAnalyzerData.breakToParallelQueryEnv;
        BLangExpression collection = fromClause.collection;
        if (collection.getKind() == NodeKind.QUERY_EXPR || collection.getKind() == NodeKind.GROUP_EXPR && ((BLangGroupExpr)collection).expression.getKind() == NodeKind.QUERY_EXPR) {
            commonAnalyzerData.breakToParallelQueryEnv = true;
        }
        fromClause.env = fromEnv = SymbolEnv.createTypeNarrowedEnv(fromClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(fromEnv);
        this.checkExpr(fromClause.collection, fromEnv, data);
        this.types.setInputClauseTypedBindingPatternType(fromClause);
        this.handleInputClauseVariables(fromClause, fromEnv);
        commonAnalyzerData.breakToParallelQueryEnv = prevBreakToParallelEnv;
        for (Name variable : fromEnv.scope.entries.keySet()) {
            data.queryVariables.add(variable.value);
        }
    }

    private void handleInputClauseVariables(BLangInputClause bLangInputClause, SymbolEnv blockEnv) {
        if (bLangInputClause.variableDefinitionNode == null) {
            return;
        }
        BLangVariable variableNode = (BLangVariable)bLangInputClause.variableDefinitionNode.getVariable();
        BType inputClauseVarType = bLangInputClause.varType;
        if (bLangInputClause.isDeclaredWithVar) {
            this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, inputClauseVarType, blockEnv);
            return;
        }
        BType typeNodeType = this.symResolver.resolveTypeNode(variableNode.typeNode, blockEnv);
        if (inputClauseVarType.tag != 28) {
            if (this.types.isAssignable(inputClauseVarType, typeNodeType)) {
                this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, inputClauseVarType, blockEnv);
                return;
            }
            this.dlog.error(variableNode.typeNode.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, inputClauseVarType, typeNodeType);
        }
        this.semanticAnalyzer.handleDeclaredVarInForeach(variableNode, typeNodeType, blockEnv);
    }

    @Override
    public void visit(BLangJoinClause joinClause, TypeChecker.AnalyzerData data) {
        SymbolEnv joinEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        boolean prevBreakEnv = commonAnalyzerData.breakToParallelQueryEnv;
        BLangExpression collection = joinClause.collection;
        if (collection.getKind() == NodeKind.QUERY_EXPR || collection.getKind() == NodeKind.GROUP_EXPR && ((BLangGroupExpr)collection).expression.getKind() == NodeKind.QUERY_EXPR) {
            commonAnalyzerData.breakToParallelQueryEnv = true;
        }
        joinClause.env = joinEnv = SymbolEnv.createTypeNarrowedEnv(joinClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(joinEnv);
        this.checkExpr(joinClause.collection, joinEnv, data);
        this.types.setInputClauseTypedBindingPatternType(joinClause);
        if (joinClause.isOuterJoin) {
            if (!joinClause.isDeclaredWithVar) {
                this.dlog.error(joinClause.variableDefinitionNode.getPosition(), DiagnosticErrorCode.OUTER_JOIN_MUST_BE_DECLARED_WITH_VAR, new Object[0]);
                return;
            }
            joinClause.varType = this.types.addNilForNillableAccessType(joinClause.varType);
        }
        this.handleInputClauseVariables(joinClause, joinEnv);
        if (joinClause.onClause != null) {
            joinClause.onClause.accept(this, data);
        }
        for (Name variable : joinEnv.scope.entries.keySet()) {
            data.queryVariables.add(variable.value);
        }
        commonAnalyzerData.breakToParallelQueryEnv = prevBreakEnv;
    }

    @Override
    public void visit(BLangOnClause onClause, TypeChecker.AnalyzerData data) {
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        BLangNode joinNode = this.getLastInputNodeFromEnv(commonAnalyzerData.queryEnvs.peek());
        onClause.lhsEnv = this.getEnvBeforeInputNode(commonAnalyzerData.queryEnvs.peek(), joinNode);
        BType lhsType = this.checkExpr(onClause.lhsExpr, onClause.lhsEnv, data);
        onClause.rhsEnv = this.getEnvAfterJoinNode(commonAnalyzerData.queryEnvs.peek(), joinNode);
        BType rhsType = this.checkExpr(onClause.rhsExpr, onClause.rhsEnv, data);
        if (!this.types.isAssignable(lhsType, rhsType)) {
            this.dlog.error(onClause.rhsExpr.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, lhsType, rhsType);
        }
    }

    @Override
    public void visit(BLangLetClause letClause, TypeChecker.AnalyzerData data) {
        SymbolEnv letEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        letClause.env = letEnv = SymbolEnv.createTypeNarrowedEnv(letClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(letEnv);
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.semanticAnalyzer.analyzeNode((BLangNode)((Object)letVariable.definitionNode), letEnv, this, commonAnalyzerData);
        }
        for (Name variable : letEnv.scope.entries.keySet()) {
            data.queryVariables.add(variable.value);
        }
    }

    @Override
    public void visit(BLangWhereClause whereClause, TypeChecker.AnalyzerData data) {
        whereClause.env = this.handleFilterClauses(whereClause.expression, data);
    }

    private SymbolEnv handleFilterClauses(BLangExpression filterExpression, TypeChecker.AnalyzerData data) {
        this.checkExpr(filterExpression, data.commonAnalyzerData.queryEnvs.peek(), this.symTable.booleanType, data);
        BType actualType = filterExpression.getBType();
        if (31 == actualType.tag) {
            this.dlog.error(filterExpression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.booleanType, actualType);
        }
        SymbolEnv filterEnv = this.typeNarrower.evaluateTruth(filterExpression, data.commonAnalyzerData.queryFinalClauses.peek(), data.commonAnalyzerData.queryEnvs.pop());
        data.commonAnalyzerData.queryEnvs.push(filterEnv);
        return filterEnv;
    }

    @Override
    public void visit(BLangSelectClause selectClause, TypeChecker.AnalyzerData data) {
        SymbolEnv selectEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        selectClause.env = selectEnv = SymbolEnv.createTypeNarrowedEnv(selectClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(selectEnv);
    }

    @Override
    public void visit(BLangCollectClause collectClause, TypeChecker.AnalyzerData data) {
        SymbolEnv collectEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        collectClause.env = collectEnv = SymbolEnv.createTypeNarrowedEnv(collectClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(collectEnv);
        collectClause.nonGroupingKeys = new HashSet<String>(data.queryVariables);
        for (String var : collectClause.nonGroupingKeys) {
            Name name = new Name(var);
            BSymbol originalSymbol = this.symResolver.lookupSymbolInMainSpace(collectEnv, name);
            BSequenceSymbol sequenceSymbol = new BSequenceSymbol(originalSymbol.flags, name, originalSymbol.pkgID, new BSequenceType(this.symTable.typeEnv(), originalSymbol.getType()), originalSymbol.owner, originalSymbol.pos);
            collectEnv.scope.define(name, sequenceSymbol);
        }
    }

    @Override
    public void visit(BLangDoClause doClause, TypeChecker.AnalyzerData data) {
        SymbolEnv letEnv;
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        doClause.env = letEnv = SymbolEnv.createTypeNarrowedEnv(doClause, commonAnalyzerData.queryEnvs.pop());
        commonAnalyzerData.queryEnvs.push(letEnv);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause, TypeChecker.AnalyzerData data) {
        Types.CommonAnalyzerData commonAnalyzerData = data.commonAnalyzerData;
        BType type = this.checkExpr(onConflictClause.expression, commonAnalyzerData.queryEnvs.peek(), (BType)this.symTable.errorOrNilType, data);
        if (this.types.containsErrorType(type)) {
            data.queryData.queryCompletesEarly = true;
            if (data.queryData.completeEarlyErrorList != null) {
                BErrorType possibleErrorType = type.tag == 21 ? this.types.getErrorType((BUnionType)type) : this.types.getErrorType(BUnionType.create(this.symTable.typeEnv(), null, type));
                data.queryData.completeEarlyErrorList.add(possibleErrorType);
            }
        }
    }

    @Override
    public void visit(BLangLimitClause limitClause, TypeChecker.AnalyzerData data) {
        BType exprType = this.checkExpr(limitClause.expression, data.commonAnalyzerData.queryEnvs.peek(), data);
        if (!this.types.isAssignable(exprType, this.symTable.intType)) {
            this.dlog.error(limitClause.expression.pos, DiagnosticErrorCode.INCOMPATIBLE_TYPES, this.symTable.intType, exprType);
        }
    }

    @Override
    public void visit(BLangOrderByClause orderByClause, TypeChecker.AnalyzerData data) {
        orderByClause.env = data.commonAnalyzerData.queryEnvs.peek();
        for (OrderKeyNode orderKeyNode : orderByClause.getOrderKeyList()) {
            BType exprType = this.checkExpr((BLangExpression)orderKeyNode.getOrderKey(), orderByClause.env, data);
            if (exprType.tag == 28 || this.types.isOrderedType(exprType)) continue;
            this.dlog.error(((BLangOrderKey)orderKeyNode).expression.pos, DiagnosticErrorCode.ORDER_BY_NOT_SUPPORTED, new Object[0]);
        }
    }

    @Override
    public void visit(BLangGroupByClause groupByClause, TypeChecker.AnalyzerData data) {
        SymbolEnv groupByEnv;
        groupByClause.env = groupByEnv = SymbolEnv.createTypeNarrowedEnv(groupByClause, data.commonAnalyzerData.queryEnvs.pop());
        data.commonAnalyzerData.queryEnvs.push(groupByEnv);
        groupByClause.nonGroupingKeys = new HashSet<String>(data.queryVariables);
        for (BLangGroupingKey groupingKey : groupByClause.groupingKeyList) {
            BType keyType;
            String variable;
            if (groupingKey.variableRef != null) {
                this.checkExpr(groupingKey.variableRef, groupByClause.env, data);
                variable = groupingKey.variableRef.variableName.value;
                keyType = groupingKey.variableRef.getBType();
            } else {
                this.semanticAnalyzer.analyzeNode((BLangNode)groupingKey.variableDef, groupByClause.env, this, data.commonAnalyzerData);
                variable = groupingKey.variableDef.var.name.value;
                data.queryVariables.add(variable);
                keyType = groupingKey.variableDef.var.getBType();
            }
            if (!this.types.isAssignable(keyType, this.symTable.anydataType)) {
                this.dlog.error(groupingKey.pos, DiagnosticErrorCode.INVALID_GROUPING_KEY_TYPE, keyType);
            }
            groupByClause.nonGroupingKeys.remove(variable);
        }
        for (String var : groupByClause.nonGroupingKeys) {
            Name name = new Name(var);
            BSymbol originalSymbol = this.symResolver.lookupSymbolInMainSpace(groupByEnv, name);
            BSequenceSymbol sequenceSymbol = new BSequenceSymbol(originalSymbol.flags, name, originalSymbol.pkgID, new BSequenceType(this.symTable.typeEnv(), originalSymbol.getType()), originalSymbol.owner, originalSymbol.pos);
            groupByEnv.scope.define(name, sequenceSymbol);
        }
    }

    @Override
    public void visit(BLangGroupingKey node, TypeChecker.AnalyzerData data) {
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr, TypeChecker.AnalyzerData data) {
        this.visitCheckAndCheckPanicExpr(checkedExpr, data);
        if (checkedExpr.equivalentErrorTypeList != null) {
            data.commonAnalyzerData.checkedErrorList.addAll(checkedExpr.equivalentErrorTypeList);
        }
    }

    @Override
    public void visit(BLangInvocation iExpr, TypeChecker.AnalyzerData data) {
        boolean langLibPackageID;
        BType invocationType;
        if (!this.hasSequenceArgs(iExpr, data)) {
            super.visit(iExpr, data);
            return;
        }
        Name pkgAlias = this.names.fromIdNode(iExpr.pkgAlias);
        BSymbol pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, pkgAlias, this.getCurrentCompUnit(iExpr));
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, pkgAlias);
        }
        if (iExpr.expr != null) {
            invocationType = this.checkInvocation(iExpr.expr, data);
            iExpr.argExprs.add(0, iExpr.expr);
        } else {
            BType firstArgType = this.silentTypeCheckExpr(iExpr.argExprs.get(0), this.symTable.noType, data);
            invocationType = firstArgType.tag == 54 ? ((BSequenceType)firstArgType).elementType : firstArgType;
        }
        Name funcName = this.names.fromIdNode(iExpr.name);
        BSymbol symbol = this.symResolver.lookupLangLibMethod(invocationType, funcName, data.env);
        if (symbol == this.symTable.notFoundSymbol) {
            symbol = this.symResolver.lookupMainSpaceSymbolInPackage(iExpr.pos, data.env, pkgAlias, funcName);
            if (symbol == this.symTable.notFoundSymbol) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.UNDEFINED_FUNCTION, funcName);
                return;
            }
            if (!Symbols.isFlagOn(symbol.flags, 0x400000L)) {
                this.dlog.error(iExpr.pos, DiagnosticErrorCode.USER_DEFINED_FUNCTIONS_ARE_DISALLOWED_WITH_AGGREGATED_VARIABLES, new Object[0]);
                return;
            }
        }
        if (langLibPackageID = PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            data.env = SymbolEnv.createInvocationEnv(iExpr, data.env);
        }
        BInvokableSymbol functionSymbol = (BInvokableSymbol)symbol;
        iExpr.symbol = functionSymbol;
        int argCount = 0;
        List<BVarSymbol> params = functionSymbol.params;
        for (int i = 0; i < params.size(); ++i) {
            BLangExpression arg = iExpr.argExprs.get(i);
            BType argType = this.silentTypeCheckExpr(arg, this.symTable.noType, data);
            if (argType.tag == 54) {
                this.types.checkType(arg.pos, ((BSequenceType)argType).elementType, params.get((int)i).type, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                continue;
            }
            this.checkArg(arg, params.get((int)i).type, data);
            iExpr.requiredArgs.add(arg);
            ++argCount;
        }
        boolean foundSeqRestArg = false;
        for (int i = argCount; i < iExpr.argExprs.size(); ++i) {
            BLangExpression argExpr = iExpr.argExprs.get(i);
            if (functionSymbol.restParam == null) continue;
            if (foundSeqRestArg) {
                this.dlog.error(argExpr.pos, DiagnosticErrorCode.SEQ_ARG_FOLLOWED_BY_ANOTHER_SEQ_ARG, new Object[0]);
                continue;
            }
            BType restParamType = functionSymbol.restParam.type;
            NodeKind argExprKind = argExpr.getKind();
            iExpr.restArgs.add(argExpr);
            if (argExprKind == NodeKind.SIMPLE_VARIABLE_REF && this.silentTypeCheckExpr((BLangExpression)argExpr, (BType)this.symTable.noType, (TypeChecker.AnalyzerData)data).tag == 54) {
                foundSeqRestArg = true;
                this.checkArg(argExpr, restParamType, data);
                continue;
            }
            if (restParamType.tag == 20) {
                this.checkArg(argExpr, ((BArrayType)restParamType).eType, data);
                continue;
            }
            this.checkArg(argExpr, restParamType, data);
        }
        BInvokableType bInvokableType = (BInvokableType)Types.getImpliedType(functionSymbol.type);
        BType retType = this.typeParamAnalyzer.getReturnTypeParams(data.env, bInvokableType.getReturnType());
        data.resultType = this.types.checkType(iExpr, retType, data.expType);
    }

    private boolean isNilReturnInvocationInCollectClause(BLangInvocation invocation, TypeChecker.AnalyzerData data) {
        BInvokableSymbol symbol = (BInvokableSymbol)invocation.symbol;
        return symbol != null && symbol.restParam != null && !symbol.params.isEmpty() && invocation.argExprs.size() == 1 && invocation.restArgs.size() == 1;
    }

    private boolean hasSequenceArgs(BLangInvocation invocation, TypeChecker.AnalyzerData data) {
        for (BLangExpression arg : invocation.argExprs) {
            if (arg.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
            BType argType = this.silentTypeCheckExpr(arg, this.symTable.noType, data);
            if (argType.tag != 54) continue;
            return true;
        }
        return false;
    }

    private void checkArg(BLangExpression arg, BType expectedType, TypeChecker.AnalyzerData data) {
        data.queryData.withinSequenceContext = arg.getKind() == NodeKind.SIMPLE_VARIABLE_REF;
        this.checkTypeParamExpr(arg, expectedType, data);
        data.queryData.withinSequenceContext = false;
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation, TypeChecker.AnalyzerData data) {
        BLangInvocation invocation = collectContextInvocation.invocation;
        data.resultType = this.checkExpr(invocation, data.env, data);
        if (this.isNilReturnInvocationInCollectClause(invocation, data)) {
            data.resultType = BUnionType.create(this.symTable.typeEnv(), null, data.resultType, this.symTable.nilType);
        }
        collectContextInvocation.setBType(data.resultType);
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr, TypeChecker.AnalyzerData data) {
        BSymbol pkgSymbol;
        BType actualType = this.symTable.semanticError;
        BLangIdentifier identifier = varRefExpr.variableName;
        Name varName = this.names.fromIdNode(identifier);
        if (varName == Names.IGNORE) {
            varRefExpr.setBType(this.symTable.anyType);
            varRefExpr.symbol = new BVarSymbol(0L, true, varName, this.names.originalNameFromIdNode(identifier), data.env.enclPkg.symbol.pkgID, varRefExpr.getBType(), data.env.scope.owner, varRefExpr.pos, SymbolOrigin.VIRTUAL);
            data.resultType = varRefExpr.getBType();
            return;
        }
        Name compUnitName = this.getCurrentCompUnit(varRefExpr);
        varRefExpr.pkgSymbol = pkgSymbol = this.symResolver.resolvePrefixSymbol(data.env, this.names.fromIdNode(varRefExpr.pkgAlias), compUnitName);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            varRefExpr.symbol = this.symTable.notFoundSymbol;
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNDEFINED_MODULE, varRefExpr.pkgAlias);
        }
        if (pkgSymbol.tag == 8193L) {
            actualType = this.symTable.stringType;
        } else if (pkgSymbol != this.symTable.notFoundSymbol) {
            BSymbol symbol = this.symResolver.lookupMainSpaceSymbolInPackage(varRefExpr.pos, data.env, this.names.fromIdNode(varRefExpr.pkgAlias), varName);
            BLangType enclType = data.env.enclType;
            if (symbol == this.symTable.notFoundSymbol && enclType != null && enclType.getBType().tsymbol.scope != null) {
                Name objFuncName = Names.fromString(Symbols.getAttachedFuncSymbolName(enclType.getBType().tsymbol.name.value, varName.value));
                symbol = this.symResolver.resolveStructField(varRefExpr.pos, data.env, objFuncName, enclType.getBType().tsymbol);
            }
            if ((symbol.tag & 0x34L) == 52L) {
                BVarSymbol varSym = (BVarSymbol)symbol;
                this.checkSelfReferences(varRefExpr.pos, data.env, varSym);
                varRefExpr.symbol = varSym;
                actualType = varSym.type;
                this.markAndRegisterClosureVariable(symbol, varRefExpr.pos, data.env, data);
            } else if ((symbol.tag & 0x100000004L) == 0x100000004L) {
                varRefExpr.symbol = symbol;
                actualType = symbol.type;
                if (!data.queryData.withinSequenceContext) {
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.SEQUENCE_VARIABLE_CAN_BE_USED_IN_SINGLE_ELEMENT_LIST_CTR_OR_FUNC_INVOCATION, new Object[0]);
                }
                if (actualType.tag == 54 && ((BSequenceType)actualType).elementType.tag == 54) {
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.VARIABLE_IS_SEQUENCED_MORE_THAN_ONCE, varName);
                }
            } else if ((symbol.tag & 0x801CL) == 32796L) {
                actualType = symbol.type.tag == 13 ? symbol.type : new BTypedescType(this.symTable.typeEnv(), symbol.type, null);
                varRefExpr.symbol = symbol;
            } else if ((symbol.tag & 0x100001CL) == 0x100001CL) {
                BConstantSymbol constSymbol = (BConstantSymbol)symbol;
                varRefExpr.symbol = constSymbol;
                BType symbolType = symbol.type;
                BType expectedType = Types.getImpliedType(data.expType);
                actualType = symbolType != this.symTable.noType && expectedType.tag == 33 || expectedType.tag == 21 && this.types.getAllTypes(expectedType, true).stream().anyMatch(memType -> memType.tag == 33 && this.types.isAssignable(symbolType, (BType)memType)) ? symbolType : constSymbol.literalType;
                if (varRefExpr.isLValue || varRefExpr.isCompoundAssignmentLValue) {
                    actualType = this.symTable.semanticError;
                    this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_UPDATE_CONSTANT_VALUE, new Object[0]);
                }
            } else {
                varRefExpr.symbol = symbol;
                this.logUndefinedSymbolError(varRefExpr.pos, varName.value);
            }
        }
        if (data.expType.tag == 20 && this.isArrayOpenSealedType((BArrayType)data.expType)) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.CANNOT_INFER_SIZE_ARRAY_SIZE_FROM_THE_CONTEXT, new Object[0]);
            data.resultType = this.symTable.semanticError;
            return;
        }
        data.resultType = this.types.checkType(varRefExpr, actualType, data.expType);
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructor, TypeChecker.AnalyzerData data) {
        BLangExpression expr;
        BType expType = data.expType;
        if (listConstructor.exprs.size() == 1 && (expr = listConstructor.exprs.get(0)).getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
            BType type = this.silentTypeCheckExpr(expr, this.symTable.noType, data);
            if (type.tag == 54) {
                data.queryData.withinSequenceContext = true;
                this.checkExpr(expr, data.env, this.symTable.noType, data);
                data.queryData.withinSequenceContext = false;
                data.resultType = this.types.checkType(listConstructor.pos, (BType)new BTupleType(this.symTable.typeEnv(), null, new ArrayList<BTupleMember>(0), ((BSequenceType)type).elementType, 0L), expType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
                listConstructor.setBType(data.resultType);
                return;
            }
        }
        super.visit(listConstructor, data);
    }

    private void checkTupleWithSequence(BType type) {
        if (type.tag != 31) {
            return;
        }
        BTupleType tupleType = (BTupleType)type;
        if (tupleType.getMembers().size() != 1) {
            return;
        }
        BTupleMember memberType = tupleType.getMembers().get(0);
        if (memberType.type.tag == 54) {
            tupleType.restType = ((BSequenceType)memberType.type).elementType;
            tupleType.getMembers().clear();
        }
    }

    private SymbolEnv getEnvAfterJoinNode(SymbolEnv env, BLangNode node) {
        SymbolEnv clone = env.createClone();
        while (clone != null && clone.node != node) {
            clone = clone.enclEnv;
        }
        if (clone != null) {
            clone.enclEnv = this.getEnvBeforeInputNode(clone.enclEnv, this.getLastInputNodeFromEnv(clone.enclEnv));
        } else {
            clone = new SymbolEnv(node, null);
        }
        return clone;
    }

    private SymbolEnv getEnvBeforeInputNode(SymbolEnv env, BLangNode node) {
        while (env != null && env.node != node) {
            env = env.enclEnv;
        }
        return env != null && env.enclEnv != null ? env.enclEnv.createClone() : new SymbolEnv(node, null);
    }

    private BLangNode getLastInputNodeFromEnv(SymbolEnv env) {
        while (env != null && env.node.getKind() != NodeKind.FROM && env.node.getKind() != NodeKind.JOIN) {
            env = env.enclEnv;
        }
        return env != null ? env.node : null;
    }

    public static class AnalyzerData {
        boolean queryCompletesEarly = false;
        HashSet<BType> completeEarlyErrorList = new HashSet();
        boolean withinSequenceContext = false;
    }
}

