/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRegexpType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStringSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLSubType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Lists;

public class SymbolTable {
    private static final CompilerContext.Key<SymbolTable> SYM_TABLE_KEY = new CompilerContext.Key();
    public static final PackageID TRANSACTION = new PackageID(Names.BUILTIN_ORG, Names.TRANSACTION_PACKAGE, Names.EMPTY);
    public static final Integer BBYTE_MIN_VALUE = 0;
    public static final Integer BBYTE_MAX_VALUE = 255;
    public static final Integer SIGNED32_MAX_VALUE = Integer.MAX_VALUE;
    public static final Integer SIGNED32_MIN_VALUE = Integer.MIN_VALUE;
    public static final Integer SIGNED16_MAX_VALUE = Short.MAX_VALUE;
    public static final Integer SIGNED16_MIN_VALUE = Short.MIN_VALUE;
    public static final Integer SIGNED8_MAX_VALUE = 127;
    public static final Integer SIGNED8_MIN_VALUE = -128;
    public static final Long UNSIGNED32_MAX_VALUE = 0xFFFFFFFFL;
    public static final Integer UNSIGNED16_MAX_VALUE = 65535;
    public static final Integer UNSIGNED8_MAX_VALUE = 255;
    public final Location builtinPos;
    public final BLangPackage rootPkgNode;
    public final BPackageSymbol rootPkgSymbol;
    public final BSymbol notFoundSymbol;
    public final Scope rootScope;
    public final BType noType = new BNoType(24);
    public final BType nilType = BType.createNilType();
    public final BType neverType = BType.createNeverType();
    public final BType intType = new BType(1, null, 32L, (SemType)PredefinedType.INT);
    public final BType byteType = new BType(2, null, 32L, PredefinedType.BYTE);
    public final BType floatType = new BType(3, null, 32L, (SemType)PredefinedType.FLOAT);
    public final BType decimalType = new BType(4, null, 32L, (SemType)PredefinedType.DECIMAL);
    public final BType stringType = new BType(5, null, 32L, (SemType)PredefinedType.STRING);
    public final BType booleanType = new BType(6, null, 32L, (SemType)PredefinedType.BOOLEAN);
    public final BType anyType = new BAnyType();
    public final BMapType mapType;
    public final BMapType mapStringType;
    public final BFutureType futureType;
    public final BArrayType arrayType;
    public final BArrayType byteArrayType;
    public final BArrayType arrayStringType;
    BVarSymbol varSymbol = new BVarSymbol(0L, null, null, this.noType, null, null, SymbolOrigin.VIRTUAL);
    public final BType tupleType;
    public final BType recordType;
    public final BType stringArrayType;
    public final BType handleType = new BHandleType();
    public final BTypedescType typeDesc;
    public final BType readonlyType = new BReadonlyType();
    public final BType pathParamAllowedType;
    public final BType interpolationAllowedType;
    public final BIntersectionType anyAndReadonly;
    public BUnionType anyAndReadonlyOrError;
    public final BType semanticError = new BType(28, null, (SemType)PredefinedType.NEVER);
    public final BType nullSet = new BType(51, null, (SemType)PredefinedType.NEVER);
    public final BType invokableType;
    public final BType empty = new BType(54, null);
    public BUnionType anyOrErrorType;
    public BUnionType pureType;
    public BUnionType errorOrNilType;
    public BType trueType;
    public BType falseType;
    public BObjectType intRangeType;
    public BMapType mapAllType;
    public BArrayType arrayAllType;
    public BObjectType rawTemplateType;
    public BObjectType iterableType;
    public final BIntSubType signed32IntType = BIntSubType.SIGNED32;
    public final BIntSubType signed16IntType = BIntSubType.SIGNED16;
    public final BIntSubType signed8IntType = BIntSubType.SIGNED8;
    public final BIntSubType unsigned32IntType = BIntSubType.UNSIGNED32;
    public final BIntSubType unsigned16IntType = BIntSubType.UNSIGNED16;
    public final BIntSubType unsigned8IntType = BIntSubType.UNSIGNED8;
    public final BStringSubType charStringType = BStringSubType.CHAR;
    public final BXMLSubType xmlElementType = BXMLSubType.XML_ELEMENT;
    public final BXMLSubType xmlPIType = BXMLSubType.XML_PI;
    public final BXMLSubType xmlCommentType = BXMLSubType.XML_COMMENT;
    public final BXMLSubType xmlTextType = BXMLSubType.XML_TEXT;
    public final BRegexpType regExpType = new BRegexpType();
    public final BType xmlNeverType = new BXMLType(this.neverType, null);
    public final BType xmlType;
    public final BType xmlElementSeqType = new BXMLType(this.xmlElementType, null);
    public BAnydataType anydataType;
    public BArrayType arrayAnydataType;
    public BMapType mapAnydataType;
    public BType anydataOrReadonly;
    public BType streamType;
    public BType tableType;
    public BArrayType arrayJsonType;
    public BMapType mapJsonType;
    public BJSONType jsonType;
    public BUnionType cloneableType;
    public BMapType detailType;
    public BErrorType errorType;
    public BPackageSymbol langInternalModuleSymbol;
    public BPackageSymbol langAnnotationModuleSymbol;
    public BPackageSymbol langJavaModuleSymbol;
    public BPackageSymbol langArrayModuleSymbol;
    public BPackageSymbol langDecimalModuleSymbol;
    public BPackageSymbol langErrorModuleSymbol;
    public BPackageSymbol langFloatModuleSymbol;
    public BPackageSymbol langFutureModuleSymbol;
    public BPackageSymbol langFunctionModuleSymbol;
    public BPackageSymbol langIntModuleSymbol;
    public BPackageSymbol langMapModuleSymbol;
    public BPackageSymbol langObjectModuleSymbol;
    public BPackageSymbol langStreamModuleSymbol;
    public BPackageSymbol langStringModuleSymbol;
    public BPackageSymbol langTableModuleSymbol;
    public BPackageSymbol langTypedescModuleSymbol;
    public BPackageSymbol langValueModuleSymbol;
    public BPackageSymbol langXmlModuleSymbol;
    public BPackageSymbol langBooleanModuleSymbol;
    public BPackageSymbol langQueryModuleSymbol;
    public BPackageSymbol langRuntimeModuleSymbol;
    public BPackageSymbol langTransactionModuleSymbol;
    public BPackageSymbol internalTransactionModuleSymbol;
    public BPackageSymbol langRegexpModuleSymbol;
    private final Names names;
    private final Types types;
    public Map<BPackageSymbol, SymbolEnv> pkgEnvMap = new HashMap<BPackageSymbol, SymbolEnv>();
    public Map<Name, BPackageSymbol> predeclaredModules = new HashMap<Name, BPackageSymbol>();
    public Map<String, Map<SelectivelyImmutableReferenceType, BIntersectionType>> immutableTypeMaps = new HashMap<String, Map<SelectivelyImmutableReferenceType, BIntersectionType>>();

    public static SymbolTable getInstance(CompilerContext context) {
        SymbolTable symTable = context.get(SYM_TABLE_KEY);
        if (symTable == null) {
            symTable = new SymbolTable(context);
        }
        return symTable;
    }

    private SymbolTable(CompilerContext context) {
        context.put(SYM_TABLE_KEY, this);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.rootPkgNode = (BLangPackage)TreeBuilder.createPackageNode(this.types.typeEnv());
        this.rootPkgSymbol = new BPackageSymbol(PackageID.ANNOTATIONS, null, null, SymbolOrigin.BUILTIN);
        this.rootPkgNode.pos = this.builtinPos = new BLangDiagnosticLocation(Names.EMPTY.value, -1, -1, -1, -1);
        this.rootPkgNode.symbol = this.rootPkgSymbol;
        this.rootPkgSymbol.scope = this.rootScope = new Scope(this.rootPkgSymbol);
        this.rootPkgSymbol.pos = this.builtinPos;
        this.notFoundSymbol = new BSymbol(0L, 1L, Names.INVALID, this.rootPkgSymbol.pkgID, this.noType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.VIRTUAL);
        this.initializeType(this.intType, TypeKind.INT.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.byteType, TypeKind.BYTE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.floatType, TypeKind.FLOAT.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.decimalType, TypeKind.DECIMAL.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.stringType, TypeKind.STRING.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.booleanType, TypeKind.BOOLEAN.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.anyType, TypeKind.ANY.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.nilType, TypeKind.NIL.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.neverType, TypeKind.NEVER.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.handleType, TypeKind.HANDLE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.readonlyType, TypeKind.READONLY.typeName(), SymbolOrigin.BUILTIN);
        this.initializeTSymbol(this.signed32IntType, Names.SIGNED32, PackageID.INT);
        this.initializeTSymbol(this.signed16IntType, Names.SIGNED16, PackageID.INT);
        this.initializeTSymbol(this.signed8IntType, Names.SIGNED8, PackageID.INT);
        this.initializeTSymbol(this.unsigned32IntType, Names.UNSIGNED32, PackageID.INT);
        this.initializeTSymbol(this.unsigned16IntType, Names.UNSIGNED16, PackageID.INT);
        this.initializeTSymbol(this.unsigned8IntType, Names.UNSIGNED8, PackageID.INT);
        this.initializeTSymbol(this.charStringType, Names.CHAR, PackageID.STRING);
        this.initializeTSymbol(this.xmlElementType, Names.XML_ELEMENT, PackageID.XML);
        this.initializeTSymbol(this.xmlPIType, Names.XML_PI, PackageID.XML);
        this.initializeTSymbol(this.xmlCommentType, Names.XML_COMMENT, PackageID.XML);
        this.initializeTSymbol(this.xmlTextType, Names.XML_TEXT, PackageID.XML);
        this.initializeTSymbol(this.regExpType, Names.REGEXP_TYPE, PackageID.REGEXP);
        BLangLiteral trueLiteral = new BLangLiteral();
        trueLiteral.setBType(this.booleanType);
        trueLiteral.value = Boolean.TRUE;
        BLangLiteral falseLiteral = new BLangLiteral();
        falseLiteral.setBType(this.booleanType);
        falseLiteral.value = Boolean.FALSE;
        this.arrayType = new BArrayType(this.types.typeEnv(), this.anyType);
        this.byteArrayType = new BArrayType(this.types.typeEnv(), this.byteType);
        this.arrayStringType = new BArrayType(this.types.typeEnv(), this.stringType);
        this.stringArrayType = new BArrayType(this.types.typeEnv(), this.stringType);
        this.mapType = new BMapType(this.typeEnv(), 16, this.anyType, null);
        this.mapStringType = new BMapType(this.typeEnv(), 16, this.stringType, null);
        this.initializeType((BType)this.mapType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
        this.initializeType((BType)this.mapStringType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
        this.pathParamAllowedType = BUnionType.create(this.types.typeEnv(), null, this.intType, this.stringType, this.floatType, this.booleanType, this.decimalType);
        this.interpolationAllowedType = BUnionType.create(this.types.typeEnv(), null, this.intType, this.floatType, this.decimalType, this.stringType, this.booleanType);
        this.tupleType = new BTupleType(this.types.typeEnv(), Lists.of(new BTupleMember(this.noType, this.varSymbol)));
        this.recordType = new BRecordType(this.typeEnv(), null);
        this.invokableType = new BInvokableType(this.types.typeEnv(), List.of(), null, null, null);
        this.xmlType = new BXMLType(BUnionType.create(this.types.typeEnv(), null, this.xmlElementType, this.xmlCommentType, this.xmlPIType, this.xmlTextType), null);
        this.futureType = new BFutureType(this.types.typeEnv(), this.nilType, null, (SemType)PredefinedType.FUTURE);
        this.typeDesc = new BTypedescType(this.types.typeEnv(), this.anyType, null, (SemType)PredefinedType.TYPEDESC);
        this.initializeType(this.xmlType, TypeKind.XML.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType((BType)this.futureType, TypeKind.FUTURE.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType((BType)this.typeDesc, TypeKind.TYPEDESC.typeName(), SymbolOrigin.BUILTIN);
        this.defineCyclicUnionBasedInternalTypes();
        BTypeSymbol trueFiniteTypeSymbol = Symbols.createTypeSymbol(557084L, 1L, Names.fromString("$anonType$TRUE"), this.rootPkgNode.packageID, null, this.rootPkgNode.symbol.owner, this.builtinPos, SymbolOrigin.VIRTUAL);
        this.trueType = BFiniteType.newSingletonBFiniteType(trueFiniteTypeSymbol, SemTypes.booleanConst((boolean)true));
        BTypeSymbol falseFiniteTypeSymbol = Symbols.createTypeSymbol(557084L, 1L, Names.fromString("$anonType$FALSE"), this.rootPkgNode.packageID, null, this.rootPkgNode.symbol.owner, this.builtinPos, SymbolOrigin.VIRTUAL);
        this.falseType = BFiniteType.newSingletonBFiniteType(falseFiniteTypeSymbol, SemTypes.booleanConst((boolean)false));
        this.anyAndReadonly = ImmutableTypeCloner.getImmutableIntersectionType(this.anyType, this, this.names, this.types, this.rootPkgSymbol.pkgID);
        this.initializeType((BType)this.anyAndReadonly, this.anyAndReadonly.effectiveType.name.getValue(), SymbolOrigin.BUILTIN);
        this.invokableType.setFlags(0x8000000000L);
        BInvokableTypeSymbol tSymbol = Symbols.createInvokableTypeSymbol(33587228L, 0x8000000000L, this.rootPkgSymbol.pkgID, this.invokableType, this.rootPkgNode.symbol.scope.owner, this.builtinPos, SymbolOrigin.BUILTIN);
        tSymbol.params = null;
        tSymbol.restParam = null;
        tSymbol.returnType = null;
        this.invokableType.tsymbol = tSymbol;
        this.defineReadonlyCompoundType();
    }

    private void defineReadonlyCompoundType() {
        this.anyAndReadonlyOrError = BUnionType.create(this.typeEnv(), null, this.anyAndReadonly, this.errorType);
    }

    public BType getTypeFromTag(int tag) {
        return switch (tag) {
            case 1 -> this.intType;
            case 2 -> this.byteType;
            case 3 -> this.floatType;
            case 4 -> this.decimalType;
            case 5 -> this.stringType;
            case 6 -> this.booleanType;
            case 7 -> this.jsonType;
            case 8 -> this.xmlType;
            case 48 -> this.xmlCommentType;
            case 47 -> this.xmlPIType;
            case 46 -> this.xmlElementType;
            case 49 -> this.xmlTextType;
            case 15 -> this.streamType;
            case 9 -> this.tableType;
            case 10 -> this.nilType;
            case 50 -> this.neverType;
            case 29 -> this.errorType;
            case 39 -> this.signed32IntType;
            case 40 -> this.signed16IntType;
            case 41 -> this.signed8IntType;
            case 42 -> this.unsigned32IntType;
            case 43 -> this.unsigned16IntType;
            case 44 -> this.unsigned8IntType;
            case 45 -> this.charStringType;
            case 53 -> this.regExpType;
            case 35 -> this.byteArrayType;
            default -> this.semanticError;
        };
    }

    public BType getLangLibSubType(String name) {
        return switch (name) {
            case "Signed32" -> this.signed32IntType;
            case "Signed16" -> this.signed16IntType;
            case "Signed8" -> this.signed8IntType;
            case "Unsigned32" -> this.unsigned32IntType;
            case "Unsigned16" -> this.unsigned16IntType;
            case "Unsigned8" -> this.unsigned8IntType;
            case "Char" -> this.charStringType;
            case "Element" -> this.xmlElementType;
            case "ProcessingInstruction" -> this.xmlPIType;
            case "Comment" -> this.xmlCommentType;
            case "Text" -> this.xmlTextType;
            case "RegExp" -> this.regExpType;
            default -> throw new IllegalStateException("LangLib Subtype not found: " + name);
        };
    }

    public void loadPredeclaredModules() {
        this.predeclaredModules = Map.ofEntries(Map.entry(Names.BOOLEAN, this.langBooleanModuleSymbol), Map.entry(Names.DECIMAL, this.langDecimalModuleSymbol), Map.entry(Names.ERROR, this.langErrorModuleSymbol), Map.entry(Names.FLOAT, this.langFloatModuleSymbol), Map.entry(Names.FUNCTION, this.langFunctionModuleSymbol), Map.entry(Names.FUTURE, this.langFutureModuleSymbol), Map.entry(Names.INT, this.langIntModuleSymbol), Map.entry(Names.MAP, this.langMapModuleSymbol), Map.entry(Names.OBJECT, this.langObjectModuleSymbol), Map.entry(Names.STREAM, this.langStreamModuleSymbol), Map.entry(Names.STRING, this.langStringModuleSymbol), Map.entry(Names.TABLE, this.langTableModuleSymbol), Map.entry(Names.TRANSACTION, this.langTransactionModuleSymbol), Map.entry(Names.TYPEDESC, this.langTypedescModuleSymbol), Map.entry(Names.XML, this.langXmlModuleSymbol));
    }

    public void initializeType(BType type, String name, SymbolOrigin origin) {
        this.initializeType(type, Names.fromString(name), origin);
    }

    private void initializeType(BType type, Name name, SymbolOrigin origin) {
        this.defineType(type, new BTypeSymbol(12L, 1L, name, this.rootPkgSymbol.pkgID, type, this.rootPkgSymbol, this.builtinPos, origin));
    }

    private void initializeTSymbol(BType type, Name name, PackageID packageID) {
        type.tsymbol = new BTypeSymbol(32796L, 1L, name, packageID, type, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
    }

    private void defineType(BType type, BTypeSymbol tSymbol) {
        type.tsymbol = tSymbol;
        this.rootScope.define(tSymbol.name, tSymbol);
    }

    public void updateBuiltinSubtypeOwners() {
        this.updateIntSubtypeOwners();
        this.updateRegExpTypeOwners();
        this.updateStringSubtypeOwners();
        this.updateXMLSubtypeOwners();
    }

    public void updateIntSubtypeOwners() {
        this.signed8IntType.tsymbol.owner = this.langIntModuleSymbol;
        this.unsigned8IntType.tsymbol.owner = this.langIntModuleSymbol;
        this.signed16IntType.tsymbol.owner = this.langIntModuleSymbol;
        this.unsigned16IntType.tsymbol.owner = this.langIntModuleSymbol;
        this.signed32IntType.tsymbol.owner = this.langIntModuleSymbol;
        this.unsigned32IntType.tsymbol.owner = this.langIntModuleSymbol;
    }

    public void updateStringSubtypeOwners() {
        this.charStringType.tsymbol.owner = this.langStringModuleSymbol;
    }

    public void updateXMLSubtypeOwners() {
        this.xmlElementType.tsymbol.owner = this.langXmlModuleSymbol;
        this.xmlCommentType.tsymbol.owner = this.langXmlModuleSymbol;
        this.xmlPIType.tsymbol.owner = this.langXmlModuleSymbol;
        this.xmlTextType.tsymbol.owner = this.langXmlModuleSymbol;
    }

    public void updateRegExpTypeOwners() {
        this.regExpType.tsymbol.owner = this.langRegexpModuleSymbol;
    }

    public void defineOperators() {
        this.defineIntegerArithmeticOperations();
        this.defineNilableIntegerArithmeticOperations();
        this.defineIntFloatingPointArithmeticOperations();
        this.defineNilableIntFloatingPointArithmeticOperations();
        this.defineNilableIntegerBitwiseAndOperations();
        this.defineNilableIntegerBitwiseOrAndXorOperations(OperatorKind.BITWISE_OR);
        this.defineNilableIntegerBitwiseOrAndXorOperations(OperatorKind.BITWISE_XOR);
        this.defineNilableIntegerLeftShiftOperations();
        this.defineNilableIntegerRightShiftOperations(OperatorKind.BITWISE_RIGHT_SHIFT);
        this.defineNilableIntegerRightShiftOperations(OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT);
        this.defineNilableIntegerUnaryOperations();
        this.defineNilableFloatingPointOperations();
        this.defineXmlStringConcatanationOperations();
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.stringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.charStringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.stringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.charStringType, this.stringType);
        this.defineBinaryOperator(OperatorKind.ADD, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.ADD, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.SUB, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.SUB, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.DIV, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MUL, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, this.decimalType, this.decimalType);
        this.defineBinaryOperator(OperatorKind.MOD, this.floatType, this.floatType, this.floatType);
        this.defineBinaryOperator(OperatorKind.MOD, this.decimalType, this.decimalType, this.decimalType);
        this.defineIntegerBitwiseAndOperations();
        this.defineIntegerBitwiseOrOperations(OperatorKind.BITWISE_OR);
        this.defineIntegerBitwiseOrOperations(OperatorKind.BITWISE_XOR);
        this.defineIntegerLeftShiftOperations();
        this.defineIntegerRightShiftOperations(OperatorKind.BITWISE_RIGHT_SHIFT);
        this.defineIntegerRightShiftOperations(OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.NOT_EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.jsonType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.jsonType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.anyType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.anyType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.anydataType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.anydataType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUALS, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.EQUAL, this.regExpType, this.regExpType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.REF_NOT_EQUAL, this.regExpType, this.regExpType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_THAN, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.LESS_EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_THAN, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.intType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.byteType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.intType, this.byteType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.byteType, this.intType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.floatType, this.floatType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.decimalType, this.decimalType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.stringType, this.stringType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.GREATER_EQUAL, this.nilType, this.nilType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.AND, this.booleanType, this.booleanType, this.booleanType);
        this.defineBinaryOperator(OperatorKind.OR, this.booleanType, this.booleanType, this.booleanType);
        this.defineIntegerUnaryOperations();
        this.defineUnaryOperator(OperatorKind.ADD, this.floatType, this.floatType);
        this.defineUnaryOperator(OperatorKind.ADD, this.decimalType, this.decimalType);
        this.defineUnaryOperator(OperatorKind.SUB, this.floatType, this.floatType);
        this.defineUnaryOperator(OperatorKind.SUB, this.decimalType, this.decimalType);
        this.defineUnaryOperator(OperatorKind.NOT, this.booleanType, this.booleanType);
    }

    private void defineIntegerUnaryOperations() {
        BType[] intTypes;
        for (BType type : intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            this.defineUnaryOperator(OperatorKind.ADD, type, type);
            this.defineUnaryOperator(OperatorKind.SUB, type, this.intType);
            this.defineUnaryOperator(OperatorKind.BITWISE_COMPLEMENT, type, this.intType);
        }
    }

    private BUnionType getNilableBType(BType type) {
        return BUnionType.create(this.typeEnv(), null, type, this.nilType);
    }

    private void defineNilableIntegerUnaryOperations() {
        BUnionType[] nilableIntTypes = new BUnionType[]{this.getNilableBType(this.intType), this.getNilableBType(this.byteType), this.getNilableBType(this.signed32IntType), this.getNilableBType(this.signed16IntType), this.getNilableBType(this.signed8IntType), this.getNilableBType(this.unsigned32IntType), this.getNilableBType(this.unsigned16IntType), this.getNilableBType(this.unsigned8IntType)};
        BUnionType intOptional = nilableIntTypes[0];
        for (BUnionType type : nilableIntTypes) {
            this.defineUnaryOperator(OperatorKind.ADD, type, intOptional);
            this.defineUnaryOperator(OperatorKind.SUB, type, intOptional);
            this.defineUnaryOperator(OperatorKind.BITWISE_COMPLEMENT, type, intOptional);
        }
    }

    private void defineXmlStringConcatanationOperations() {
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlType, this.stringType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlType, this.charStringType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.xmlType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.xmlType, this.xmlType);
        this.defineBinaryOperator(OperatorKind.ADD, this.stringType, this.xmlTextType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.charStringType, this.xmlTextType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlTextType, this.stringType, this.xmlTextType);
        this.defineBinaryOperator(OperatorKind.ADD, this.xmlTextType, this.charStringType, this.xmlTextType);
    }

    private void defineIntegerArithmeticOperations() {
        BType[] intTypes;
        for (BType lhs : intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            for (BType rhs : intTypes) {
                this.defineBinaryOperator(OperatorKind.ADD, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.SUB, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.DIV, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.MUL, lhs, rhs, this.intType);
                this.defineBinaryOperator(OperatorKind.MOD, lhs, rhs, this.intType);
            }
        }
    }

    private void defineIntFloatingPointArithmeticOperations() {
        BType[] intTypes;
        for (BType intType : intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, intType, this.decimalType);
            this.defineBinaryOperator(OperatorKind.MUL, intType, this.decimalType, this.decimalType);
            this.defineBinaryOperator(OperatorKind.MUL, this.floatType, intType, this.floatType);
            this.defineBinaryOperator(OperatorKind.MUL, intType, this.floatType, this.floatType);
            this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, intType, this.decimalType);
            this.defineBinaryOperator(OperatorKind.DIV, this.floatType, intType, this.floatType);
            this.defineBinaryOperator(OperatorKind.MOD, this.decimalType, intType, this.decimalType);
            this.defineBinaryOperator(OperatorKind.MOD, this.floatType, intType, this.floatType);
        }
    }

    private void defineNilableIntFloatingPointArithmeticOperations() {
        BType[] intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        BUnionType nullableFloat = this.getNilableBType(this.floatType);
        BUnionType nullableDecimal = this.getNilableBType(this.decimalType);
        BUnionType[] nilableIntTypes = new BUnionType[8];
        for (int i = 0; i < intTypes.length; ++i) {
            nilableIntTypes[i] = this.getNilableBType(intTypes[i]);
        }
        for (BType bType : intTypes) {
            this.defineBinaryOperator(OperatorKind.MUL, nullableDecimal, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MUL, bType, nullableDecimal, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MUL, nullableFloat, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MUL, bType, nullableFloat, nullableFloat);
            this.defineBinaryOperator(OperatorKind.DIV, nullableDecimal, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.DIV, nullableFloat, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MOD, nullableDecimal, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MOD, nullableFloat, bType, nullableFloat);
        }
        for (BType bType : nilableIntTypes) {
            this.defineBinaryOperator(OperatorKind.MUL, this.floatType, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MUL, bType, this.floatType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MUL, bType, nullableFloat, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MUL, nullableFloat, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MUL, this.decimalType, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MUL, bType, this.decimalType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MUL, bType, nullableDecimal, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MUL, nullableDecimal, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.DIV, this.floatType, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.DIV, nullableFloat, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.DIV, this.decimalType, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.DIV, nullableDecimal, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MOD, this.floatType, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MOD, nullableFloat, bType, nullableFloat);
            this.defineBinaryOperator(OperatorKind.MOD, this.decimalType, bType, nullableDecimal);
            this.defineBinaryOperator(OperatorKind.MOD, nullableDecimal, bType, nullableDecimal);
        }
    }

    private void defineNilableIntegerArithmeticOperations() {
        BType[] intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        BUnionType[] nilableIntTypes = new BUnionType[8];
        for (int i = 0; i < intTypes.length; ++i) {
            nilableIntTypes[i] = this.getNilableBType(intTypes[i]);
        }
        BUnionType intOptional = nilableIntTypes[0];
        for (BUnionType lhs : nilableIntTypes) {
            for (BUnionType rhs : nilableIntTypes) {
                this.defineBinaryOperator(OperatorKind.ADD, lhs, rhs, intOptional);
                this.defineBinaryOperator(OperatorKind.SUB, lhs, rhs, intOptional);
                this.defineBinaryOperator(OperatorKind.DIV, lhs, rhs, intOptional);
                this.defineBinaryOperator(OperatorKind.MUL, lhs, rhs, intOptional);
                this.defineBinaryOperator(OperatorKind.MOD, lhs, rhs, intOptional);
            }
        }
    }

    private void defineIntegerBitwiseAndOperations() {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        for (BType unsigned : unsignedIntTypes) {
            for (BType signed : signedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsigned, signed, unsigned);
            }
        }
        for (int i = 0; i < unsignedIntTypes.length; ++i) {
            for (int j = 0; j < unsignedIntTypes.length; ++j) {
                BType unsignedIntTypeLhs = unsignedIntTypes[i];
                BType unsignedIntTypeRhs = unsignedIntTypes[j];
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedIntTypeLhs, unsignedIntTypeRhs, i <= j ? unsignedIntTypeLhs : unsignedIntTypeRhs);
            }
        }
        for (BType signed : signedIntTypes) {
            for (BType unsigned : unsignedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signed, unsigned, unsigned);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType signedRhs : signedIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedLhs, signedRhs, this.intType);
            }
        }
    }

    private void defineIntegerBitwiseOrOperations(OperatorKind orOpKind) {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        for (BType unsigned : unsignedIntTypes) {
            for (BType signed : signedIntTypes) {
                this.defineBinaryOperator(orOpKind, unsigned, signed, this.intType);
            }
        }
        for (int i = 0; i < unsignedIntTypes.length; ++i) {
            for (int j = 0; j < unsignedIntTypes.length; ++j) {
                BType unsignedIntTypeLhs = unsignedIntTypes[i];
                BType unsignedIntTypeRhs = unsignedIntTypes[j];
                this.defineBinaryOperator(orOpKind, unsignedIntTypeLhs, unsignedIntTypeRhs, i >= j ? unsignedIntTypeLhs : unsignedIntTypeRhs);
            }
        }
        for (BType signed : signedIntTypes) {
            for (BType unsigned : unsignedIntTypes) {
                this.defineBinaryOperator(orOpKind, signed, unsigned, this.intType);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType signedRhs : signedIntTypes) {
                this.defineBinaryOperator(orOpKind, signedLhs, signedRhs, this.intType);
            }
        }
    }

    private void defineNilableIntegerBitwiseAndOperations() {
        int j;
        int i;
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        BUnionType[] unsignedNilableIntTypes = new BUnionType[4];
        BUnionType[] signedNilableIntTypes = new BUnionType[4];
        for (int i2 = 0; i2 < unsignedIntTypes.length; ++i2) {
            unsignedNilableIntTypes[i2] = this.getNilableBType(unsignedIntTypes[i2]);
            signedNilableIntTypes[i2] = this.getNilableBType(signedIntTypes[i2]);
        }
        BUnionType intOptional = signedNilableIntTypes[0];
        for (i = 0; i < unsignedNilableIntTypes.length; ++i) {
            for (j = 0; j < signedNilableIntTypes.length; ++j) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedNilableIntTypes[i], signedNilableIntTypes[j], unsignedNilableIntTypes[i]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedNilableIntTypes[i], signedIntTypes[j], unsignedNilableIntTypes[i]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedIntTypes[i], signedNilableIntTypes[j], unsignedNilableIntTypes[i]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedNilableIntTypes[i], unsignedNilableIntTypes[j], unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedIntTypes[i], unsignedNilableIntTypes[j], unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedNilableIntTypes[i], unsignedIntTypes[j], unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedNilableIntTypes[i], signedNilableIntTypes[j], intOptional);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedIntTypes[i], signedNilableIntTypes[j], intOptional);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, signedNilableIntTypes[i], signedIntTypes[j], intOptional);
            }
        }
        for (i = 0; i < unsignedNilableIntTypes.length; ++i) {
            for (j = 0; j < unsignedNilableIntTypes.length; ++j) {
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedNilableIntTypes[i], unsignedNilableIntTypes[j], i <= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedNilableIntTypes[i], unsignedIntTypes[j], i <= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(OperatorKind.BITWISE_AND, unsignedIntTypes[i], unsignedNilableIntTypes[j], i <= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
            }
        }
    }

    private void defineNilableIntegerBitwiseOrAndXorOperations(OperatorKind opKind) {
        int j;
        int i;
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        BUnionType[] unsignedNilableIntTypes = new BUnionType[4];
        BUnionType[] signedNilableIntTypes = new BUnionType[4];
        for (int i2 = 0; i2 < unsignedIntTypes.length; ++i2) {
            unsignedNilableIntTypes[i2] = this.getNilableBType(unsignedIntTypes[i2]);
            signedNilableIntTypes[i2] = this.getNilableBType(signedIntTypes[i2]);
        }
        BUnionType intOptionalType = signedNilableIntTypes[0];
        for (i = 0; i < signedNilableIntTypes.length; ++i) {
            for (j = 0; j < unsignedNilableIntTypes.length; ++j) {
                this.defineBinaryOperator(opKind, unsignedNilableIntTypes[i], signedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, unsignedNilableIntTypes[i], signedIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, unsignedIntTypes[i], signedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedNilableIntTypes[i], unsignedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedIntTypes[i], unsignedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedNilableIntTypes[i], unsignedIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedNilableIntTypes[i], signedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedIntTypes[i], signedNilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(opKind, signedNilableIntTypes[i], signedIntTypes[j], intOptionalType);
            }
        }
        for (i = 0; i < unsignedNilableIntTypes.length; ++i) {
            for (j = 0; j < unsignedNilableIntTypes.length; ++j) {
                this.defineBinaryOperator(opKind, unsignedNilableIntTypes[i], unsignedNilableIntTypes[j], i >= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(opKind, unsignedNilableIntTypes[i], unsignedIntTypes[j], i >= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
                this.defineBinaryOperator(opKind, unsignedIntTypes[i], unsignedNilableIntTypes[j], i >= j ? unsignedNilableIntTypes[i] : unsignedNilableIntTypes[j]);
            }
        }
    }

    private void defineIntegerLeftShiftOperations() {
        BType[] allIntTypes;
        for (BType lhs : allIntTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            for (BType rhs : allIntTypes) {
                this.defineBinaryOperator(OperatorKind.BITWISE_LEFT_SHIFT, lhs, rhs, this.intType);
            }
        }
    }

    private void defineNilableIntegerLeftShiftOperations() {
        BType[] intTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        BUnionType[] nilableIntTypes = new BUnionType[8];
        for (int i = 0; i < intTypes.length; ++i) {
            nilableIntTypes[i] = this.getNilableBType(intTypes[i]);
        }
        BUnionType intOptionalType = nilableIntTypes[0];
        for (int i = 0; i < intTypes.length; ++i) {
            for (int j = 0; j < intTypes.length; ++j) {
                this.defineBinaryOperator(OperatorKind.BITWISE_LEFT_SHIFT, nilableIntTypes[i], nilableIntTypes[j], intOptionalType);
                this.defineBinaryOperator(OperatorKind.BITWISE_LEFT_SHIFT, nilableIntTypes[i], intTypes[j], intOptionalType);
                this.defineBinaryOperator(OperatorKind.BITWISE_LEFT_SHIFT, intTypes[i], nilableIntTypes[j], intOptionalType);
            }
        }
    }

    private void defineIntegerRightShiftOperations(OperatorKind rightShiftOpKind) {
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        BType[] allIntTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        for (BType unsignedLhs : unsignedIntTypes) {
            for (BType intRhs : allIntTypes) {
                this.defineBinaryOperator(rightShiftOpKind, unsignedLhs, intRhs, unsignedLhs);
            }
        }
        for (BType signedLhs : signedIntTypes) {
            for (BType intRhs : allIntTypes) {
                this.defineBinaryOperator(rightShiftOpKind, signedLhs, intRhs, this.intType);
            }
        }
    }

    private void defineNilableIntegerRightShiftOperations(OperatorKind rightShiftOpKind) {
        int j;
        int i;
        BType[] unsignedIntTypes = new BType[]{this.byteType, this.unsigned8IntType, this.unsigned16IntType, this.unsigned32IntType};
        BType[] signedIntTypes = new BType[]{this.intType, this.signed8IntType, this.signed16IntType, this.signed32IntType};
        BUnionType[] unsignedNilableIntTypes = new BUnionType[4];
        BUnionType[] signedNilableIntTypes = new BUnionType[4];
        for (int i2 = 0; i2 < unsignedIntTypes.length; ++i2) {
            unsignedNilableIntTypes[i2] = this.getNilableBType(unsignedIntTypes[i2]);
            signedNilableIntTypes[i2] = this.getNilableBType(signedIntTypes[i2]);
        }
        BUnionType intOptional = signedNilableIntTypes[0];
        BType[] allIntTypes = new BType[]{this.intType, this.byteType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType};
        BUnionType[] nilableAllIntTypes = new BUnionType[8];
        for (i = 0; i < allIntTypes.length; ++i) {
            nilableAllIntTypes[i] = this.getNilableBType(allIntTypes[i]);
        }
        for (i = 0; i < unsignedNilableIntTypes.length; ++i) {
            for (j = 0; j < nilableAllIntTypes.length; ++j) {
                this.defineBinaryOperator(rightShiftOpKind, unsignedNilableIntTypes[i], nilableAllIntTypes[j], unsignedNilableIntTypes[i]);
                this.defineBinaryOperator(rightShiftOpKind, unsignedIntTypes[i], nilableAllIntTypes[j], unsignedNilableIntTypes[i]);
                this.defineBinaryOperator(rightShiftOpKind, unsignedNilableIntTypes[i], allIntTypes[j], unsignedNilableIntTypes[i]);
            }
        }
        for (i = 0; i < signedNilableIntTypes.length; ++i) {
            for (j = 0; j < nilableAllIntTypes.length; ++j) {
                this.defineBinaryOperator(rightShiftOpKind, signedNilableIntTypes[i], nilableAllIntTypes[j], intOptional);
                this.defineBinaryOperator(rightShiftOpKind, signedNilableIntTypes[i], allIntTypes[j], intOptional);
                this.defineBinaryOperator(rightShiftOpKind, signedIntTypes[i], nilableAllIntTypes[j], intOptional);
            }
        }
    }

    private void defineNilableFloatingPointOperations() {
        OperatorKind[] unaryOperators;
        OperatorKind[] binaryOperators;
        BUnionType floatOptional = this.getNilableBType(this.floatType);
        BUnionType decimalOptional = this.getNilableBType(this.decimalType);
        for (OperatorKind operator : binaryOperators = new OperatorKind[]{OperatorKind.ADD, OperatorKind.SUB, OperatorKind.MUL, OperatorKind.DIV, OperatorKind.MOD}) {
            this.defineBinaryOperator(operator, this.floatType, floatOptional, floatOptional);
            this.defineBinaryOperator(operator, floatOptional, this.floatType, floatOptional);
            this.defineBinaryOperator(operator, floatOptional, floatOptional, floatOptional);
            this.defineBinaryOperator(operator, this.decimalType, decimalOptional, decimalOptional);
            this.defineBinaryOperator(operator, decimalOptional, this.decimalType, decimalOptional);
            this.defineBinaryOperator(operator, decimalOptional, decimalOptional, decimalOptional);
        }
        for (OperatorKind operator : unaryOperators = new OperatorKind[]{OperatorKind.ADD, OperatorKind.SUB, OperatorKind.BITWISE_COMPLEMENT}) {
            this.defineUnaryOperator(operator, floatOptional, floatOptional);
            this.defineUnaryOperator(operator, decimalOptional, decimalOptional);
        }
    }

    public void defineIntRangeOperations() {
        BType[] intTypes;
        for (BType lhs : intTypes = new BType[]{this.byteType, this.intType, this.signed32IntType, this.signed16IntType, this.signed8IntType, this.unsigned32IntType, this.unsigned16IntType, this.unsigned8IntType}) {
            for (BType rhs : intTypes) {
                this.defineBinaryOperator(OperatorKind.CLOSED_RANGE, lhs, rhs, this.intRangeType);
                this.defineBinaryOperator(OperatorKind.HALF_OPEN_RANGE, lhs, rhs, this.intRangeType);
            }
        }
    }

    public void defineBinaryOperator(OperatorKind kind, BType lhsType, BType rhsType, BType retType) {
        List<BType> paramTypes = Lists.of(lhsType, rhsType);
        this.defineOperator(Names.fromString(kind.value()), paramTypes, retType);
    }

    private void defineUnaryOperator(OperatorKind kind, BType type, BType retType) {
        List<BType> paramTypes = Lists.of(type);
        this.defineOperator(Names.fromString(kind.value()), paramTypes, retType);
    }

    private void defineOperator(Name name, List<BType> paramTypes, BType retType) {
        BInvokableType opType = new BInvokableType(this.typeEnv(), paramTypes, retType, null);
        BOperatorSymbol symbol = new BOperatorSymbol(name, this.rootPkgSymbol.pkgID, opType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        BInvokableTypeSymbol typeSymbol = Symbols.createInvokableTypeSymbol(33587228L, 0x8000000000L, this.rootPkgSymbol.pkgID, opType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        typeSymbol.returnType = retType;
        opType.tsymbol = typeSymbol;
        this.rootScope.define(name, symbol);
    }

    private void defineCyclicUnionBasedInternalTypes() {
        this.defineAnydataCyclicTypeAndDependentTypes();
        this.defineJsonCyclicTypeAndDependentTypes();
        this.defineCloneableCyclicTypeAndDependentTypes();
    }

    private void defineCloneableCyclicTypeAndDependentTypes() {
        this.cloneableType = BUnionType.create(this.typeEnv(), null, this.readonlyType, this.xmlType);
        this.addCyclicArrayMapTableOfMapMembers(this.cloneableType);
        this.cloneableType.tsymbol = new BTypeSymbol(12L, 1024L, Names.CLONEABLE, this.rootPkgSymbol.pkgID, this.cloneableType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        this.detailType = new BMapType(this.typeEnv(), 16, this.cloneableType, null);
        this.errorType = new BErrorType(this.typeEnv(), null, this.detailType);
        this.errorType.tsymbol = new BErrorTypeSymbol(294940L, 1L, Names.ERROR, this.rootPkgSymbol.pkgID, this.errorType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        this.errorOrNilType = BUnionType.create(this.typeEnv(), null, this.errorType, this.nilType);
        this.anyOrErrorType = BUnionType.create(this.typeEnv(), null, this.anyType, this.errorType);
        this.mapAllType = new BMapType(this.typeEnv(), 16, this.anyOrErrorType, null);
        this.arrayAllType = new BArrayType(this.typeEnv(), this.anyOrErrorType);
        this.typeDesc.constraint = this.anyOrErrorType;
        this.futureType.constraint = this.anyOrErrorType;
        this.pureType = BUnionType.create(this.typeEnv(), null, this.anydataType, this.errorType);
        this.streamType = new BStreamType(this.typeEnv(), 15, this.pureType, this.nilType, null);
        this.tableType = new BTableType(this.typeEnv(), this.pureType, null);
        this.initializeType(this.streamType, TypeKind.STREAM.typeName(), SymbolOrigin.BUILTIN);
        this.initializeType(this.tableType, TypeKind.TABLE.typeName(), SymbolOrigin.BUILTIN);
    }

    private void addCyclicArrayMapTableOfMapMembers(BUnionType unionType) {
        BArrayType arrayCloneableType = new BArrayType(this.typeEnv(), unionType);
        BMapType mapCloneableType = new BMapType(this.typeEnv(), 16, unionType, null);
        BTableType tableMapCloneableType = new BTableType(this.typeEnv(), mapCloneableType, null);
        unionType.add(arrayCloneableType);
        unionType.add(mapCloneableType);
        unionType.add(tableMapCloneableType);
        unionType.isCyclic = true;
    }

    private void defineJsonCyclicTypeAndDependentTypes() {
        BUnionType jsonInternal = BUnionType.create(this.typeEnv(), null, this.nilType, this.booleanType, this.intType, this.floatType, this.decimalType, this.stringType);
        BArrayType arrayJsonTypeInternal = new BArrayType(this.typeEnv(), jsonInternal);
        BMapType mapJsonTypeInternal = new BMapType(this.typeEnv(), 16, jsonInternal, null);
        jsonInternal.add(arrayJsonTypeInternal);
        jsonInternal.add(mapJsonTypeInternal);
        jsonInternal.isCyclic = true;
        this.jsonType = new BJSONType(this.types.typeCtx(), jsonInternal);
        PackageID pkgID = this.rootPkgSymbol.pkgID;
        Optional<BIntersectionType> immutableType = Types.getImmutableType(this, pkgID, jsonInternal);
        if (immutableType.isPresent()) {
            Types.addImmutableType(this, pkgID, this.jsonType, immutableType.get());
        }
        this.jsonType.tsymbol = new BTypeSymbol(12L, 1L, Names.JSON, pkgID, this.jsonType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        this.arrayJsonType = new BArrayType(this.typeEnv(), this.jsonType);
        this.mapJsonType = new BMapType(this.typeEnv(), 16, this.jsonType, null);
    }

    private void defineAnydataCyclicTypeAndDependentTypes() {
        BUnionType anyDataInternal = BUnionType.create(this.typeEnv(), null, this.nilType, this.booleanType, this.intType, this.floatType, this.decimalType, this.stringType, this.xmlType);
        this.addCyclicArrayMapTableOfMapMembers(anyDataInternal);
        this.anydataType = new BAnydataType(this.types.typeCtx(), anyDataInternal);
        PackageID pkgID = this.rootPkgSymbol.pkgID;
        Optional<BIntersectionType> immutableType = Types.getImmutableType(this, pkgID, anyDataInternal);
        if (immutableType.isPresent()) {
            Types.addImmutableType(this, pkgID, this.anydataType, immutableType.get());
        }
        this.anydataType.tsymbol = new BTypeSymbol(12L, 1L, Names.ANYDATA, pkgID, this.anydataType, this.rootPkgSymbol, this.builtinPos, SymbolOrigin.BUILTIN);
        this.arrayAnydataType = new BArrayType(this.typeEnv(), this.anydataType);
        this.mapAnydataType = new BMapType(this.typeEnv(), 16, this.anydataType, null);
        this.anydataOrReadonly = BUnionType.create(this.typeEnv(), null, this.anydataType, this.readonlyType);
        this.initializeType((BType)this.mapAnydataType, TypeKind.MAP.typeName(), SymbolOrigin.VIRTUAL);
    }

    public Env typeEnv() {
        assert (this.types.typeEnv() != null);
        return this.types.typeEnv();
    }
}

