/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.ballerinalang.model.symbols.AnnotationSymbol;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.AttachPoints;

public class BAnnotationSymbol
extends BTypeSymbol
implements AnnotationSymbol {
    public BType attachedType;
    public Set<AttachPoint> points;
    public int maskedPoints;
    private final List<BAnnotationAttachmentSymbol> annotationAttachments;

    public BAnnotationSymbol(Name name, Name originalName, long flags, Set<AttachPoint> points, PackageID pkgID, BType type, BSymbol owner, Location pos, SymbolOrigin origin) {
        super(2L, flags, name, originalName, pkgID, type, owner, pos, origin);
        this.points = points;
        this.maskedPoints = this.getMaskedPoints(points);
        this.annotationAttachments = new ArrayList<BAnnotationAttachmentSymbol>();
    }

    @Override
    public void addAnnotation(AnnotationAttachmentSymbol symbol) {
        if (symbol == null) {
            return;
        }
        this.annotationAttachments.add((BAnnotationAttachmentSymbol)symbol);
    }

    @Override
    public List<? extends AnnotationAttachmentSymbol> getAnnotations() {
        return this.annotationAttachments;
    }

    @Override
    public String toString() {
        return this.pkgID != null && !this.pkgID.toString().equals(".") ? this.pkgID.toString() + ":" + String.valueOf(this.name) : this.name.toString();
    }

    public String bvmAlias() {
        String pkg = CompilerUtils.getPackageIDStringWithMajorVersion(this.pkgID);
        return !pkg.equals(".") ? pkg + ":" + String.valueOf(this.name) : this.name.toString();
    }

    private int getMaskedPoints(Set<AttachPoint> attachPoints) {
        HashSet<AttachPoint.Point> points = new HashSet();
        if (!attachPoints.isEmpty()) {
            for (AttachPoint attachPoint : attachPoints) {
                if (attachPoint == null) continue;
                points.add(attachPoint.point);
            }
        } else {
            points = EnumSet.noneOf(AttachPoint.Point.class);
        }
        return AttachPoints.asMask(points);
    }
}

