/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.FunctionDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

public class BResourceFunction
extends BAttachedFunction {
    public List<BVarSymbol> pathParams;
    public BVarSymbol restPathParam;
    public Name accessor;
    public List<BResourcePathSegmentSymbol> pathSegmentSymbols;

    public BResourceFunction(Name funcName, BInvokableSymbol symbol, BInvokableType type, Name accessor, List<BVarSymbol> pathParams, BVarSymbol restPathParam, Location pos) {
        super(funcName, symbol, type, pos);
        this.accessor = accessor;
        this.pathParams = pathParams;
        this.restPathParam = restPathParam;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("resource function ").append(this.accessor).append(" ");
        int pathSegmentCount = this.pathSegmentSymbols.size();
        ArrayList<Object> resourcePathStrings = new ArrayList<Object>(pathSegmentCount);
        for (BResourcePathSegmentSymbol pathSym : this.pathSegmentSymbols) {
            if (pathSym.kind == SymbolKind.RESOURCE_PATH_PARAM_SEGMENT) {
                resourcePathStrings.add("[" + String.valueOf(pathSym.type) + "]");
                continue;
            }
            if (pathSym.kind == SymbolKind.RESOURCE_PATH_REST_PARAM_SEGMENT) {
                resourcePathStrings.add("[" + String.valueOf(pathSym.type) + "...]");
                continue;
            }
            resourcePathStrings.add(pathSym.name.value);
        }
        sb.append((String)resourcePathStrings.stream().reduce((a, b) -> a + "/" + b).get());
        List<BType> originalParamTypes = this.type.paramTypes;
        int pathParamCount = this.pathParams.size() + (this.restPathParam == null ? 0 : 1);
        ArrayList<BType> paramTypes = new ArrayList<BType>(originalParamTypes.size() - pathParamCount);
        paramTypes.addAll(originalParamTypes.subList(pathParamCount, originalParamTypes.size()));
        this.type.paramTypes = paramTypes;
        sb.append(this.type.getTypeSignature());
        this.type.paramTypes = originalParamTypes;
        return sb.toString();
    }

    @Override
    public SemType semType() {
        ArrayList<SemType> params = new ArrayList<SemType>();
        params.add(SemTypes.stringConst((String)this.accessor.value));
        for (BResourcePathSegmentSymbol each : this.pathSegmentSymbols) {
            params.add((SemType)Objects.requireNonNullElse(each.type.semType(), PredefinedType.NEVER));
        }
        for (BType param : this.type.paramTypes) {
            params.add((SemType)Objects.requireNonNullElse(param.semType(), PredefinedType.NEVER));
        }
        return this.type.getSemTypeWithParams(params, new FunctionDefinition());
    }
}

