/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import java.util.LinkedHashSet;
import org.ballerinalang.model.Name;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class BAnydataType
extends BUnionType {
    private boolean nullable;
    private static final int INITIAL_CAPACITY = 10;
    private final Context typeCtx;

    private BAnydataType(Context typeCtx, BTypeSymbol tsymbol, Name name, long flags, boolean nullable) {
        super(typeCtx.env, tsymbol, new LinkedHashSet<BType>(10), false);
        this.tag = 11;
        this.setFlags(flags);
        this.name = name;
        this.isCyclic = true;
        this.nullable = nullable;
        this.typeCtx = typeCtx;
    }

    public BAnydataType(Context typeCtx, BUnionType type) {
        super(type.env, type.tsymbol, new LinkedHashSet<BType>(type.memberTypes.size()), Symbols.isFlagOn(type.getFlags(), 32L));
        this.tag = 11;
        this.isCyclic = true;
        this.name = type.name;
        this.setFlags(type.getFlags());
        this.nullable = type.isNullable();
        this.mergeUnionType(type);
        this.typeCtx = typeCtx;
    }

    public static BAnydataType newNilLiftedBAnydataType(BAnydataType type) {
        BAnydataType result = new BAnydataType(type.typeCtx, type);
        result.nullable = false;
        return result;
    }

    public static BAnydataType newImmutableBAnydataType(BAnydataType type, BTypeSymbol typeSymbol, Name name, boolean nullable) {
        return new BAnydataType(type.typeCtx, typeSymbol, name, type.getFlags() | 0x20L, nullable);
    }

    @Override
    public String toString() {
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? this.getKind().typeName() : this.getKind().typeName().concat(" & readonly");
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ANYDATA;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public SemType semType() {
        SemType anydata = Core.createAnydata((Context)this.typeCtx);
        if (!this.nullable) {
            anydata = Core.diff((SemType)anydata, (SemType)PredefinedType.NIL);
        }
        if (Symbols.isFlagOn(this.getFlags(), 32L)) {
            anydata = Core.intersect((SemType)anydata, (SemType)PredefinedType.VAL_READONLY);
        }
        return anydata;
    }
}

