/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.ErrorVariableNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeEntry;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;

public class BLangErrorVariable
extends BLangVariable
implements ErrorVariableNode {
    public BLangSimpleVariable message;
    public BLangVariable cause;
    public BLangSimpleVariable restDetail;
    public List<BLangErrorDetailEntry> detail;
    public BLangInvocation detailExpr;
    public boolean reasonVarPrefixAvailable;
    public BLangLiteral reasonMatchConst;
    public boolean isInMatchStmt;

    public BLangErrorVariable() {
        this.annAttachments = new ArrayList();
        this.detail = new ArrayList<BLangErrorDetailEntry>();
        this.flagSet = EnumSet.noneOf(Flag.class);
    }

    @Override
    public BLangSimpleVariable getMessage() {
        return this.message;
    }

    public List<BLangErrorDetailEntry> getDetail() {
        return this.detail;
    }

    @Override
    public BLangSimpleVariable getRestDetail() {
        return this.restDetail;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.ERROR_VARIABLE;
    }

    @Override
    public String toString() {
        StringJoiner details = new StringJoiner(", ");
        this.detail.forEach(d -> details.add(d.key.toString() + "=" + d.valueBindingPattern.toString()));
        return "error (" + String.valueOf(this.message) + ", " + details.toString() + (String)(this.restDetail != null ? ", ...var " + this.restDetail.name.toString() : "") + ")";
    }

    public static class BLangErrorDetailEntry
    extends BLangNodeEntry
    implements ErrorVariableNode.ErrorDetailEntry {
        public BLangIdentifier key;
        public BLangVariable valueBindingPattern;
        public BSymbol keySymbol;

        public BLangErrorDetailEntry(BLangIdentifier key, BLangVariable valueBindingPattern) {
            this.key = key;
            this.valueBindingPattern = valueBindingPattern;
        }

        @Override
        public BLangIdentifier getKey() {
            return this.key;
        }

        @Override
        public BLangVariable getValue() {
            return this.valueBindingPattern;
        }

        public String toString() {
            return String.valueOf(this.key) + ": " + String.valueOf(this.valueBindingPattern);
        }

        @Override
        public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
            analyzer.visit(this, props);
        }

        @Override
        public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
            return modifier.transform(this, props);
        }
    }
}

