/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.LiteralNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

public class BLangLiteral
extends BLangExpression
implements LiteralNode {
    public Object value;
    public String originalValue;
    public boolean isConstant;
    public boolean isFiniteContext;

    public BLangLiteral() {
    }

    public BLangLiteral(Object value, BType type) {
        this.value = value;
        this.setBType(type);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.LITERAL;
    }

    public String toString() {
        return this.value == null ? this.originalValue : String.valueOf(this.value);
    }
}

