/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.types;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.ObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNodeAnalyzer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeTransformer;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;

public class BLangObjectTypeNode
extends BLangStructureTypeNode
implements ObjectTypeNode {
    public List<BLangFunction> functions;
    public BLangFunction initFunction;

    public BLangObjectTypeNode() {
        this.functions = new ArrayList<BLangFunction>();
    }

    public BLangObjectTypeNode(int includedFieldCount) {
        super(includedFieldCount);
    }

    public List<BLangFunction> getFunctions() {
        return this.functions;
    }

    @Override
    public void addFunction(FunctionNode function) {
        this.functions.add((BLangFunction)function);
    }

    @Override
    public FunctionNode getInitFunction() {
        return this.initFunction;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> void accept(BLangNodeAnalyzer<T> analyzer, T props) {
        analyzer.visit(this, props);
    }

    @Override
    public <T, R> R apply(BLangNodeTransformer<T, R> modifier, T props) {
        return modifier.transform(this, props);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.OBJECT_TYPE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("object { ");
        for (BLangSimpleVariable field : this.fields) {
            sb.append(field).append(";\n");
        }
        for (BLangFunction function : this.functions) {
            sb.append(function).append(";\n");
        }
        return sb.append(" }").toString();
    }
}

