/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.task.exceptions.SchedulingException;
import io.ballerina.stdlib.task.objects.TaskManager;
import io.ballerina.stdlib.task.utils.TaskConstants;
import io.ballerina.stdlib.task.utils.Utils;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Set;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public final class TaskActions {
    private static final int bound = 1000000;
    private static final String value = "1000";
    private static final PrintStream console = System.err;

    private TaskActions() {
    }

    public static Object configureThread(Environment env, long workerCount, long waitingTimeInMillis) {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().initializeScheduler(Utils.createSchedulerProperties(String.valueOf(workerCount), String.valueOf(waitingTimeInMillis)), env);
            return null;
        }
        catch (SchedulingException | IllegalArgumentException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
    }

    public static Object scheduleJob(Environment env, BObject job, long time) {
        Utils.disableQuartzLogs();
        try {
            Integer jobId = SecureRandom.getInstanceStrong().nextInt(1000000);
            JobDataMap jobDataMap = TaskActions.getJobDataMap(job, "LOG_AND_CONTINUE", String.valueOf(jobId));
            TaskActions.getScheduler(env);
            TaskManager.getInstance().scheduleOneTimeJob(jobDataMap, time, jobId);
            return jobId;
        }
        catch (SchedulingException | IllegalArgumentException | NoSuchAlgorithmException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
    }

    public static Object scheduleIntervalJob(Environment env, BObject job, BDecimal interval, long maxCount, Object startTime, Object endTime, BMap<BString, Object> policy) {
        Utils.disableQuartzLogs();
        try {
            int jobId = SecureRandom.getInstanceStrong().nextInt(1000000);
            JobDataMap jobDataMap = TaskActions.getJobDataMap(job, ((BString)policy.get((Object)TaskConstants.ERR_POLICY)).getValue(), String.valueOf(jobId));
            TaskActions.getScheduler(env);
            TaskManager.getInstance().scheduleIntervalJob(jobDataMap, interval.decimalValue().multiply(new BigDecimal(value)).longValue(), maxCount, startTime, endTime, ((BString)policy.get((Object)TaskConstants.WAITING_POLICY)).getValue(), jobId);
            return jobId;
        }
        catch (SchedulingException | IllegalArgumentException | NoSuchAlgorithmException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
    }

    private static Scheduler getScheduler(Environment env) throws SchedulingException, SchedulerException {
        Utils.disableQuartzLogs();
        return TaskManager.getInstance().getScheduler(Utils.createSchedulerProperties("5", "5000"), env);
    }

    private static JobDataMap getJobDataMap(BObject job, String errorPolicy, String jobId) {
        Utils.disableQuartzLogs();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("job", (Object)job);
        jobDataMap.put("errorPolicy", errorPolicy);
        jobDataMap.put("jobId", jobId);
        return jobDataMap;
    }

    public static Object unscheduleJob(Long jobId) {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().unScheduleJob(Math.toIntExact(jobId));
        }
        catch (SchedulingException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object pauseAllJobs() {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().pause();
        }
        catch (SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object resumeAllJobs() {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().resume();
        }
        catch (SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object pauseJob(Long jobId) {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().pauseJob(Math.toIntExact(jobId));
        }
        catch (SchedulingException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static Object resumeJob(Long jobId) {
        Utils.disableQuartzLogs();
        try {
            TaskManager.getInstance().resumeJob(Math.toIntExact(jobId));
        }
        catch (SchedulingException | SchedulerException e) {
            return Utils.createTaskError(e.getMessage());
        }
        return null;
    }

    public static BArray getRunningJobs() {
        try {
            int i = 0;
            Set<Integer> jobIds = TaskManager.getInstance().getAllRunningJobs();
            long[] results = new long[jobIds.size()];
            for (int value : jobIds) {
                results[i] = value;
                ++i;
            }
            return ValueCreator.createArrayValue((long[])results);
        }
        catch (SchedulerException e) {
            Utils.printMessage(e.getMessage(), console);
            return ValueCreator.createArrayValue((long[])new long[0]);
        }
    }

    static {
        Utils.disableQuartzLogs();
    }
}

