/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.task.coordination;

import io.ballerina.stdlib.task.coordination.DatabaseConfig;
import io.ballerina.stdlib.task.coordination.TokenAcquisition;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class HealthCheckScheduler {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final ExecutorService virtualThreadExecutor = Executors.newVirtualThreadPerTaskExecutor();
    public static final String POSTGRESQL_HEALTH_CHECK_QUERY = "INSERT INTO health_check(task_id, group_id, last_heartbeat) VALUES (?, ?, CURRENT_TIMESTAMP) ON CONFLICT (task_id, group_id) DO UPDATE SET last_heartbeat = EXCLUDED.last_heartbeat";
    public static final String MYSQL_HEALTH_CHECK_QUERY = "INSERT INTO health_check(task_id, group_id, last_heartbeat) VALUES (?, ?, CURRENT_TIMESTAMP) ON DUPLICATE KEY UPDATE last_heartbeat = CURRENT_TIMESTAMP";

    private HealthCheckScheduler() {
    }

    public static void startHealthCheckUpdater(DatabaseConfig dbConfig, String tokenId, String groupId, int periodInSeconds) {
        Runnable task = () -> {
            Connection connection;
            try {
                String jdbcUrl = TokenAcquisition.getJdbcUrl(dbConfig);
                connection = DriverManager.getConnection(jdbcUrl, dbConfig.user(), dbConfig.password());
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to rollback transaction", e);
            }
            try {
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement("mysql".equals(dbConfig.dbType()) ? MYSQL_HEALTH_CHECK_QUERY : POSTGRESQL_HEALTH_CHECK_QUERY);
                stmt.setString(1, tokenId);
                stmt.setString(2, groupId);
                stmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException rollbackException) {
                    throw new RuntimeException("Failed to rollback transaction", rollbackException);
                }
            }
            finally {
                HealthCheckScheduler.closeConnection(connection);
            }
        };
        scheduler.scheduleAtFixedRate(() -> virtualThreadExecutor.submit(task), 0L, periodInSeconds, TimeUnit.SECONDS);
    }

    private static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void shutdown() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

