/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.codeaction.providers.kubernetes;

import io.ballerina.c2c.tooling.codeaction.providers.kubernetes.ProbeBasedDiagnosticAction;
import io.ballerina.c2c.tooling.toml.CommonUtil;
import io.ballerina.c2c.tooling.toml.Probe;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractInvalidPortCodeAction
extends ProbeBasedDiagnosticAction {
    protected List<CodeAction> handleInvalidPort(Diagnostic diagnostic, CodeActionContext ctx, Probe probe) {
        Path balFilePath;
        ArrayList<CodeAction> codeActionList = new ArrayList<CodeAction>();
        String tomlPath = probe.getPath().getValue();
        int tomlPort = probe.getPort().getValue();
        String resourcePath = "readyz";
        Object servicePath = "/probes";
        if (tomlPath != null && !tomlPath.equals("")) {
            String trimmedResourcePath = TomlSyntaxTreeUtil.trimResourcePath(tomlPath);
            String[] split = trimmedResourcePath.split("/");
            resourcePath = split[split.length - 1];
            servicePath = "/" + String.join((CharSequence)"/", Arrays.copyOf(split, split.length - 1));
        }
        if (Files.exists(balFilePath = ctx.workspace().projectRoot(ctx.filePath()).resolve("probe.bal"), new LinkOption[0])) {
            Position position;
            String content;
            SyntaxTree syntaxTree = (SyntaxTree)ctx.workspace().syntaxTree(balFilePath).orElseThrow();
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            NodeList<ModuleMemberDeclarationNode> members = modulePartNode.members();
            if (modulePartNode.members().isEmpty()) {
                content = this.getProbeServiceWithImportString(tomlPort, (String)servicePath, resourcePath);
                position = new Position();
            } else {
                ModuleMemberDeclarationNode lastTopLevelNode = members.get(members.size() - 1);
                position = new Position(lastTopLevelNode.lineRange().endLine().line() + 1, 0);
                content = this.getProbeServiceString(tomlPort, (String)servicePath, resourcePath);
            }
            List<TextEdit> edits = Collections.singletonList(new TextEdit(new Range(position, position), content));
            CodeAction action = new CodeAction("Add to Probe file");
            action.setKind("quickfix");
            action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(balFilePath.toUri().toString(), null), edits)))));
            ArrayList<Diagnostic> cursorDiagnostics = new ArrayList<Diagnostic>();
            cursorDiagnostics.add(diagnostic);
            action.setDiagnostics(cursorDiagnostics);
            codeActionList.add(action);
        } else {
            String content = this.getProbeServiceWithImportString(tomlPort, (String)servicePath, resourcePath);
            codeActionList.add(this.createFile("Create Probe file", balFilePath.toUri().toString(), content, diagnostic));
        }
        return codeActionList;
    }

    private String getProbeServiceWithImportString(int port, String servicePath, String resourcePath) {
        return String.format("import ballerina/http;%s%s", CommonUtil.LINE_SEPARATOR, this.getProbeServiceString(port, servicePath, resourcePath));
    }

    private String getProbeServiceString(int port, String servicePath, String resourcePath) {
        return String.format("%sservice http:Service %s on new http:Listener(%d) {%s    resource function get %s() returns boolean {%s        return true;%s    }%s}%s", CommonUtil.LINE_SEPARATOR, servicePath, port, CommonUtil.LINE_SEPARATOR, resourcePath, CommonUtil.LINE_SEPARATOR, CommonUtil.LINE_SEPARATOR, CommonUtil.LINE_SEPARATOR, CommonUtil.LINE_SEPARATOR);
    }

    private CodeAction createFile(String title, String docURI, String content, Diagnostic diagnostic) {
        ArrayList<Either> actionsToTake = new ArrayList<Either>(2);
        actionsToTake.add(Either.forRight((Object)new CreateFile(docURI, new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)))));
        VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(docURI, Integer.valueOf(0));
        TextEdit te = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), content);
        actionsToTake.add(Either.forLeft((Object)new TextDocumentEdit(identifier, Collections.singletonList(te))));
        WorkspaceEdit createAndAddContentEdit = new WorkspaceEdit(actionsToTake);
        CodeAction codeAction = new CodeAction(title);
        codeAction.setEdit(createAndAddContentEdit);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        return codeAction;
    }
}

