/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.codeaction.providers.kubernetes;

import io.ballerina.c2c.tooling.codeaction.providers.kubernetes.ProbeBasedDiagnosticAction;
import io.ballerina.c2c.tooling.toml.Probe;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ProjectServiceInfo;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractInvalidServiceCodeAction
extends ProbeBasedDiagnosticAction {
    public List<CodeAction> fixServicePath(Diagnostic diagnostic, CodeActionContext ctx, Probe probe) {
        Optional project = ctx.workspace().project(ctx.filePath());
        ProjectServiceInfo projectServiceInfo = new ProjectServiceInfo((Project)project.orElseThrow());
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        ArrayList<CodeAction> codeActionList = new ArrayList<CodeAction>();
        block0: for (ServiceInfo service : serviceList) {
            for (ListenerInfo listener : service.getListeners()) {
                int port = listener.getPort();
                if (probe.getPort().getValue() != port) continue;
                String servicePath = "/" + TomlSyntaxTreeUtil.trimResourcePath(service.getServicePath());
                Node node = probe.getPath().getNode();
                Position startingPos = new Position(node.lineRange().startLine().line(), node.lineRange().startLine().offset());
                Position endingPos = new Position(node.lineRange().endLine().line(), node.lineRange().endLine().offset());
                CodeAction action = new CodeAction();
                action.setKind("quickfix");
                TextEdit removeContent = new TextEdit(new Range(startingPos, endingPos), "");
                TextEdit addContent = new TextEdit(new Range(startingPos, startingPos), servicePath);
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                edits.add(removeContent);
                edits.add(addContent);
                action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(ctx.fileUri(), null), edits)))));
                action.setTitle("Modify service path");
                ArrayList<Diagnostic> cursorDiagnostics = new ArrayList<Diagnostic>();
                cursorDiagnostics.add(diagnostic);
                action.setDiagnostics(cursorDiagnostics);
                codeActionList.add(action);
                continue block0;
            }
        }
        return codeActionList;
    }
}

