/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractLexer;
import io.ballerina.compiler.internal.parser.ParserMode;
import io.ballerina.compiler.internal.parser.tree.STAbstractNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayList;

public class RegExpLexer
extends AbstractLexer {
    public RegExpLexer(CharReader charReader) {
        super(charReader, ParserMode.RE_DISJUNCTION);
    }

    @Override
    public STToken nextToken() {
        STToken token;
        switch (this.mode) {
            case RE_DISJUNCTION: 
            case RE_CHAR_CLASS: {
                token = this.readTokenInReDisjunction();
                break;
            }
            case RE_UNICODE_PROP_ESCAPE: {
                token = this.readTokenInReUnicodePropertyEscape();
                break;
            }
            case RE_UNICODE_PROPERTY_VALUE: {
                token = this.readTokenInReUnicodePropertyValue();
                break;
            }
            case INTERPOLATION: {
                token = this.readTokenInInterpolation();
                break;
            }
            case RE_QUOTE_ESCAPE: {
                token = this.readTokenInReDisjunction();
                this.endMode();
                break;
            }
            default: {
                token = null;
            }
        }
        return this.cloneWithDiagnostics(token);
    }

    private STToken readTokenInReDisjunction() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        if (nextChar == 124) {
            this.reader.advance();
            return this.getRegExpSyntaxToken(SyntaxKind.PIPE_TOKEN);
        }
        this.reader.advance();
        return switch (nextChar) {
            case 94 -> this.getRegExpSyntaxToken(SyntaxKind.BITWISE_XOR_TOKEN);
            case 36 -> {
                if (this.mode != ParserMode.RE_CHAR_CLASS && this.peek() == 123) {
                    this.startMode(ParserMode.INTERPOLATION);
                    this.reader.advance();
                    yield this.getRegExpSyntaxToken(SyntaxKind.INTERPOLATION_START_TOKEN);
                }
                yield this.getRegExpSyntaxToken(SyntaxKind.DOLLAR_TOKEN);
            }
            case 46 -> this.getRegExpSyntaxToken(SyntaxKind.DOT_TOKEN);
            case 42 -> this.getRegExpSyntaxToken(SyntaxKind.ASTERISK_TOKEN);
            case 43 -> this.getRegExpSyntaxToken(SyntaxKind.PLUS_TOKEN);
            case 63 -> this.getRegExpSyntaxToken(SyntaxKind.QUESTION_MARK_TOKEN);
            case 92 -> this.processReEscape();
            case 91 -> {
                if (this.mode != ParserMode.RE_QUOTE_ESCAPE) {
                    this.startMode(ParserMode.RE_CHAR_CLASS);
                }
                yield this.getRegExpSyntaxToken(SyntaxKind.OPEN_BRACKET_TOKEN);
            }
            case 93 -> {
                if (this.mode == ParserMode.RE_CHAR_CLASS) {
                    this.endMode();
                }
                yield this.getRegExpSyntaxToken(SyntaxKind.CLOSE_BRACKET_TOKEN);
            }
            case 123 -> this.getRegExpSyntaxToken(SyntaxKind.OPEN_BRACE_TOKEN);
            case 125 -> this.getRegExpSyntaxToken(SyntaxKind.CLOSE_BRACE_TOKEN);
            case 40 -> this.getRegExpSyntaxToken(SyntaxKind.OPEN_PAREN_TOKEN);
            case 41 -> this.getRegExpSyntaxToken(SyntaxKind.CLOSE_PAREN_TOKEN);
            case 44 -> this.getRegExpSyntaxToken(SyntaxKind.COMMA_TOKEN);
            default -> RegExpLexer.isDigit(nextChar) ? this.getRegExpText(SyntaxKind.DIGIT) : this.getRegExpText(SyntaxKind.RE_LITERAL_CHAR);
        };
    }

    private STToken processReEscape() {
        int nextChar = this.peek();
        switch (nextChar) {
            case 117: {
                if (this.reader.peek(1) != '{') break;
                this.processNumericEscapeWithoutBackslash();
                return this.getRegExpText(SyntaxKind.RE_NUMERIC_ESCAPE);
            }
            case 110: 
            case 114: 
            case 116: {
                this.reader.advance();
                return this.getRegExpText(SyntaxKind.RE_CONTROL_ESCAPE);
            }
            case 80: 
            case 112: {
                if (this.reader.peek(1) != '{') break;
                this.startMode(ParserMode.RE_UNICODE_PROP_ESCAPE);
                break;
            }
            case 91: {
                this.startMode(ParserMode.RE_QUOTE_ESCAPE);
                break;
            }
        }
        return this.getRegExpText(SyntaxKind.BACK_SLASH_TOKEN);
    }

    private STToken readTokenInReUnicodePropertyEscape() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        switch (nextChar) {
            case 80: 
            case 112: {
                if (this.reader.peek(1) != '{') break;
                this.reader.advance();
                return this.getRegExpText(SyntaxKind.RE_PROPERTY);
            }
            case 123: {
                this.reader.advance();
                return this.getRegExpSyntaxToken(SyntaxKind.OPEN_BRACE_TOKEN);
            }
            case 115: {
                if (this.reader.peek(1) != 'c' || this.reader.peek(2) != '=') break;
                this.reader.advance(3);
                this.startMode(ParserMode.RE_UNICODE_PROPERTY_VALUE);
                return this.getRegExpText(SyntaxKind.RE_UNICODE_SCRIPT_START);
            }
            case 103: {
                if (this.reader.peek(1) != 'c' || this.reader.peek(2) != '=') break;
                this.reader.advance(3);
                return this.getRegExpText(SyntaxKind.RE_UNICODE_GENERAL_CATEGORY_START);
            }
            case 125: {
                this.reader.advance();
                this.endMode();
                return this.getRegExpSyntaxToken(SyntaxKind.CLOSE_BRACE_TOKEN);
            }
        }
        return this.processReUnicodeGeneralCategoryAbbr();
    }

    private STToken processReUnicodeGeneralCategoryAbbr() {
        switch (this.peek()) {
            case 76: {
                this.reader.advance();
                this.processAbbrWithLetter();
                break;
            }
            case 77: {
                this.reader.advance();
                this.processAbbrWithMark();
                break;
            }
            case 78: {
                this.reader.advance();
                this.processAbbrWithNumber();
                break;
            }
            case 83: {
                this.reader.advance();
                this.processAbbrWithSymbol();
                break;
            }
            case 80: {
                this.reader.advance();
                this.processAbbrWithPunctuation();
                break;
            }
            case 90: {
                this.reader.advance();
                this.processAbbrWithSeparator();
                break;
            }
            case 67: {
                this.reader.advance();
                this.processAbbrWithOther();
                break;
            }
        }
        if (!this.isEndOfUnicodePropertyEscape()) {
            while (!this.isEndOfUnicodePropertyEscape()) {
                this.reader.advance();
            }
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_TOKEN_IN_REG_EXP, new Object[0]);
        }
        return this.getRegExpText(SyntaxKind.RE_UNICODE_GENERAL_CATEGORY_NAME);
    }

    private void processAbbrWithLetter() {
        switch (this.peek()) {
            case 108: 
            case 109: 
            case 111: 
            case 116: 
            case 117: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithMark() {
        switch (this.peek()) {
            case 99: 
            case 101: 
            case 110: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithNumber() {
        switch (this.peek()) {
            case 100: 
            case 108: 
            case 111: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithSymbol() {
        switch (this.peek()) {
            case 99: 
            case 107: 
            case 109: 
            case 111: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithPunctuation() {
        switch (this.peek()) {
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 111: 
            case 115: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithSeparator() {
        switch (this.peek()) {
            case 108: 
            case 112: 
            case 115: {
                this.reader.advance();
                return;
            }
        }
    }

    private void processAbbrWithOther() {
        switch (this.peek()) {
            case 99: 
            case 102: 
            case 110: 
            case 111: {
                this.reader.advance();
                return;
            }
        }
    }

    private STToken readTokenInReUnicodePropertyValue() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        boolean invalidTokenFound = false;
        if (!this.isReUnicodePropertyValueChar(this.peek())) {
            this.reader.advance();
            invalidTokenFound = true;
        }
        while (!this.isEndOfUnicodePropertyEscape()) {
            if (!invalidTokenFound && !this.isReUnicodePropertyValueChar(this.peek())) {
                invalidTokenFound = true;
            }
            this.reader.advance();
        }
        this.endMode();
        if (invalidTokenFound) {
            this.reportLexerError(DiagnosticErrorCode.ERROR_INVALID_TOKEN_IN_REG_EXP, new Object[0]);
        }
        return this.getRegExpText(SyntaxKind.RE_UNICODE_PROPERTY_VALUE);
    }

    private boolean isEndOfUnicodePropertyEscape() {
        return this.peek() == 125 || this.reader.isEOF();
    }

    private boolean isReUnicodePropertyValueChar(int nextChar) {
        return RegExpLexer.isDigit(nextChar) || this.isAsciiLetter(nextChar) || nextChar == 95;
    }

    private boolean isAsciiLetter(int nextChar) {
        return 65 <= nextChar && nextChar <= 90 || 97 <= nextChar && nextChar <= 122;
    }

    private STToken readTokenInInterpolation() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpSyntaxToken(SyntaxKind.EOF_TOKEN);
        }
        int nextToken = this.peek();
        if (nextToken == 125) {
            this.endMode();
            this.reader.advance();
            return this.getRegExpCloseBraceTokenWithoutTrailingWS();
        }
        this.endMode();
        return this.nextToken();
    }

    private STToken getRegExpSyntaxToken(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STAbstractNodeFactory.createEmptyNodeList();
        return STAbstractNodeFactory.createToken(kind, leadingTrivia, trailingTrivia);
    }

    private STToken getRegExpText(SyntaxKind kind) {
        STNode leadingTrivia = this.getLeadingTrivia();
        String lexeme = this.getLexeme();
        STNode trailingTrivia = STAbstractNodeFactory.createEmptyNodeList();
        return STAbstractNodeFactory.createLiteralValueToken(kind, lexeme, leadingTrivia, trailingTrivia);
    }

    private STToken getRegExpCloseBraceTokenWithoutTrailingWS() {
        STNode leadingTrivia = this.getLeadingTrivia();
        STNode trailingTrivia = STAbstractNodeFactory.createNodeList(new ArrayList<STNode>(0));
        return STAbstractNodeFactory.createToken(SyntaxKind.CLOSE_BRACE_TOKEN, leadingTrivia, trailingTrivia);
    }

    private int peek() {
        return this.reader.peek();
    }

    private String getLexeme() {
        return this.reader.getMarkedChars();
    }

    protected static boolean isReSimpleCharClassCode(int c) {
        return switch (c) {
            case 68, 83, 87, 100, 115, 119 -> true;
            default -> false;
        };
    }

    protected static boolean isReCharSetLiteralChar(int c) {
        return switch (c) {
            case 45, 92, 93 -> false;
            default -> true;
        };
    }

    protected static boolean isReFlag(int c) {
        return switch (c) {
            case 105, 109, 115, 120 -> true;
            default -> false;
        };
    }
}

