/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.parser.AbstractParser;
import io.ballerina.compiler.internal.parser.AbstractParserErrorHandler;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.SyntaxErrors;
import io.ballerina.compiler.internal.parser.XMLParserErrorHandler;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayList;
import java.util.Queue;

public class XMLParser
extends AbstractParser {
    private final Queue<STNode> intepolationExprs;

    protected XMLParser(AbstractTokenReader tokenReader, Queue<STNode> intepolationExprs) {
        super(tokenReader, new XMLParserErrorHandler(tokenReader));
        this.intepolationExprs = intepolationExprs;
    }

    @Override
    public STNode parse() {
        return this.parseXMLContent(false);
    }

    private STNode parseXMLContent(boolean isInXMLElement) {
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfXMLContent(nextToken.kind, isInXMLElement)) {
            STNode contentItem = this.parseXMLContentItem();
            items.add(contentItem);
            nextToken = this.peek();
        }
        return STNodeFactory.createNodeList(items);
    }

    private boolean isEndOfXMLContent(SyntaxKind kind, boolean isInXMLElement) {
        return switch (kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN -> true;
            case SyntaxKind.LT_TOKEN -> {
                STToken nextNextToken = this.getNextNextToken();
                if (isInXMLElement && (nextNextToken.kind == SyntaxKind.SLASH_TOKEN || nextNextToken.kind == SyntaxKind.LT_TOKEN)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private STNode parseXMLContentItem() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.LT_TOKEN -> this.parseXMLElement();
            case SyntaxKind.XML_COMMENT_START_TOKEN -> this.parseXMLComment();
            case SyntaxKind.XML_PI_START_TOKEN -> this.parseXMLPI();
            case SyntaxKind.INTERPOLATION_START_TOKEN -> this.parseInterpolation();
            case SyntaxKind.XML_CDATA_START_TOKEN -> this.parseXMLCdataSection();
            default -> this.parseXMLText();
        };
    }

    private STNode parseInterpolation() {
        this.consume();
        this.consume();
        return this.intepolationExprs.remove();
    }

    private STNode parseXMLElement() {
        STNode startTag = this.parseXMLElementStartOrEmptyTag();
        if (startTag.kind == SyntaxKind.XML_EMPTY_ELEMENT) {
            return startTag;
        }
        STNode content = this.parseXMLContent(true);
        STNode endTag = this.parseXMLElementEndTag();
        return STNodeFactory.createXMLElementNode(startTag, content, endTag);
    }

    private STNode parseXMLElementStartOrEmptyTag() {
        this.startContext(ParserRuleContext.XML_START_OR_EMPTY_TAG);
        STNode tagOpen = this.parseLTToken();
        STNode name = this.parseXMLNCName();
        this.startContext(ParserRuleContext.XML_ATTRIBUTES);
        ArrayList<STNode> attributes = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfXMLAttributes(nextToken.kind)) {
            STNode attribute = this.parseXMLAttribute();
            if (attribute.kind == SyntaxKind.INTERPOLATION) {
                if (attributes.isEmpty()) {
                    name = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(name, attribute, (DiagnosticCode)DiagnosticErrorCode.ERROR_INTERPOLATION_IS_NOT_ALLOWED_WITHIN_ELEMENT_TAGS, new Object[0]);
                } else {
                    this.updateLastNodeInListWithInvalidNode(attributes, attribute, DiagnosticErrorCode.ERROR_INTERPOLATION_IS_NOT_ALLOWED_WITHIN_ELEMENT_TAGS, new Object[0]);
                }
            } else {
                attributes.add(attribute);
            }
            nextToken = this.peek();
        }
        this.endContext();
        STNode xmlAttributes = STNodeFactory.createNodeList(attributes);
        return this.parseXMLElementTagEnd(tagOpen, name, xmlAttributes);
    }

    private STNode parseXMLElementTagEnd(STNode tagOpen, STNode name, STNode attributes) {
        STToken nextToken = this.peek();
        return this.parseXMLElementTagEnd(nextToken.kind, tagOpen, name, attributes);
    }

    private STNode parseXMLElementTagEnd(SyntaxKind nextTokenKind, STNode tagOpen, STNode name, STNode attributes) {
        switch (nextTokenKind) {
            case SLASH_TOKEN: {
                STNode slash = this.parseSlashToken();
                STNode tagClose = this.parseGTToken();
                this.endContext();
                return STNodeFactory.createXMLEmptyElementNode(tagOpen, name, attributes, slash, tagClose);
            }
            case GT_TOKEN: {
                STNode tagClose = this.parseGTToken();
                this.endContext();
                return STNodeFactory.createXMLStartTagNode(tagOpen, name, attributes, tagClose);
            }
        }
        STToken token = this.peek();
        AbstractParserErrorHandler.Solution solution = this.recover(token, ParserRuleContext.XML_START_OR_EMPTY_TAG_END);
        return this.parseXMLElementTagEnd(solution.tokenKind, tagOpen, name, attributes);
    }

    protected STNode parseSlashToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SLASH_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.SLASH);
        return this.parseSlashToken();
    }

    private STNode parseXMLElementEndTag() {
        this.startContext(ParserRuleContext.XML_END_TAG);
        STNode tagOpen = this.parseLTToken();
        STNode slash = this.parseSlashToken();
        STNode name = this.parseXMLNCName();
        STNode tagClose = this.parseGTToken();
        this.endContext();
        return STNodeFactory.createXMLEndTagNode(tagOpen, slash, name, tagClose);
    }

    private STNode parseLTToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.LT_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.LT_TOKEN);
        return this.parseLTToken();
    }

    private STNode parseGTToken() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.GT_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.GT_TOKEN);
        return this.parseGTToken();
    }

    private STNode parseXMLNCName() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            return this.parseQualifiedIdentifier(this.consume());
        }
        if (token.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            STNode interpolation = this.parseInterpolation();
            STNode xmlNCName = this.parseXMLNCName();
            return SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(xmlNCName, interpolation, (DiagnosticCode)DiagnosticErrorCode.ERROR_INTERPOLATION_IS_NOT_ALLOWED_FOR_XML_TAG_NAMES, new Object[0]);
        }
        this.recover(token, ParserRuleContext.XML_NAME);
        return this.parseXMLNCName();
    }

    protected STNode parseQualifiedIdentifier(STNode identifier) {
        STToken nextToken = this.peek(1);
        if (nextToken.kind != SyntaxKind.COLON_TOKEN) {
            return STNodeFactory.createXMLSimpleNameNode(identifier);
        }
        STToken nextNextToken = this.peek(2);
        if (nextNextToken.kind == SyntaxKind.IDENTIFIER_TOKEN) {
            STToken colon = this.consume();
            STNode varOrFuncName = STNodeFactory.createXMLSimpleNameNode(this.consume());
            identifier = STNodeFactory.createXMLSimpleNameNode(identifier);
            return STNodeFactory.createXMLQualifiedNameNode(identifier, colon, varOrFuncName);
        }
        this.addInvalidTokenToNextToken(this.errorHandler.consumeInvalidToken());
        return this.parseQualifiedIdentifier(identifier);
    }

    private boolean isEndOfXMLAttributes(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.XML_COMMENT_START_TOKEN, SyntaxKind.XML_PI_START_TOKEN, SyntaxKind.XML_CDATA_START_TOKEN, SyntaxKind.SLASH_TOKEN, SyntaxKind.GT_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseXMLAttribute() {
        if (this.peek().kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
            return this.parseInterpolation();
        }
        STNode attributeName = this.parseXMLNCName();
        STNode equalToken = this.parseAssignOp();
        STNode value = this.parseAttributeValue();
        return STNodeFactory.createXMLAttributeNode(attributeName, equalToken, value);
    }

    private STNode parseAssignOp() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUAL_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ASSIGN_OP);
        return this.parseAssignOp();
    }

    private STNode parseAttributeValue() {
        STNode startQuote = this.parseStartQuote(ParserRuleContext.XML_QUOTE_START);
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfXMLAttributeValue(nextToken.kind)) {
            STNode contentItem = this.parseXMLCharacterSet();
            items.add(contentItem);
            nextToken = this.peek();
        }
        STNode value = STNodeFactory.createNodeList(items);
        STNode endQuote = this.parseStartQuote(ParserRuleContext.XML_QUOTE_END);
        return STNodeFactory.createXMLAttributeValue(startQuote, value, endQuote);
    }

    private STNode parseStartQuote(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN || token.kind == SyntaxKind.SINGLE_QUOTE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx);
        return this.parseStartQuote(ctx);
    }

    private boolean isEndOfXMLAttributeValue(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.GT_TOKEN, SyntaxKind.DOUBLE_QUOTE_TOKEN, SyntaxKind.SINGLE_QUOTE_TOKEN, SyntaxKind.IDENTIFIER_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseXMLText() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.INTERPOLATION_START_TOKEN -> null;
            default -> {
                STNode content = this.parseCharData();
                yield STNodeFactory.createXMLTextNode(content);
            }
        };
    }

    private STNode parseCharData() {
        STToken token = this.consume();
        if (token.kind != SyntaxKind.XML_TEXT_CONTENT) {
            return STNodeFactory.createLiteralValueToken(SyntaxKind.XML_TEXT_CONTENT, token.text(), token.leadingMinutiae(), token.trailingMinutiae(), token.diagnostics());
        }
        return token;
    }

    private STNode parseXMLComment() {
        STNode commentStart = this.parseXMLCommentStart();
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfXMLComment(nextToken.kind)) {
            STNode contentItem = this.parseXMLCharacterSet();
            items.add(contentItem);
            nextToken = this.peek();
        }
        STNode content = STNodeFactory.createNodeList(items);
        STNode commentEnd = this.parseXMLCommentEnd();
        return STNodeFactory.createXMLComment(commentStart, content, commentEnd);
    }

    private STNode parseXMLCommentStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_COMMENT_START_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_COMMENT_START);
        return this.parseXMLCommentStart();
    }

    private STNode parseXMLCommentEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_COMMENT_END_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_COMMENT_END);
        return this.parseXMLCommentEnd();
    }

    private boolean isEndOfXMLComment(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.GT_TOKEN, SyntaxKind.XML_COMMENT_END_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseXMLCdataSection() {
        STToken cdataStart = this.consume();
        ArrayList<STNode> items = new ArrayList<STNode>();
        STToken nextToken = this.peek();
        while (!this.isEndOfXMLCdata(nextToken.kind)) {
            STNode contentItem = this.parseXMLCharacterSet();
            items.add(contentItem);
            nextToken = this.peek();
        }
        STNode content = STNodeFactory.createNodeList(items);
        STNode cdataEnd = this.parseXMLCdataEnd();
        return STNodeFactory.createXMLCDATANode(cdataStart, content, cdataEnd);
    }

    private boolean isEndOfXMLCdata(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.XML_CDATA_END_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseXMLCdataEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_CDATA_END_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_CDATA_END);
        return this.parseXMLCdataEnd();
    }

    private STNode parseXMLPI() {
        this.startContext(ParserRuleContext.XML_PI);
        STNode piStart = this.parseXMLPIStart();
        STNode target = this.parseXMLNCName();
        STToken nextToken = this.peek();
        ArrayList<STNode> items = new ArrayList<STNode>();
        while (!this.isEndOfXMLPI(nextToken.kind)) {
            STNode contentItem = this.parseXMLCharacterSet();
            items.add(contentItem);
            nextToken = this.peek();
        }
        STNode data = STNodeFactory.createNodeList(items);
        STNode piEnd = this.parseXMLPIEnd();
        this.endContext();
        return STNodeFactory.createXMLProcessingInstruction(piStart, target, data, piEnd);
    }

    private STNode parseXMLPIStart() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_PI_START_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_PI_START);
        return this.parseXMLPIStart();
    }

    private STNode parseXMLPIEnd() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.XML_PI_END_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.XML_PI_END);
        return this.parseXMLPIEnd();
    }

    private boolean isEndOfXMLPI(SyntaxKind nextTokenKind) {
        return switch (nextTokenKind) {
            case SyntaxKind.EOF_TOKEN, SyntaxKind.BACKTICK_TOKEN, SyntaxKind.LT_TOKEN, SyntaxKind.GT_TOKEN, SyntaxKind.XML_PI_END_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseXMLCharacterSet() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.XML_TEXT_CONTENT -> this.consume();
            case SyntaxKind.INTERPOLATION_START_TOKEN -> this.parseInterpolation();
            default -> throw new IllegalStateException();
        };
    }

    private AbstractParserErrorHandler.Solution recover(STToken token, ParserRuleContext currentCtx) {
        return this.recover(token, currentCtx, false);
    }
}

