/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STConditionalExpressionNode
extends STExpressionNode {
    public final STNode lhsExpression;
    public final STNode questionMarkToken;
    public final STNode middleExpression;
    public final STNode colonToken;
    public final STNode endExpression;

    STConditionalExpressionNode(STNode lhsExpression, STNode questionMarkToken, STNode middleExpression, STNode colonToken, STNode endExpression) {
        this(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression, Collections.emptyList());
    }

    STConditionalExpressionNode(STNode lhsExpression, STNode questionMarkToken, STNode middleExpression, STNode colonToken, STNode endExpression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.CONDITIONAL_EXPRESSION, diagnostics);
        this.lhsExpression = lhsExpression;
        this.questionMarkToken = questionMarkToken;
        this.middleExpression = middleExpression;
        this.colonToken = colonToken;
        this.endExpression = endExpression;
        this.addChildren(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STConditionalExpressionNode(this.lhsExpression, this.questionMarkToken, this.middleExpression, this.colonToken, this.endExpression, diagnostics);
    }

    public STConditionalExpressionNode modify(STNode lhsExpression, STNode questionMarkToken, STNode middleExpression, STNode colonToken, STNode endExpression) {
        if (this.checkForReferenceEquality(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression)) {
            return this;
        }
        return new STConditionalExpressionNode(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ConditionalExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

