/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMarkdownDocumentationNode
extends STDocumentationNode {
    public final STNode documentationLines;

    STMarkdownDocumentationNode(STNode documentationLines) {
        this(documentationLines, Collections.emptyList());
    }

    STMarkdownDocumentationNode(STNode documentationLines, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MARKDOWN_DOCUMENTATION, diagnostics);
        this.documentationLines = documentationLines;
        this.addChildren(documentationLines);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMarkdownDocumentationNode(this.documentationLines, diagnostics);
    }

    public STMarkdownDocumentationNode modify(STNode documentationLines) {
        if (this.checkForReferenceEquality(documentationLines)) {
            return this;
        }
        return new STMarkdownDocumentationNode(documentationLines, (Collection<STNodeDiagnostic>)this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MarkdownDocumentationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

