/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STFunctionArgumentNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNamedArgumentNode
extends STFunctionArgumentNode {
    public final STNode argumentName;
    public final STNode equalsToken;
    public final STNode expression;

    STNamedArgumentNode(STNode argumentName, STNode equalsToken, STNode expression) {
        this(argumentName, equalsToken, expression, Collections.emptyList());
    }

    STNamedArgumentNode(STNode argumentName, STNode equalsToken, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NAMED_ARG, diagnostics);
        this.argumentName = argumentName;
        this.equalsToken = equalsToken;
        this.expression = expression;
        this.addChildren(argumentName, equalsToken, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNamedArgumentNode(this.argumentName, this.equalsToken, this.expression, diagnostics);
    }

    public STNamedArgumentNode modify(STNode argumentName, STNode equalsToken, STNode expression) {
        if (this.checkForReferenceEquality(argumentName, equalsToken, expression)) {
            return this;
        }
        return new STNamedArgumentNode(argumentName, equalsToken, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NamedArgumentNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

