/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STNilLiteralNode
extends STExpressionNode {
    public final STNode openParenToken;
    public final STNode closeParenToken;

    STNilLiteralNode(STNode openParenToken, STNode closeParenToken) {
        this(openParenToken, closeParenToken, Collections.emptyList());
    }

    STNilLiteralNode(STNode openParenToken, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.NIL_LITERAL, diagnostics);
        this.openParenToken = openParenToken;
        this.closeParenToken = closeParenToken;
        this.addChildren(openParenToken, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STNilLiteralNode(this.openParenToken, this.closeParenToken, diagnostics);
    }

    public STNilLiteralNode modify(STNode openParenToken, STNode closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, closeParenToken)) {
            return this;
        }
        return new STNilLiteralNode(openParenToken, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new NilLiteralNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

