/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STIntermediateClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OrderByClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOrderByClauseNode
extends STIntermediateClauseNode {
    public final STNode orderKeyword;
    public final STNode byKeyword;
    public final STNode orderKey;

    STOrderByClauseNode(STNode orderKeyword, STNode byKeyword, STNode orderKey) {
        this(orderKeyword, byKeyword, orderKey, Collections.emptyList());
    }

    STOrderByClauseNode(STNode orderKeyword, STNode byKeyword, STNode orderKey, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ORDER_BY_CLAUSE, diagnostics);
        this.orderKeyword = orderKeyword;
        this.byKeyword = byKeyword;
        this.orderKey = orderKey;
        this.addChildren(orderKeyword, byKeyword, orderKey);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOrderByClauseNode(this.orderKeyword, this.byKeyword, this.orderKey, diagnostics);
    }

    public STOrderByClauseNode modify(STNode orderKeyword, STNode byKeyword, STNode orderKey) {
        if (this.checkForReferenceEquality(orderKeyword, byKeyword, orderKey)) {
            return this;
        }
        return new STOrderByClauseNode(orderKeyword, byKeyword, orderKey, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OrderByClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

