/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReQuantifierNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReQuantifierNode
extends STNode {
    public final STNode reBaseQuantifier;
    public final STNode nonGreedyChar;

    STReQuantifierNode(STNode reBaseQuantifier, STNode nonGreedyChar) {
        this(reBaseQuantifier, nonGreedyChar, Collections.emptyList());
    }

    STReQuantifierNode(STNode reBaseQuantifier, STNode nonGreedyChar, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_QUANTIFIER, diagnostics);
        this.reBaseQuantifier = reBaseQuantifier;
        this.nonGreedyChar = nonGreedyChar;
        this.addChildren(reBaseQuantifier, nonGreedyChar);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReQuantifierNode(this.reBaseQuantifier, this.nonGreedyChar, diagnostics);
    }

    public STReQuantifierNode modify(STNode reBaseQuantifier, STNode nonGreedyChar) {
        if (this.checkForReferenceEquality(reBaseQuantifier, nonGreedyChar)) {
            return this;
        }
        return new STReQuantifierNode(reBaseQuantifier, nonGreedyChar, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReQuantifierNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

