/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRestParameterNode
extends STParameterNode {
    public final STNode annotations;
    public final STNode typeName;
    public final STNode ellipsisToken;
    public final STNode paramName;

    STRestParameterNode(STNode annotations, STNode typeName, STNode ellipsisToken, STNode paramName) {
        this(annotations, typeName, ellipsisToken, paramName, Collections.emptyList());
    }

    STRestParameterNode(STNode annotations, STNode typeName, STNode ellipsisToken, STNode paramName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REST_PARAM, diagnostics);
        this.annotations = annotations;
        this.typeName = typeName;
        this.ellipsisToken = ellipsisToken;
        this.paramName = paramName;
        this.addChildren(annotations, typeName, ellipsisToken, paramName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRestParameterNode(this.annotations, this.typeName, this.ellipsisToken, this.paramName, diagnostics);
    }

    public STRestParameterNode modify(STNode annotations, STNode typeName, STNode ellipsisToken, STNode paramName) {
        if (this.checkForReferenceEquality(annotations, typeName, ellipsisToken, paramName)) {
            return this;
        }
        return new STRestParameterNode(annotations, typeName, ellipsisToken, paramName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RestParameterNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

