/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class CompoundAssignmentStatementNode
extends StatementNode {
    public CompoundAssignmentStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode lhsExpression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token binaryOperator() {
        return (Token)this.childInBucket(1);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode rhsExpression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"lhsExpression", "binaryOperator", "equalsToken", "rhsExpression", "semicolonToken"};
    }

    public CompoundAssignmentStatementNode modify(ExpressionNode lhsExpression, Token binaryOperator, Token equalsToken, ExpressionNode rhsExpression, Token semicolonToken) {
        if (this.checkForReferenceEquality(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createCompoundAssignmentStatementNode(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken);
    }

    public CompoundAssignmentStatementNodeModifier modify() {
        return new CompoundAssignmentStatementNodeModifier(this);
    }

    public static class CompoundAssignmentStatementNodeModifier {
        private final CompoundAssignmentStatementNode oldNode;
        private ExpressionNode lhsExpression;
        private Token binaryOperator;
        private Token equalsToken;
        private ExpressionNode rhsExpression;
        private Token semicolonToken;

        public CompoundAssignmentStatementNodeModifier(CompoundAssignmentStatementNode oldNode) {
            this.oldNode = oldNode;
            this.lhsExpression = oldNode.lhsExpression();
            this.binaryOperator = oldNode.binaryOperator();
            this.equalsToken = oldNode.equalsToken();
            this.rhsExpression = oldNode.rhsExpression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public CompoundAssignmentStatementNodeModifier withLhsExpression(ExpressionNode lhsExpression) {
            Objects.requireNonNull(lhsExpression, "lhsExpression must not be null");
            this.lhsExpression = lhsExpression;
            return this;
        }

        public CompoundAssignmentStatementNodeModifier withBinaryOperator(Token binaryOperator) {
            Objects.requireNonNull(binaryOperator, "binaryOperator must not be null");
            this.binaryOperator = binaryOperator;
            return this;
        }

        public CompoundAssignmentStatementNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public CompoundAssignmentStatementNodeModifier withRhsExpression(ExpressionNode rhsExpression) {
            Objects.requireNonNull(rhsExpression, "rhsExpression must not be null");
            this.rhsExpression = rhsExpression;
            return this;
        }

        public CompoundAssignmentStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public CompoundAssignmentStatementNode apply() {
            return this.oldNode.modify(this.lhsExpression, this.binaryOperator, this.equalsToken, this.rhsExpression, this.semicolonToken);
        }
    }
}

