/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class FailStatementNode
extends StatementNode {
    public FailStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token failKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"failKeyword", "expression", "semicolonToken"};
    }

    public FailStatementNode modify(Token failKeyword, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(failKeyword, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createFailStatementNode(failKeyword, expression, semicolonToken);
    }

    public FailStatementNodeModifier modify() {
        return new FailStatementNodeModifier(this);
    }

    public static class FailStatementNodeModifier {
        private final FailStatementNode oldNode;
        private Token failKeyword;
        private ExpressionNode expression;
        private Token semicolonToken;

        public FailStatementNodeModifier(FailStatementNode oldNode) {
            this.oldNode = oldNode;
            this.failKeyword = oldNode.failKeyword();
            this.expression = oldNode.expression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public FailStatementNodeModifier withFailKeyword(Token failKeyword) {
            Objects.requireNonNull(failKeyword, "failKeyword must not be null");
            this.failKeyword = failKeyword;
            return this;
        }

        public FailStatementNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public FailStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public FailStatementNode apply() {
            return this.oldNode.modify(this.failKeyword, this.expression, this.semicolonToken);
        }
    }
}

