/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class GroupByClauseNode
extends IntermediateClauseNode {
    public GroupByClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token groupKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token byKeyword() {
        return (Token)this.childInBucket(1);
    }

    public SeparatedNodeList<Node> groupingKey() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"groupKeyword", "byKeyword", "groupingKey"};
    }

    public GroupByClauseNode modify(Token groupKeyword, Token byKeyword, SeparatedNodeList<Node> groupingKey) {
        if (this.checkForReferenceEquality(groupKeyword, byKeyword, groupingKey.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createGroupByClauseNode(groupKeyword, byKeyword, groupingKey);
    }

    public GroupByClauseNodeModifier modify() {
        return new GroupByClauseNodeModifier(this);
    }

    public static class GroupByClauseNodeModifier {
        private final GroupByClauseNode oldNode;
        private Token groupKeyword;
        private Token byKeyword;
        private SeparatedNodeList<Node> groupingKey;

        public GroupByClauseNodeModifier(GroupByClauseNode oldNode) {
            this.oldNode = oldNode;
            this.groupKeyword = oldNode.groupKeyword();
            this.byKeyword = oldNode.byKeyword();
            this.groupingKey = oldNode.groupingKey();
        }

        public GroupByClauseNodeModifier withGroupKeyword(Token groupKeyword) {
            Objects.requireNonNull(groupKeyword, "groupKeyword must not be null");
            this.groupKeyword = groupKeyword;
            return this;
        }

        public GroupByClauseNodeModifier withByKeyword(Token byKeyword) {
            Objects.requireNonNull(byKeyword, "byKeyword must not be null");
            this.byKeyword = byKeyword;
            return this;
        }

        public GroupByClauseNodeModifier withGroupingKey(SeparatedNodeList<Node> groupingKey) {
            Objects.requireNonNull(groupingKey, "groupingKey must not be null");
            this.groupingKey = groupingKey;
            return this;
        }

        public GroupByClauseNode apply() {
            return this.oldNode.modify(this.groupKeyword, this.byKeyword, this.groupingKey);
        }
    }
}

