/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ImportOrgNameNode
extends NonTerminalNode {
    public ImportOrgNameNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token orgName() {
        return (Token)this.childInBucket(0);
    }

    public Token slashToken() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"orgName", "slashToken"};
    }

    public ImportOrgNameNode modify(Token orgName, Token slashToken) {
        if (this.checkForReferenceEquality(orgName, slashToken)) {
            return this;
        }
        return NodeFactory.createImportOrgNameNode(orgName, slashToken);
    }

    public ImportOrgNameNodeModifier modify() {
        return new ImportOrgNameNodeModifier(this);
    }

    public static class ImportOrgNameNodeModifier {
        private final ImportOrgNameNode oldNode;
        private Token orgName;
        private Token slashToken;

        public ImportOrgNameNodeModifier(ImportOrgNameNode oldNode) {
            this.oldNode = oldNode;
            this.orgName = oldNode.orgName();
            this.slashToken = oldNode.slashToken();
        }

        public ImportOrgNameNodeModifier withOrgName(Token orgName) {
            Objects.requireNonNull(orgName, "orgName must not be null");
            this.orgName = orgName;
            return this;
        }

        public ImportOrgNameNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public ImportOrgNameNode apply() {
            return this.oldNode.modify(this.orgName, this.slashToken);
        }
    }
}

