/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class LocalTypeDefinitionStatementNode
extends StatementNode {
    public LocalTypeDefinitionStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public Token typeKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Node typeName() {
        return this.childInBucket(2);
    }

    public Node typeDescriptor() {
        return this.childInBucket(3);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "typeKeyword", "typeName", "typeDescriptor", "semicolonToken"};
    }

    public LocalTypeDefinitionStatementNode modify(NodeList<AnnotationNode> annotations, Token typeKeyword, Node typeName, Node typeDescriptor, Token semicolonToken) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), typeKeyword, typeName, typeDescriptor, semicolonToken)) {
            return this;
        }
        return NodeFactory.createLocalTypeDefinitionStatementNode(annotations, typeKeyword, typeName, typeDescriptor, semicolonToken);
    }

    public LocalTypeDefinitionStatementNodeModifier modify() {
        return new LocalTypeDefinitionStatementNodeModifier(this);
    }

    public static class LocalTypeDefinitionStatementNodeModifier {
        private final LocalTypeDefinitionStatementNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private Token typeKeyword;
        private Node typeName;
        private Node typeDescriptor;
        private Token semicolonToken;

        public LocalTypeDefinitionStatementNodeModifier(LocalTypeDefinitionStatementNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.typeKeyword = oldNode.typeKeyword();
            this.typeName = oldNode.typeName();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public LocalTypeDefinitionStatementNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public LocalTypeDefinitionStatementNodeModifier withTypeKeyword(Token typeKeyword) {
            Objects.requireNonNull(typeKeyword, "typeKeyword must not be null");
            this.typeKeyword = typeKeyword;
            return this;
        }

        public LocalTypeDefinitionStatementNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public LocalTypeDefinitionStatementNodeModifier withTypeDescriptor(Node typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public LocalTypeDefinitionStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public LocalTypeDefinitionStatementNode apply() {
            return this.oldNode.modify(this.annotations, this.typeKeyword, this.typeName, this.typeDescriptor, this.semicolonToken);
        }
    }
}

