/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Objects;

public class PositionalArgumentNode
extends FunctionArgumentNode {
    public PositionalArgumentNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression"};
    }

    public PositionalArgumentNode modify(ExpressionNode expression) {
        if (this.checkForReferenceEquality(expression)) {
            return this;
        }
        return NodeFactory.createPositionalArgumentNode(expression);
    }

    public PositionalArgumentNodeModifier modify() {
        return new PositionalArgumentNodeModifier(this);
    }

    public static class PositionalArgumentNodeModifier {
        private final PositionalArgumentNode oldNode;
        private ExpressionNode expression;

        public PositionalArgumentNodeModifier(PositionalArgumentNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
        }

        public PositionalArgumentNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public PositionalArgumentNode apply() {
            return this.oldNode.modify(this.expression);
        }
    }
}

