/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReQuantifierNode
extends NonTerminalNode {
    public ReQuantifierNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node reBaseQuantifier() {
        return this.childInBucket(0);
    }

    public Optional<Token> nonGreedyChar() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"reBaseQuantifier", "nonGreedyChar"};
    }

    public ReQuantifierNode modify(Node reBaseQuantifier, Token nonGreedyChar) {
        if (this.checkForReferenceEquality(reBaseQuantifier, nonGreedyChar)) {
            return this;
        }
        return NodeFactory.createReQuantifierNode(reBaseQuantifier, nonGreedyChar);
    }

    public ReQuantifierNodeModifier modify() {
        return new ReQuantifierNodeModifier(this);
    }

    public static class ReQuantifierNodeModifier {
        private final ReQuantifierNode oldNode;
        private Node reBaseQuantifier;
        private Token nonGreedyChar;

        public ReQuantifierNodeModifier(ReQuantifierNode oldNode) {
            this.oldNode = oldNode;
            this.reBaseQuantifier = oldNode.reBaseQuantifier();
            this.nonGreedyChar = oldNode.nonGreedyChar().orElse(null);
        }

        public ReQuantifierNodeModifier withReBaseQuantifier(Node reBaseQuantifier) {
            Objects.requireNonNull(reBaseQuantifier, "reBaseQuantifier must not be null");
            this.reBaseQuantifier = reBaseQuantifier;
            return this;
        }

        public ReQuantifierNodeModifier withNonGreedyChar(Token nonGreedyChar) {
            this.nonGreedyChar = nonGreedyChar;
            return this;
        }

        public ReQuantifierNode apply() {
            return this.oldNode.modify(this.reBaseQuantifier, this.nonGreedyChar);
        }
    }
}

