/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class TransactionStatementNode
extends StatementNode {
    public TransactionStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token transactionKeyword() {
        return (Token)this.childInBucket(0);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(1);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"transactionKeyword", "blockStatement", "onFailClause"};
    }

    public TransactionStatementNode modify(Token transactionKeyword, BlockStatementNode blockStatement, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(transactionKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return NodeFactory.createTransactionStatementNode(transactionKeyword, blockStatement, onFailClause);
    }

    public TransactionStatementNodeModifier modify() {
        return new TransactionStatementNodeModifier(this);
    }

    public static class TransactionStatementNodeModifier {
        private final TransactionStatementNode oldNode;
        private Token transactionKeyword;
        private BlockStatementNode blockStatement;
        private OnFailClauseNode onFailClause;

        public TransactionStatementNodeModifier(TransactionStatementNode oldNode) {
            this.oldNode = oldNode;
            this.transactionKeyword = oldNode.transactionKeyword();
            this.blockStatement = oldNode.blockStatement();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public TransactionStatementNodeModifier withTransactionKeyword(Token transactionKeyword) {
            Objects.requireNonNull(transactionKeyword, "transactionKeyword must not be null");
            this.transactionKeyword = transactionKeyword;
            return this;
        }

        public TransactionStatementNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public TransactionStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public TransactionStatementNode apply() {
            return this.oldNode.modify(this.transactionKeyword, this.blockStatement, this.onFailClause);
        }
    }
}

