/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.XMLNavigateExpressionNode;
import java.util.Objects;

public class XMLStepExpressionNode
extends XMLNavigateExpressionNode {
    public XMLStepExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Node xmlStepStart() {
        return this.childInBucket(1);
    }

    public NodeList<Node> xmlStepExtend() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "xmlStepStart", "xmlStepExtend"};
    }

    public XMLStepExpressionNode modify(ExpressionNode expression, Node xmlStepStart, NodeList<Node> xmlStepExtend) {
        if (this.checkForReferenceEquality(expression, xmlStepStart, xmlStepExtend.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createXMLStepExpressionNode(expression, xmlStepStart, xmlStepExtend);
    }

    public XMLStepExpressionNodeModifier modify() {
        return new XMLStepExpressionNodeModifier(this);
    }

    public static class XMLStepExpressionNodeModifier {
        private final XMLStepExpressionNode oldNode;
        private ExpressionNode expression;
        private Node xmlStepStart;
        private NodeList<Node> xmlStepExtend;

        public XMLStepExpressionNodeModifier(XMLStepExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.xmlStepStart = oldNode.xmlStepStart();
            this.xmlStepExtend = oldNode.xmlStepExtend();
        }

        public XMLStepExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public XMLStepExpressionNodeModifier withXmlStepStart(Node xmlStepStart) {
            Objects.requireNonNull(xmlStepStart, "xmlStepStart must not be null");
            this.xmlStepStart = xmlStepStart;
            return this;
        }

        public XMLStepExpressionNodeModifier withXmlStepExtend(NodeList<Node> xmlStepExtend) {
            Objects.requireNonNull(xmlStepExtend, "xmlStepExtend must not be null");
            this.xmlStepExtend = xmlStepExtend;
            return this;
        }

        public XMLStepExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.xmlStepStart, this.xmlStepExtend);
        }
    }
}

