/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.PerformanceAnalyzerNodeVisitor;
import io.ballerina.PerformanceAnalyzerResponse;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.component.Node;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Range;

public final class EndpointsFinder {
    private EndpointsFinder() {
    }

    public static PerformanceAnalyzerResponse getEndpoints(String fileUri, WorkspaceManager workspaceManager, Range range, boolean isWorkerSupported) {
        PerformanceAnalyzerResponse response = new PerformanceAnalyzerResponse();
        Path path = Path.of(fileUri, new String[0]);
        String file = StringUtils.substringAfterLast(fileUri, File.separator);
        try {
            HashMap<String, Object> endpointsAndActionInvocations;
            Optional semanticModel = workspaceManager.semanticModel(path);
            Optional module = workspaceManager.module(path);
            if (semanticModel.isEmpty() || module.isEmpty() || range == null) {
                response.setType("error");
                response.setMessage("ENDPOINT_RESOLVE_ERROR");
                return response;
            }
            Module defaultModule = (Module)module.get();
            PerformanceAnalyzerNodeVisitor nodeVisitor = new PerformanceAnalyzerNodeVisitor((SemanticModel)semanticModel.get(), file, range);
            for (DocumentId currentDocumentID : defaultModule.documentIds()) {
                Document document = defaultModule.document(currentDocumentID);
                SyntaxTree syntaxTree = document.syntaxTree();
                nodeVisitor.setDocument(document);
                syntaxTree.rootNode().accept((NodeVisitor)nodeVisitor);
            }
            GsonBuilder builder = new GsonBuilder();
            builder.serializeNulls();
            Gson gson = builder.create();
            JsonObject actionInvocationsJson = new JsonObject();
            if (isWorkerSupported) {
                endpointsAndActionInvocations = nodeVisitor.getWorkers();
                HashMap workers = (HashMap)endpointsAndActionInvocations.get("actionInvocations");
                JsonObject workersJson = new JsonObject();
                boolean isNoData = true;
                for (Map.Entry worker : workers.entrySet()) {
                    JsonObject workerJson = new JsonObject();
                    JsonElement nextNode = gson.toJsonTree((Object)((Node)worker.getValue()).getNextNode());
                    workerJson.add("nextNode", nextNode);
                    workersJson.add(worker.getKey().toString(), (JsonElement)workerJson);
                    if (nextNode.isJsonNull()) continue;
                    isNoData = false;
                }
                actionInvocationsJson.add("workers", (JsonElement)workersJson);
                if (isNoData) {
                    response.setType("error");
                    response.setMessage("NO_DATA");
                    return response;
                }
            } else {
                if (!nodeVisitor.canGivePrediction()) {
                    response.setType("error");
                    response.setMessage("ENDPOINT_RESOLVE_ERROR");
                    return response;
                }
                endpointsAndActionInvocations = nodeVisitor.getActionInvocations();
                Node actionInvocations = (Node)endpointsAndActionInvocations.get("actionInvocations");
                JsonElement nextNodesJson = gson.toJsonTree((Object)actionInvocations.getNextNode());
                actionInvocationsJson.add("nextNode", nextNodesJson);
                if (nextNodesJson.isJsonNull()) {
                    response.setType("error");
                    response.setMessage("NO_DATA");
                }
            }
            JsonElement endPointsJson = gson.toJsonTree(endpointsAndActionInvocations.get("endpoints"));
            response.setType("Success");
            response.setMessage("Success");
            response.setEndpoints(endPointsJson.getAsJsonObject());
            response.setActionInvocations(actionInvocationsJson);
            return response;
        }
        catch (CancellationException cancellationException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        response.setType("error");
        response.setMessage("ENDPOINT_RESOLVE_ERROR");
        return response;
    }
}

