/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xmldata.compiler.object;

import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;

public class Record {
    private final String name;
    private final Location location;
    private Boolean nameAnnotation = false;
    private final List<NodeLocation> optionalFieldLocations = new ArrayList<NodeLocation>();
    private final List<String> childRecordNames = new ArrayList<String>();
    private final List<NodeLocation> multipleNonPrimitiveTypeLocations = new ArrayList<NodeLocation>();

    public Record(String name, Location location) {
        this.name = name;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void addOptionalFieldLocations(NodeLocation optionalsField) {
        this.optionalFieldLocations.add(optionalsField);
    }

    public List<NodeLocation> getOptionalFieldLocations() {
        return this.optionalFieldLocations;
    }

    public void addMultipleNonPrimitiveTypeLocations(NodeLocation optionalsField) {
        this.multipleNonPrimitiveTypeLocations.add(optionalsField);
    }

    public List<NodeLocation> getMultipleNonPrimitiveTypeLocations() {
        return this.multipleNonPrimitiveTypeLocations;
    }

    public void addChildRecordNames(String name) {
        if (!this.childRecordNames.contains(name)) {
            this.childRecordNames.add(name);
        }
    }

    public List<String> getChildRecordNames() {
        return this.childRecordNames;
    }

    public void setNameAnnotation() {
        this.nameAnnotation = true;
    }

    public boolean hasNameAnnotation() {
        return this.nameAnnotation;
    }

    public Location getLocation() {
        return this.location;
    }
}

