/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.central.client.LogFormatter;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;

public final class Utils {
    private static final int BUFFER_SIZE = 1024;
    public static final String DEPRECATED_META_FILE_NAME = "deprecated.txt";
    public static final boolean SET_BALLERINA_STAGE_CENTRAL = Boolean.parseBoolean(System.getenv("BALLERINA_STAGE_CENTRAL"));
    public static final boolean SET_BALLERINA_DEV_CENTRAL = Boolean.parseBoolean(System.getenv("BALLERINA_DEV_CENTRAL"));
    public static final boolean SET_TEST_MODE_ACTIVE = Boolean.parseBoolean(System.getenv("TEST_MODE_ACTIVE"));

    private Utils() {
    }

    public static void createBalaInHomeRepo(Response balaDownloadResponse, Path pkgPathInBalaCache, String pkgOrg, String pkgName, boolean isNightlyBuild, String deprecationMsg, String newUrl, String contentDisposition, PrintStream outStream, LogFormatter logFormatter, String trueDigest) throws CentralClientException {
        Path balaCacheWithPkgPath;
        String platform;
        String balaFile;
        String validPkgVersion;
        long responseContentLength;
        block22: {
            String resolvedURI;
            responseContentLength = 0L;
            Optional<ResponseBody> downloadBody = Optional.ofNullable(balaDownloadResponse.body());
            if (downloadBody.isPresent()) {
                long contentLength = downloadBody.get().contentLength();
                if (contentLength <= 0L) {
                    downloadBody.get().close();
                    throw new CentralClientException(logFormatter.formatLog("invalid response from the server, please try again"));
                }
                responseContentLength = contentLength;
            }
            if ((resolvedURI = balaDownloadResponse.header("RESOLVED_REQUESTED_URI")) == null || resolvedURI.isEmpty()) {
                resolvedURI = newUrl;
            }
            String[] uriParts = resolvedURI.split("/");
            String pkgVersion = uriParts[uriParts.length - 2];
            validPkgVersion = Utils.validatePackageVersion(pkgVersion, logFormatter);
            balaFile = Utils.getBalaFileName(contentDisposition, uriParts[uriParts.length - 1]);
            platform = Utils.getPlatformFromBala(balaFile, pkgName, validPkgVersion);
            balaCacheWithPkgPath = pkgPathInBalaCache.resolve(validPkgVersion).resolve(platform);
            try {
                boolean hasChildren;
                if (!Files.isDirectory(balaCacheWithPkgPath, new LinkOption[0])) break block22;
                try (Stream<Path> paths = Files.list(balaCacheWithPkgPath);){
                    hasChildren = paths.findAny().isPresent();
                }
                if (!hasChildren) break block22;
                Path deprecatedFilePath = balaCacheWithPkgPath.resolve(DEPRECATED_META_FILE_NAME);
                if (deprecatedFilePath.toFile().exists() && deprecationMsg == null) {
                    Files.delete(deprecatedFilePath);
                } else if (deprecationMsg != null) {
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(deprecatedFilePath.toFile(), Charset.defaultCharset()));){
                        writer.write(deprecationMsg);
                    }
                }
                downloadBody.ifPresent(ResponseBody::close);
                throw new PackageAlreadyExistsException(logFormatter.formatLog("package already exists in the home repository: " + balaCacheWithPkgPath.toString()), validPkgVersion);
            }
            catch (IOException e) {
                downloadBody.ifPresent(ResponseBody::close);
                throw new PackageAlreadyExistsException(logFormatter.formatLog("error accessing bala : " + balaCacheWithPkgPath.toString()), validPkgVersion);
            }
        }
        Path tempPath = pkgPathInBalaCache.resolve(validPkgVersion + "_temp").resolve(platform);
        Utils.createBalaFileDirectory(tempPath, logFormatter);
        Utils.writeBalaFile(balaDownloadResponse, tempPath.resolve(balaFile), pkgOrg + "/" + pkgName + ":" + validPkgVersion, responseContentLength, outStream, logFormatter, pkgPathInBalaCache.resolve(validPkgVersion), trueDigest);
        try {
            File tempDir = tempPath.getParent().toFile();
            File platformDir = balaCacheWithPkgPath.getParent().toFile();
            if (!tempDir.renameTo(platformDir)) {
                throw new CentralClientException(logFormatter.formatLog("error creating directory for bala file"));
            }
        }
        catch (NullPointerException e) {
            throw new CentralClientException(logFormatter.formatLog("error creating directory for bala file :" + e.getMessage()));
        }
        Utils.handleNightlyBuild(isNightlyBuild, balaCacheWithPkgPath, logFormatter);
        Utils.handlePackageDeprecation(deprecationMsg, balaCacheWithPkgPath, logFormatter);
    }

    static String validatePackageVersion(String pkgVersion, LogFormatter logFormatter) throws CentralClientException {
        try {
            Version version = Version.valueOf((String)pkgVersion);
            return version.toString();
        }
        catch (IllegalArgumentException e) {
            throw new CentralClientException(logFormatter.formatLog("Version cannot be empty"));
        }
        catch (UnexpectedCharacterException e) {
            throw new CentralClientException(logFormatter.formatLog("Invalid version: '" + pkgVersion + "'. " + e.toString()));
        }
        catch (ParseException e) {
            throw new CentralClientException(logFormatter.formatLog("Invalid version: '" + pkgVersion + "'. " + e.toString()));
        }
    }

    private static String getBalaFileName(String contentDisposition, String balaFile) {
        if (contentDisposition != null && !contentDisposition.isEmpty()) {
            return contentDisposition.substring("attachment; filename=".length());
        }
        return balaFile;
    }

    private static void createBalaFileDirectory(Path fullPathToStoreBala, LogFormatter logFormatter) throws CentralClientException {
        try {
            Files.createDirectories(fullPathToStoreBala, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CentralClientException(logFormatter.formatLog("error creating directory for bala file"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBalaFile(Response balaDownloadResponse, Path balaPath, String fullPkgName, long resContentLength, PrintStream outStream, LogFormatter logFormatter, Path homeRepo, String trueDigest) throws CentralClientException {
        block22: {
            Optional<ResponseBody> body = Optional.ofNullable(balaDownloadResponse.body());
            if (body.isPresent()) {
                try {
                    try (InputStream inputStream = body.get().byteStream();
                         FileOutputStream outputStream = new FileOutputStream(balaPath.toString());){
                        if (outStream == null) {
                            Utils.writeAndHandleProgressQuietly(inputStream, outputStream);
                        } else {
                            Utils.writeAndHandleProgress(inputStream, outputStream, resContentLength / 1024L, fullPkgName, outStream, logFormatter, homeRepo);
                        }
                    }
                    catch (IOException e) {
                        throw new CentralClientException(logFormatter.formatLog("error occurred copying the bala file: " + e.getMessage()));
                    }
                    try {
                        Utils.extractBala(balaPath, Optional.of(balaPath.getParent()).get(), trueDigest, fullPkgName, outStream);
                        Files.delete(balaPath);
                        break block22;
                    }
                    catch (IOException | CentralClientException e) {
                        throw new CentralClientException(logFormatter.formatLog("error occurred extracting the bala file: " + e.getMessage()));
                    }
                }
                finally {
                    body.get().close();
                }
            }
            throw new CentralClientException(logFormatter.formatLog("error occurred extracting bytes of bala file: " + fullPkgName));
        }
    }

    private static void handleNightlyBuild(boolean isNightlyBuild, Path balaCacheWithPkgPath, LogFormatter logFormatter) throws CentralClientException {
        Path nightlyBuildMetaFile;
        if (isNightlyBuild && !(nightlyBuildMetaFile = Path.of(balaCacheWithPkgPath.toString(), "nightly.build")).toFile().exists()) {
            Utils.createMetaFile(nightlyBuildMetaFile, logFormatter, "error occurred while creating nightly.build file.");
        }
    }

    private static void handlePackageDeprecation(String deprecateMsg, Path balaCacheWithPkgPath, LogFormatter logFormatter) throws CentralClientException {
        if (deprecateMsg != null) {
            Path deprecateMsgFile = Path.of(balaCacheWithPkgPath.toString(), DEPRECATED_META_FILE_NAME);
            if (!deprecateMsgFile.toFile().exists()) {
                Utils.createMetaFile(deprecateMsgFile, logFormatter, "error occurred while creating the file 'deprecated.txt'");
            }
            Utils.writeDeprecatedMsg(deprecateMsgFile, logFormatter, deprecateMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndHandleProgress(InputStream inputStream, FileOutputStream outputStream, long totalSizeInKB, String fullPkgName, PrintStream outStream, LogFormatter logFormatter, Path homeRepo) throws IOException {
        byte[] buffer = new byte[1024];
        String remoteRepo = Utils.getRemoteRepo();
        String progressBarTask = fullPkgName + " [" + remoteRepo + " ->" + String.valueOf(homeRepo) + "] ";
        try (ProgressBar progressBar = new ProgressBar(progressBarTask, totalSizeInKB, 1000, outStream, ProgressBarStyle.ASCII, " KB", 1L);){
            int count;
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
                progressBar.step();
            }
        }
        finally {
            outStream.println(logFormatter.formatLog(fullPkgName + " pulled from central successfully"));
        }
    }

    private static void writeAndHandleProgressQuietly(InputStream inputStream, FileOutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
        }
    }

    private static void createMetaFile(Path metaFilePath, LogFormatter logFormatter, String message) throws CentralClientException {
        try {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new CentralClientException(logFormatter.formatLog(message));
        }
    }

    private static void writeDeprecatedMsg(Path metaFilePath, LogFormatter logFormatter, String message) throws CentralClientException {
        if (metaFilePath.toFile().exists()) {
            try (FileWriter fileWriter = new FileWriter(metaFilePath.toAbsolutePath().toString(), Charset.defaultCharset());
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                bufferedWriter.write(message);
            }
            catch (IOException e) {
                throw new CentralClientException(logFormatter.formatLog("error occurred while writing deprecation message to the file 'deprecated.txt'"));
            }
        }
    }

    static List<String> getAsList(String arrayString) {
        return (List)new Gson().fromJson(arrayString, (TypeToken)new TypeToken<List<String>>(){});
    }

    static boolean isApplicationJsonContentType(String contentType) {
        return contentType.startsWith("application/json");
    }

    private static String getPlatformFromBala(String balaName, String packageName, String version) {
        return balaName.split(packageName + "-")[1].split("-" + version)[0];
    }

    private static void extractBala(Path balaFilePath, Path balaFileDestPath, String trueDigest, String packageName, PrintStream outStream) throws IOException, CentralClientException {
        Files.createDirectories(balaFileDestPath, new FileAttribute[0]);
        URI zipURI = URI.create("jar:" + balaFilePath.toUri().toString());
        if (!trueDigest.equals("sha-256=" + Utils.checkHash(balaFilePath.toString(), "SHA-256"))) {
            StringBuilder warning = new StringBuilder(String.format("*************************************************************%n* WARNING: Certain packages may have originated from sources other than the official distributors. *%n*************************************************************%n%n* Verification failed: The hash value of the following package could not be confirmed. %n" + packageName + "%n", new Object[0]));
            if (outStream != null) {
                outStream.println(warning.toString());
            }
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());){
            List<Path> paths;
            Path packageRoot = zipFileSystem.getPath("/", new String[0]);
            try (Stream<Path> pathStream = Files.walk(packageRoot, new FileVisitOption[0]);){
                paths = pathStream.filter(path -> path != packageRoot).toList();
            }
            for (Path path2 : paths) {
                Path destPath = balaFileDestPath.resolve(packageRoot.relativize(path2).toString());
                if (destPath.toFile().isDirectory()) {
                    FileUtils.deleteDirectory((File)destPath.toFile());
                }
                Files.copy(path2, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String checkHash(String filePath, String algorithm) throws CentralClientException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CentralClientException("Unable to calculate the hash value of the file " + filePath + ": " + e.getMessage());
        }
        try (FileInputStream is = new FileInputStream(filePath);){
            String string;
            try (DigestInputStream dis = new DigestInputStream(is, md);){
                byte[] buffer = new byte[1024];
                while (dis.read(buffer) != -1) {
                }
                md = dis.getMessageDigest();
                string = Utils.bytesToHex(md.digest());
            }
            return string;
        }
        catch (IOException | RuntimeException e) {
            throw new CentralClientException("Unable to calculate the hash value of the file " + filePath + ": " + e.getMessage());
        }
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static String getBearerToken(String accessToken) {
        return "Bearer " + accessToken;
    }

    public static String getRemoteRepo() {
        if (SET_BALLERINA_STAGE_CENTRAL) {
            return "staging-central.ballerina.io";
        }
        if (SET_BALLERINA_DEV_CENTRAL) {
            return "dev-central.ballerina.io";
        }
        return "central.ballerina.io";
    }

    public static interface ProgressListener {
        public void onRequestProgress(long var1, long var3);
    }

    private static class CountingSink
    extends ForwardingSink {
        private long bytesWritten = 0L;
        private final ProgressBar progressBar;

        public CountingSink(Sink delegate, ProgressBar progressBar) {
            super(delegate);
            this.progressBar = progressBar;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            this.progressBar.stepTo(this.bytesWritten);
        }
    }

    public static class ProgressRequestBody
    extends RequestBody {
        private final RequestBody reqBody;
        private final String task;
        private final PrintStream out;

        public ProgressRequestBody(RequestBody reqBody, String task, PrintStream out) {
            this.reqBody = reqBody;
            this.task = task;
            this.out = out;
        }

        public MediaType contentType() {
            return this.reqBody.contentType();
        }

        public long contentLength() throws IOException {
            return this.reqBody.contentLength();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            String unitName;
            long byteConverter;
            long totalBytes = this.contentLength();
            if (totalBytes < 5120L) {
                byteConverter = 1L;
                unitName = " B";
            } else if (totalBytes < 0x500000L) {
                byteConverter = 1024L;
                unitName = " KB";
            } else {
                byteConverter = 0x100000L;
                unitName = " MB";
            }
            ProgressBar progressBar = new ProgressBar(this.task, this.contentLength(), 1000, this.out, ProgressBarStyle.ASCII, unitName, byteConverter);
            CountingSink countingSink = new CountingSink((Sink)sink, progressBar);
            BufferedSink progressSink = Okio.buffer((Sink)countingSink);
            this.reqBody.writeTo(progressSink);
            progressSink.flush();
            progressBar.close();
        }
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

