/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.plugin;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.grpc.plugin.GrpcCompilerPluginConstants;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class GrpcServiceValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String GRPC_GENERIC_CALLER = "caller";
    private static final String GRPC_EXACT_CALLER = "Caller";
    private static final String GRPC_RETURN_TYPE = "<RPC_RETURN_TYPE>";

    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        ServiceDeclarationSymbol serviceDeclarationSymbol;
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)syntaxNodeAnalysisContext.node();
        Optional optionalServiceDeclarationSymbol = syntaxNodeAnalysisContext.semanticModel().symbol((Node)serviceDeclarationNode);
        if (optionalServiceDeclarationSymbol.isPresent() && optionalServiceDeclarationSymbol.get() instanceof ServiceDeclarationSymbol && this.isBallerinaGrpcService(serviceDeclarationSymbol = (ServiceDeclarationSymbol)optionalServiceDeclarationSymbol.get())) {
            String serviceName = this.serviceNameFromServiceDeclarationNode(serviceDeclarationNode);
            this.validateServiceAnnotation(serviceDeclarationNode, syntaxNodeAnalysisContext, serviceDeclarationSymbol);
            this.validateServiceName(serviceDeclarationNode, syntaxNodeAnalysisContext, this.getFullServiceNameFromServiceDeclarationNode(serviceDeclarationNode));
            serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).forEach(node -> {
                boolean isRemoteFunction;
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                this.validateServiceFunctions(functionDefinitionNode, syntaxNodeAnalysisContext);
                boolean bl = isRemoteFunction = functionDefinitionNode.qualifierList().stream().filter(q -> q.kind() == SyntaxKind.REMOTE_KEYWORD).toArray().length == 1;
                if (isRemoteFunction) {
                    this.validateFunctionSignature(functionDefinitionNode, syntaxNodeAnalysisContext, serviceName);
                }
            });
        }
    }

    private boolean isBallerinaGrpcService(ServiceDeclarationSymbol serviceDeclarationSymbol) {
        List listenerTypes = serviceDeclarationSymbol.listenerTypes();
        for (TypeSymbol listenerType : listenerTypes) {
            if (listenerType.typeKind() == TypeDescKind.UNION) {
                List memberDescriptors = ((UnionTypeSymbol)listenerType).memberTypeDescriptors();
                for (TypeSymbol typeSymbol : memberDescriptors) {
                    if (!typeSymbol.getModule().isPresent() || !((ModuleSymbol)typeSymbol.getModule().get()).id().orgName().equals("ballerina") || !typeSymbol.getModule().flatMap(Symbol::getName).orElse("").equals("grpc")) continue;
                    return true;
                }
                continue;
            }
            if (listenerType.typeKind() != TypeDescKind.TYPE_REFERENCE || !listenerType.getModule().isPresent() || !((ModuleSymbol)listenerType.getModule().get()).id().orgName().equals("ballerina") || !((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().flatMap(Symbol::getName).orElse("").equals("grpc")) continue;
            return true;
        }
        return false;
    }

    private void validateServiceName(ServiceDeclarationNode serviceDeclarationNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, String serviceName) {
        if (serviceDeclarationNode.absoluteResourcePath().isEmpty()) {
            this.reportErrorDiagnostic((Node)serviceDeclarationNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getError() + ". Service name cannot be nil", GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getErrorCode());
        } else if (serviceName.equals("")) {
            this.reportErrorDiagnostic(serviceDeclarationNode.absoluteResourcePath().get(0), syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getError() + ". Service name cannot be nil", GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getErrorCode());
        } else if (serviceName.contains("/")) {
            this.reportErrorDiagnostic(serviceDeclarationNode.absoluteResourcePath().get(0), syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getError() + " " + serviceName + ". Service name should not be a hierarchical name", GrpcCompilerPluginConstants.CompilationErrors.INVALID_SERVICE_NAME.getErrorCode());
        }
    }

    private void validateServiceAnnotation(ServiceDeclarationNode serviceDeclarationNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, ServiceDeclarationSymbol serviceDeclarationSymbol) {
        boolean isServiceDescAnnotationPresents = false;
        List annotationSymbols = serviceDeclarationSymbol.annotations();
        for (AnnotationSymbol annotationSymbol : annotationSymbols) {
            if (!annotationSymbol.getModule().isPresent() || !"grpc".equals(((ModuleSymbol)annotationSymbol.getModule().get()).id().moduleName()) || !annotationSymbol.getName().isPresent() || !"ServiceDescriptor".equals(annotationSymbol.getName().get()) && !"Descriptor".equals(annotationSymbol.getName().get())) continue;
            isServiceDescAnnotationPresents = true;
            break;
        }
        if (!isServiceDescAnnotationPresents) {
            this.reportErrorDiagnostic((Node)serviceDeclarationNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.UNDEFINED_ANNOTATION.getError() + "grpc:Descriptor", GrpcCompilerPluginConstants.CompilationErrors.UNDEFINED_ANNOTATION.getErrorCode());
        }
    }

    private void validateServiceFunctions(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        boolean hasResourceKeyword;
        boolean bl = hasResourceKeyword = functionDefinitionNode.qualifierList().stream().filter(q -> q.kind() == SyntaxKind.RESOURCE_KEYWORD).toArray().length == 1;
        if (hasResourceKeyword) {
            this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.RESOURCES_NOT_ALLOWED.getError(), GrpcCompilerPluginConstants.CompilationErrors.RESOURCES_NOT_ALLOWED.getErrorCode());
        }
    }

    private void validateFunctionSignature(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, String serviceName) {
        FunctionSignatureNode functionSignatureNode = functionDefinitionNode.functionSignature();
        SeparatedNodeList parameterNodes = functionSignatureNode.parameters();
        if (parameterNodes.size() == 2) {
            Node returnTypeNode;
            String firstParameter = this.typeNameFromParameterNode((ParameterNode)functionSignatureNode.parameters().get(0));
            if (!firstParameter.toLowerCase(Locale.ENGLISH).contains(GRPC_GENERIC_CALLER)) {
                this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.TWO_PARAMS_WITHOUT_CALLER.getError(), GrpcCompilerPluginConstants.CompilationErrors.TWO_PARAMS_WITHOUT_CALLER.getErrorCode());
            } else if (!this.isValidCallerParameter(firstParameter, serviceName)) {
                String expectedCaller = serviceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + serviceName.substring(1) + "<RPC_RETURN_TYPE>Caller";
                String diagnosticMessage = GrpcCompilerPluginConstants.CompilationErrors.INVALID_CALLER_TYPE.getError() + expectedCaller + "\" but found \"" + firstParameter + "\"";
                this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, diagnosticMessage, GrpcCompilerPluginConstants.CompilationErrors.INVALID_CALLER_TYPE.getErrorCode());
            } else if (functionSignatureNode.returnTypeDesc().isPresent() && SyntaxKind.NIL_TYPE_DESC != (returnTypeNode = ((ReturnTypeDescriptorNode)functionSignatureNode.returnTypeDesc().get()).type()).kind()) {
                if (SyntaxKind.OPTIONAL_TYPE_DESC == returnTypeNode.kind() && ((OptionalTypeDescriptorNode)returnTypeNode).children().size() == 2) {
                    for (Node value : ((OptionalTypeDescriptorNode)returnTypeNode).children()) {
                        if (value.kind() == SyntaxKind.ERROR_TYPE_DESC || value.kind() == SyntaxKind.QUESTION_MARK_TOKEN) continue;
                        this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getError(), GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getErrorCode());
                        break;
                    }
                } else if (SyntaxKind.UNION_TYPE_DESC == returnTypeNode.kind() && ((UnionTypeDescriptorNode)returnTypeNode).children().size() == 3) {
                    for (Node value : ((UnionTypeDescriptorNode)returnTypeNode).children()) {
                        if (value.kind() == SyntaxKind.ERROR_TYPE_DESC || value.kind() == SyntaxKind.PIPE_TOKEN || value.kind() == SyntaxKind.NIL_TYPE_DESC) continue;
                        this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getError(), GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getErrorCode());
                        break;
                    }
                } else {
                    this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getError(), GrpcCompilerPluginConstants.CompilationErrors.RETURN_WITH_CALLER.getErrorCode());
                }
            }
        } else if (parameterNodes.size() > 2) {
            this.reportErrorDiagnostic((Node)functionDefinitionNode, syntaxNodeAnalysisContext, GrpcCompilerPluginConstants.CompilationErrors.MAX_PARAM_COUNT.getError(), GrpcCompilerPluginConstants.CompilationErrors.MAX_PARAM_COUNT.getErrorCode());
        }
    }

    private boolean isValidCallerParameter(String callerTypeName, String serviceName) {
        return callerTypeName.startsWith(serviceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + serviceName.substring(1)) && callerTypeName.endsWith(GRPC_EXACT_CALLER);
    }

    private void reportErrorDiagnostic(Node node, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, String message, String diagnosticId) {
        DiagnosticInfo diagnosticErrInfo = new DiagnosticInfo(diagnosticId, message, DiagnosticSeverity.ERROR);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticErrInfo, (Location)node.location(), (Object[])new Object[0]);
        syntaxNodeAnalysisContext.reportDiagnostic(diagnostic);
    }

    private String serviceNameFromServiceDeclarationNode(ServiceDeclarationNode serviceDeclarationNode) {
        NodeList nodeList = serviceDeclarationNode.absoluteResourcePath();
        if (nodeList.size() > 0) {
            String serviceName = serviceDeclarationNode.absoluteResourcePath().get(0).toString();
            return serviceName.replaceAll("\"", "").strip();
        }
        return "";
    }

    private String getFullServiceNameFromServiceDeclarationNode(ServiceDeclarationNode serviceDeclarationNode) {
        NodeList nodeList = serviceDeclarationNode.absoluteResourcePath();
        StringBuilder serviceNameBuilder = new StringBuilder();
        for (Node node : nodeList) {
            serviceNameBuilder.append(node.toString());
        }
        return serviceNameBuilder.toString().replaceAll("\"", "").strip();
    }

    private String typeNameFromParameterNode(ParameterNode parameterNode) {
        if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            return requiredParameterNode.typeName().toString().strip();
        }
        return "";
    }
}

