/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.transaction;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.transactions.TransactionConstants;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class Utils {
    private static final String STRUCT_TYPE_TRANSACTION_CONTEXT = "TransactionContext";
    private static final String STRUCT_TYPE_TRANSACTION_INFO = "Info";
    private static final String STRUCT_TYPE_TRANSACTION_INFO_INTERNAL = "InfoInternal";
    private static final String STRUCT_TYPE_TIMESTAMP = "TimestampImpl";

    public static void notifyResourceManagerOnAbort(BString transactionBlockId) {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        TransactionResourceManager.getInstance().notifyAbort(transactionLocalContext.getGlobalTransactionId(), transactionBlockId.getValue());
    }

    public static void rollbackTransaction(BString transactionBlockId) {
        TransactionResourceManager.getInstance().notifyTransactionAbort(transactionBlockId.getValue());
    }

    public static void cleanupTransactionContext(BString transactionBlockId) {
        TransactionResourceManager.getInstance().cleanupTransactionContext();
    }

    public static boolean getAndClearFailure() {
        return TransactionResourceManager.getInstance().getAndClearFailure();
    }

    public static void notifyRemoteParticipantOnFailure() {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        if (transactionLocalContext == null) {
            return;
        }
        transactionLocalContext.notifyLocalRemoteParticipantFailure();
    }

    public static void notifyLocalParticipantOnFailure() {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        if (transactionLocalContext == null) {
            return;
        }
        transactionLocalContext.notifyLocalParticipantFailure();
    }

    public static Object registerRemoteParticipant(Environment env, BString transactionBlockId) {
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        TransactionLocalContext transactionLocalContext = Utils.recreateTrxContext(env);
        transactionResourceManager.setCurrentTransactionContext(transactionLocalContext);
        transactionResourceManager.registerParticipation(transactionLocalContext.getGlobalTransactionId(), transactionBlockId.getValue());
        BMap trxContext = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)STRUCT_TYPE_TRANSACTION_CONTEXT);
        Object[] trxContextData = new Object[]{"1.0", transactionLocalContext.getGlobalTransactionId(), transactionBlockId.getValue(), transactionLocalContext.getProtocol(), transactionLocalContext.getURL()};
        return ValueCreator.createRecordValue((BMap)trxContext, (Object[])trxContextData);
    }

    public static void createTrxContextFromGlobalID(Environment env) {
        TransactionLocalContext transactionLocalContext = Utils.recreateTrxContext(env);
        TransactionResourceManager.getInstance().setCurrentTransactionContext(transactionLocalContext);
    }

    private static TransactionLocalContext recreateTrxContext(Environment env) {
        String gTransactionId = (String)env.getStrandLocal("globalTransactionId");
        if (gTransactionId == null) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)"No transaction is available to participate"));
        }
        String trxJsonString = env.getStrandLocal("transactionInfo").toString();
        BMap infoRecord = null;
        if (!trxJsonString.isEmpty()) {
            BArray infoArr = (BArray)JsonUtils.parse((String)trxJsonString);
            infoRecord = Utils.recreateInfoRecord(env, infoArr);
        }
        TransactionLocalContext transactionLocalContext = TransactionLocalContext.create((String)gTransactionId, (String)env.getStrandLocal("transactionUrl").toString(), (String)"2pc", (Object)infoRecord);
        return transactionLocalContext;
    }

    private static Map reorderInfoRecord(Environment env, BArray infoArr, int j) {
        BMap info = (BMap)infoArr.get((long)j);
        HashMap<String, Object> infoUpdateMap = new HashMap<String, Object>();
        String xid = info.get((Object)TransactionConstants.GLOBAL_TRX_ID).toString();
        byte[] xidArray = xid.getBytes(StandardCharsets.UTF_8);
        infoUpdateMap.put(TransactionConstants.GLOBAL_TRX_ID.getValue(), xidArray);
        infoUpdateMap.put(TransactionConstants.RETRY_NUMBER.getValue(), Integer.parseInt(info.get((Object)TransactionConstants.RETRY_NUMBER).toString()));
        int startTimeInt = Integer.parseInt(info.get((Object)TransactionConstants.START_TIME).toString());
        infoUpdateMap.put(TransactionConstants.START_TIME.getValue(), Utils.createTimeStampObject(env, startTimeInt));
        if (infoArr.getLength() - 1L > (long)j) {
            infoUpdateMap.put(TransactionConstants.PREVIOUS_ATTEMPT.getValue(), Utils.reorderInfoRecord(env, infoArr, j++));
        }
        return infoUpdateMap;
    }

    private static BObject createTimeStampObject(Environment env, int startTime) {
        BObject startTimeObj = ValueCreator.createObjectValue((Module)env.getCurrentModule(), (String)STRUCT_TYPE_TIMESTAMP, (Object[])new Object[0]);
        startTimeObj.addNativeData("timeValue", (Object)startTime);
        return startTimeObj;
    }

    private static BMap recreateInfoRecord(Environment env, BArray infoArr) {
        Map infoMap = Utils.reorderInfoRecord(env, infoArr, 0);
        BMap infoInternal = ValueCreator.createRecordValue((Module)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)STRUCT_TYPE_TRANSACTION_INFO_INTERNAL);
        Object[] infoData = new Object[]{ValueCreator.createArrayValue((byte[])((byte[])infoMap.get(TransactionConstants.GLOBAL_TRX_ID.getValue()))), infoMap.get(TransactionConstants.RETRY_NUMBER.getValue()), infoMap.get(TransactionConstants.PREVIOUS_ATTEMPT.getValue()), infoMap.get(TransactionConstants.START_TIME.getValue())};
        BMap infoRecord = ValueCreator.createRecordValue((BMap)infoInternal, (Object[])infoData);
        infoRecord.freezeDirect();
        return infoRecord;
    }

    public static Object registerLocalParticipant(Environment env, BString transactionBlockId, BFunctionPointer fpCommitted, BFunctionPointer fpAborted) {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        if (transactionLocalContext == null) {
            return null;
        }
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        transactionResourceManager.registerParticipation(transactionLocalContext.getGlobalTransactionId(), transactionBlockId.getValue());
        BMap trxContext = ValueCreator.createRecordValue((Module)env.getCurrentModule(), (String)STRUCT_TYPE_TRANSACTION_CONTEXT);
        Object[] trxContextData = new Object[]{"1.0", transactionLocalContext.getGlobalTransactionId(), transactionBlockId.getValue(), transactionLocalContext.getProtocol(), transactionLocalContext.getURL()};
        return ValueCreator.createRecordValue((BMap)trxContext, (Object[])trxContextData);
    }

    public static void setTransactionContext(BMap txDataStruct, Object prevAttemptInfo) {
        String globalTransactionId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_ID).toString();
        String transactionBlockId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_BLOCK_ID).toString();
        String url = txDataStruct.get((Object)TransactionConstants.REGISTER_AT_URL).toString();
        String protocol = txDataStruct.get((Object)TransactionConstants.CORDINATION_TYPE).toString();
        long retryNmbr = Utils.getRetryNumber(prevAttemptInfo);
        BMap trxContext = ValueCreator.createRecordValue((Module)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)STRUCT_TYPE_TRANSACTION_INFO);
        Object[] trxContextData = new Object[]{ValueCreator.createArrayValue((byte[])globalTransactionId.getBytes(Charset.defaultCharset())), retryNmbr, System.currentTimeMillis(), prevAttemptInfo};
        BMap infoRecord = ValueCreator.createRecordValue((BMap)trxContext, (Object[])trxContextData);
        TransactionLocalContext trxCtx = TransactionLocalContext.createTransactionParticipantLocalCtx((String)globalTransactionId, (String)url, (String)protocol, (Object)infoRecord);
        trxCtx.beginTransactionBlock(transactionBlockId);
        TransactionResourceManager.getInstance().setCurrentTransactionContext(trxCtx);
    }

    private static long getRetryNumber(Object prevAttemptInfo) {
        if (prevAttemptInfo == null) {
            return 0L;
        }
        Map infoRecord = (Map)prevAttemptInfo;
        Long retryNumber = (Long)infoRecord.get(StringUtils.fromString((String)"retryNumber"));
        return retryNumber + 1L;
    }

    public static boolean isNestedTransaction() {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        return transactionLocalContext != null;
    }

    public static BString getCurrentTransactionId() {
        Object currentTransactionId = "";
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        if (transactionLocalContext != null) {
            currentTransactionId = transactionLocalContext.getGlobalTransactionId() + ":" + transactionLocalContext.getCurrentTransactionBlockId();
        }
        return StringUtils.fromString((String)currentTransactionId);
    }

    public static boolean abortResourceManagers(BString transactionId, BString transactionBlockId) {
        return TransactionResourceManager.getInstance().notifyAbort(transactionId.getValue(), transactionBlockId.getValue());
    }

    public static boolean commitResourceManagers(BString transactionId, BString transactionBlockId) {
        return TransactionResourceManager.getInstance().notifyCommit(transactionId.getValue(), transactionBlockId.getValue());
    }

    public static boolean prepareResourceManagers(BString transactionId, BString transactionBlockId) {
        return TransactionResourceManager.getInstance().prepare(transactionId.getValue(), transactionBlockId.getValue());
    }

    public static long getAvailablePort() {
        return Utils.findFreePort();
    }

    public static void onCommit(BFunctionPointer fpValue) {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        transactionResourceManager.registerCommittedFunction(transactionLocalContext.getGlobalTransactionId(), fpValue);
    }

    public static void onRollback(BFunctionPointer fpValue) {
        TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
        TransactionResourceManager transactionResourceManager = TransactionResourceManager.getInstance();
        transactionResourceManager.registerAbortedFunction(transactionLocalContext.getGlobalTransactionId(), fpValue);
    }

    public static boolean isTransactional() {
        return TransactionResourceManager.getInstance().isInTransaction();
    }

    public static BMap<BString, Object> info() {
        if (Utils.isTransactional()) {
            TransactionLocalContext transactionLocalContext = TransactionResourceManager.getInstance().getCurrentTransactionContext();
            return (BMap)transactionLocalContext.getInfoRecord();
        }
        throw ErrorCreator.createError((BString)StringUtils.fromString((String)"cannot call info() if the strand is not in transaction mode"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = port;
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IllegalStateException("Could not find a free TCP/IP port");
    }

    public static BString getHostAddress() {
        return StringUtils.fromString((String)Utils.getLocalHostLANAddress().getHostAddress());
    }

    private static InetAddress getLocalHostLANAddress() throws RuntimeException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine LAN address: " + String.valueOf(e), e);
        }
    }

    public static int getTransactionAutoCommitTimeout() {
        TransactionResourceManager.getInstance();
        return TransactionResourceManager.getTransactionAutoCommitTimeout();
    }

    public static int getTransactionCleanupTimeout() {
        TransactionResourceManager.getInstance();
        return TransactionResourceManager.getTransactionCleanupTimeout();
    }
}

