/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.file.utils.FileUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FilePathUtils {
    public static Object absolute(BString inputPath) {
        try {
            return StringUtils.fromString((String)FileSystems.getDefault().getPath(inputPath.getValue(), new String[0]).toAbsolutePath().toString());
        }
        catch (InvalidPathException ex) {
            return FileUtils.getPathError("InvalidPathError", "Invalid path " + String.valueOf(inputPath));
        }
    }

    public static Object resolve(BString inputPath) {
        try {
            Path realPath = Files.readSymbolicLink(Paths.get(inputPath.getValue(), new String[0]).toAbsolutePath());
            return StringUtils.fromString((String)realPath.toString());
        }
        catch (NotLinkException ex) {
            return FileUtils.getPathError("NotLinkError", "Path is not a symbolic link " + String.valueOf(inputPath));
        }
        catch (NoSuchFileException ex) {
            return FileUtils.getPathError("FileNotFoundError", "File does not exist at " + String.valueOf(inputPath));
        }
        catch (IOException ex) {
            return FileUtils.getPathError("IOError", "IO error for " + String.valueOf(inputPath));
        }
        catch (SecurityException ex) {
            return FileUtils.getPathError("SecurityError", "Security error for " + String.valueOf(inputPath));
        }
    }

    private FilePathUtils() {
    }
}

