/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.scheduling.ClassloaderRuntime;
import io.ballerina.shell.DiagnosticReporter;
import io.ballerina.shell.exceptions.InvokerException;
import io.ballerina.shell.exceptions.InvokerPanicException;
import io.ballerina.shell.invoker.AvailableVariable;
import io.ballerina.shell.invoker.classload.context.ClassLoadContext;
import io.ballerina.shell.snippet.Snippet;
import io.ballerina.shell.utils.StringUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class ShellSnippetsInvoker
extends DiagnosticReporter {
    protected static final String MODULE_RUN_METHOD_NAME = "__run";
    protected static final String MODULE_STATEMENT_METHOD_NAME = "__stmt";
    private static final String MODULE_INIT_CLASS_NAME = "$_init";
    private static final String CONFIGURE_INIT_CLASS_NAME = "$configurationMapper";
    private static final String MODULE_INIT_METHOD_NAME = "$moduleInit";
    private static final String MODULE_START_METHOD_NAME = "$moduleStart";
    private static final String CONFIGURE_INIT_METHOD_NAME = "$configureInit";
    private static final String TEMP_FILE_PREFIX = "main-";
    private static final String TEMP_FILE_SUFFIX = ".bal";
    private static final String MODULE_NOT_FOUND_CODE = "BCE2003";
    private File bufferFile;

    protected ShellSnippetsInvoker() {
    }

    public abstract void initialize() throws InvokerException;

    public abstract void reset();

    public abstract PackageCompilation getCompilation(Collection<Snippet> var1) throws InvokerException;

    public abstract Optional<Object> execute(Optional<PackageCompilation> var1) throws InvokerException;

    public abstract void delete(Set<String> var1) throws InvokerException;

    public abstract List<String> availableImports();

    public abstract List<String> availableVariables();

    public abstract List<AvailableVariable> availableVariablesAsObjects();

    public abstract List<String> availableModuleDeclarations();

    public abstract void clearPreviousVariablesAndModuleDclnsNames();

    public abstract List<String> newVariableNames();

    public abstract List<String> newModuleDeclarations();

    protected Mustache getTemplate(String templateName) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        return mf.compile(templateName);
    }

    protected Project getProject(Object context, String templateFile) throws InvokerException {
        Project project;
        Mustache template = this.getTemplate(templateFile);
        StringWriter stringWriter = new StringWriter();
        try {
            template.execute((Writer)stringWriter, context);
            project = this.getProject(stringWriter.toString(), true);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.addErrorDiagnostic("File generation failed: " + e.getMessage());
                throw new InvokerException(e);
            }
        }
        stringWriter.close();
        return project;
    }

    protected Project getProject(String source, boolean isOffline) throws InvokerException {
        try {
            File mainBal = this.writeToFile(source);
            BuildOptions buildOptions = BuildOptions.builder().setOffline(Boolean.valueOf(isOffline)).targetDir(ProjectUtils.getTemporaryTargetPath()).build();
            return SingleFileProject.load((Path)mainBal.toPath(), (BuildOptions)buildOptions);
        }
        catch (IOException e) {
            this.addErrorDiagnostic("File writing failed: " + e.getMessage());
            throw new InvokerException(e);
        }
    }

    protected PackageCompilation compile(Project project) throws InvokerException {
        boolean containErrors = false;
        try {
            Module module = project.currentPackage().getDefaultModule();
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            DiagnosticResult diagnosticResult = packageCompilation.diagnosticResult();
            for (Diagnostic diagnostic : diagnosticResult.diagnostics()) {
                DiagnosticSeverity severity = diagnostic.diagnosticInfo().severity();
                if (severity == DiagnosticSeverity.ERROR) {
                    containErrors = true;
                    this.addErrorDiagnostic(this.highlightedDiagnostic(module, diagnostic));
                    continue;
                }
                if (severity == DiagnosticSeverity.WARNING) {
                    this.addWarnDiagnostic(this.highlightedDiagnostic(module, diagnostic));
                    continue;
                }
                this.addDebugDiagnostic(diagnostic.message());
            }
            if (containErrors) {
                this.addErrorDiagnostic("Compilation aborted due to errors.");
                throw new InvokerException();
            }
            return packageCompilation;
        }
        catch (InvokerException e) {
            throw e;
        }
        catch (Exception e) {
            this.addErrorDiagnostic("Something went wrong: " + String.valueOf(e));
            throw new InvokerException(e);
        }
    }

    protected void compileImportStatement(String importStatement) throws InvokerException {
        PackageCompilation onlineCompilation;
        PackageCompilation offlineCompilation = this.getProject(importStatement, true).currentPackage().getCompilation();
        if (this.containsModuleNotFoundError(offlineCompilation) && this.containsModuleNotFoundError(onlineCompilation = this.getProject(importStatement, false).currentPackage().getCompilation())) {
            this.addErrorDiagnostic("Import resolution failed. Module not found.");
            throw new InvokerException();
        }
    }

    private boolean containsModuleNotFoundError(PackageCompilation compilation) {
        for (Diagnostic diagnostic : compilation.diagnosticResult().diagnostics()) {
            if (!diagnostic.diagnosticInfo().code().equals(MODULE_NOT_FOUND_CODE)) continue;
            return true;
        }
        return false;
    }

    protected void executeProject(ClassLoadContext context, String templateName) throws InvokerException {
        Project project = this.getProject(context, templateName);
        PackageCompilation compilation = this.compile(project);
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)compilation, (JvmTarget)JvmTarget.JAVA_21);
        Package pkg = project.currentPackage();
        io.ballerina.runtime.api.Module module = new io.ballerina.runtime.api.Module(pkg.packageOrg().value(), pkg.packageName().value(), pkg.packageVersion().toString());
        this.executeProject(jBallerinaBackend, module);
    }

    protected void executeProject(JBallerinaBackend jBallerinaBackend, io.ballerina.runtime.api.Module module) throws InvokerPanicException {
        if (this.bufferFile == null) {
            throw new UnsupportedOperationException("Buffer file must be set before execution");
        }
        PrintStream errorStream = this.getErrorStream();
        try {
            JarResolver jarResolver = jBallerinaBackend.jarResolver();
            ClassLoader classLoader = jarResolver.getClassLoaderWithRequiredJarFilesForExecution();
            Object failErrorMessage = this.callRun(classLoader, module);
            if (failErrorMessage != null) {
                errorStream.println("fail: " + String.valueOf(failErrorMessage));
            }
        }
        catch (Throwable panicError) {
            List<String> stacktrace = Arrays.stream(panicError.getCause().getStackTrace()).filter(element -> !element.toString().contains(MODULE_STATEMENT_METHOD_NAME) && !element.toString().contains(MODULE_RUN_METHOD_NAME)).toList().stream().map(element -> "at " + element.getMethodName() + "()").toList();
            errorStream.println("panic: " + StringUtils.getErrorStringValue(panicError.getCause()));
            stacktrace.forEach(errorStream::println);
            this.addErrorDiagnostic("Execution aborted due to unhandled runtime error.");
            throw panicError;
        }
    }

    protected Object callRun(ClassLoader classLoader, io.ballerina.runtime.api.Module module) throws InvokerPanicException {
        Object result;
        ClassloaderRuntime runtime = new ClassloaderRuntime(module, classLoader);
        try {
            result = runtime.init();
            if (result instanceof Throwable) {
                Throwable throwable = (Throwable)result;
                throw new InvokerPanicException(throwable);
            }
            result = runtime.start();
            if (result instanceof Throwable) {
                Throwable throwable = (Throwable)result;
                throw new InvokerPanicException(throwable);
            }
            result = runtime.callFunction(module, MODULE_RUN_METHOD_NAME, null, new Object[0]);
            if (result instanceof Throwable) {
                Throwable throwable = (Throwable)result;
                throw new InvokerPanicException(throwable);
            }
        }
        catch (Throwable throwable) {
            throw new InvokerPanicException(throwable);
        }
        finally {
            try {
                runtime.stop();
            }
            catch (BError throwable) {}
        }
        return result;
    }

    private String highlightedDiagnostic(Module module, Diagnostic diagnostic) {
        Optional documentId = module.documentIds().stream().findFirst();
        Document document = module.document((DocumentId)documentId.orElseThrow());
        return StringUtils.highlightDiagnostic(document.textDocument(), diagnostic);
    }

    protected File writeToFile(String source) throws IOException {
        File createdFile = this.getBufferFile();
        try (FileWriter fileWriter = new FileWriter(createdFile, Charset.defaultCharset());){
            fileWriter.write(source);
        }
        return createdFile;
    }

    public File getBufferFile() throws IOException {
        if (this.bufferFile == null) {
            this.bufferFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.addDebugDiagnostic("Using temp file: " + this.bufferFile.getAbsolutePath());
            this.bufferFile.deleteOnExit();
        }
        return this.bufferFile;
    }

    protected PrintStream getErrorStream() {
        return System.err;
    }
}

