/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet.factory;

import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BreakStatementNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.ContinueStatementNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.LocalTypeDefinitionStatementNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleXMLNamespaceDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarator;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.compiler.syntax.tree.XMLNamespaceDeclarationNode;
import io.ballerina.shell.exceptions.SnippetException;
import io.ballerina.shell.snippet.SnippetSubKind;
import io.ballerina.shell.snippet.factory.SnippetFactory;
import io.ballerina.shell.snippet.types.ExpressionSnippet;
import io.ballerina.shell.snippet.types.ImportDeclarationSnippet;
import io.ballerina.shell.snippet.types.ModuleMemberDeclarationSnippet;
import io.ballerina.shell.snippet.types.StatementSnippet;
import io.ballerina.shell.snippet.types.VariableDeclarationSnippet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BasicSnippetFactory
extends SnippetFactory {
    private int varFunctionCount = 0;
    protected static final Map<Class<?>, SnippetSubKind> MODULE_MEM_DCLNS = Map.ofEntries(Map.entry(FunctionDefinitionNode.class, SnippetSubKind.FUNCTION_DEFINITION), Map.entry(ListenerDeclarationNode.class, SnippetSubKind.LISTENER_DECLARATION), Map.entry(TypeDefinitionNode.class, SnippetSubKind.TYPE_DEFINITION), Map.entry(ServiceDeclarationNode.class, SnippetSubKind.SERVICE_DECLARATION), Map.entry(ConstantDeclarationNode.class, SnippetSubKind.CONSTANT_DECLARATION), Map.entry(ModuleVariableDeclarationNode.class, SnippetSubKind.MODULE_VARIABLE_DECLARATION), Map.entry(AnnotationDeclarationNode.class, SnippetSubKind.ANNOTATION_DECLARATION), Map.entry(ModuleXMLNamespaceDeclarationNode.class, SnippetSubKind.MODULE_XML_NAMESPACE_DECLARATION), Map.entry(EnumDeclarationNode.class, SnippetSubKind.ENUM_DECLARATION), Map.entry(ClassDefinitionNode.class, SnippetSubKind.CLASS_DEFINITION));
    protected static final Map<Class<?>, SnippetSubKind> STATEMENTS = Map.ofEntries(Map.entry(AssignmentStatementNode.class, SnippetSubKind.ASSIGNMENT_STATEMENT), Map.entry(CompoundAssignmentStatementNode.class, SnippetSubKind.COMPOUND_ASSIGNMENT_STATEMENT), Map.entry(VariableDeclarationNode.class, SnippetSubKind.VARIABLE_DECLARATION_STATEMENT), Map.entry(BlockStatementNode.class, SnippetSubKind.BLOCK_STATEMENT), Map.entry(BreakStatementNode.class, SnippetSubKind.BREAK_STATEMENT), Map.entry(FailStatementNode.class, SnippetSubKind.FAIL_STATEMENT), Map.entry(ExpressionStatementNode.class, SnippetSubKind.EXPRESSION_STATEMENT), Map.entry(ContinueStatementNode.class, SnippetSubKind.CONTINUE_STATEMENT), Map.entry(IfElseStatementNode.class, SnippetSubKind.IF_ELSE_STATEMENT), Map.entry(WhileStatementNode.class, SnippetSubKind.WHILE_STATEMENT), Map.entry(PanicStatementNode.class, SnippetSubKind.PANIC_STATEMENT), Map.entry(ReturnStatementNode.class, SnippetSubKind.RETURN_STATEMENT), Map.entry(LocalTypeDefinitionStatementNode.class, SnippetSubKind.LOCAL_TYPE_DEFINITION_STATEMENT), Map.entry(LockStatementNode.class, SnippetSubKind.LOCK_STATEMENT), Map.entry(ForkStatementNode.class, SnippetSubKind.FORK_STATEMENT), Map.entry(ForEachStatementNode.class, SnippetSubKind.FOR_EACH_STATEMENT), Map.entry(XMLNamespaceDeclarationNode.class, SnippetSubKind.XML_NAMESPACE_DECLARATION_STATEMENT), Map.entry(TransactionStatementNode.class, SnippetSubKind.TRANSACTION_STATEMENT), Map.entry(RollbackStatementNode.class, SnippetSubKind.ROLLBACK_STATEMENT), Map.entry(RetryStatementNode.class, SnippetSubKind.RETRY_STATEMENT), Map.entry(MatchStatementNode.class, SnippetSubKind.MATCH_STATEMENT), Map.entry(DoStatementNode.class, SnippetSubKind.DO_STATEMENT));

    @Override
    public ImportDeclarationSnippet createImportSnippet(Node node) {
        if (node instanceof ImportDeclarationNode) {
            ImportDeclarationNode importDeclarationNode = (ImportDeclarationNode)node;
            return new ImportDeclarationSnippet(importDeclarationNode);
        }
        return null;
    }

    @Override
    public List<VariableDeclarationSnippet> createVariableDeclarationSnippets(Node node) {
        ModuleVariableDeclarationNode dclnNode;
        ModuleVariableDeclarationNode newDclnNode = null;
        ArrayList<VariableDeclarationSnippet> snippets = new ArrayList<VariableDeclarationSnippet>();
        if (this.containsIsolated(node)) {
            this.addErrorDiagnostic("Isolation not allowed in the Ballerina shell");
            return null;
        }
        if (node instanceof ModuleVariableDeclarationNode) {
            ModuleVariableDeclarationNode moduleVariableDeclarationNode;
            dclnNode = moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)node;
        } else if (node instanceof VariableDeclarationNode) {
            Optional optVarInitNode;
            VariableDeclarationNode varNode = (VariableDeclarationNode)node;
            VariableDeclarationNode newNode = null;
            NodeList qualifiers = NodeFactory.createEmptyNodeList();
            if (varNode.finalKeyword().isPresent()) {
                qualifiers = NodeFactory.createNodeList((Node[])new Token[]{(Token)varNode.finalKeyword().get()});
            }
            if ((optVarInitNode = varNode.initializer()).isEmpty()) {
                assert (false) : "This line is unreachable as the error is captured before.";
                this.addErrorDiagnostic("Variable declaration without an initializer is not allowed");
                return null;
            }
            ExpressionNode varInitNode = (ExpressionNode)optVarInitNode.get();
            SyntaxKind nodeKind = varInitNode.kind();
            if (this.isSupportedAction(nodeKind)) {
                TypedBindingPatternNode typedBindingPatternNode = varNode.typedBindingPattern();
                TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
                BindingPatternNode bindingPatternNode = typedBindingPatternNode.bindingPattern();
                if (typeDescriptorNode.kind() == SyntaxKind.VAR_TYPE_DESC) {
                    this.addErrorDiagnostic("'var' type is not yet supported for actions. Please specify the exact type.");
                    return null;
                }
                boolean isCheckAction = nodeKind == SyntaxKind.CHECK_ACTION;
                String initAction = varInitNode.toSourceCode();
                String functionTypeDesc = (isCheckAction ? "function() returns error|" : "function() returns ") + String.valueOf(typeDescriptorNode);
                String functionName = "__shell_wrapper__" + this.varFunctionCount;
                String functionVarDecl = String.format("%s %s = %s {%s %s = %s; return %s;};", functionTypeDesc, functionName, functionTypeDesc, typeDescriptorNode, bindingPatternNode, initAction, bindingPatternNode);
                varNode = (VariableDeclarationNode)NodeParser.parseStatement((String)functionVarDecl);
                newNode = (VariableDeclarationNode)NodeParser.parseStatement((String)String.format("%s %s = %s %s();", typeDescriptorNode, bindingPatternNode, isCheckAction ? "check " : "", functionName));
            }
            ++this.varFunctionCount;
            dclnNode = NodeFactory.createModuleVariableDeclarationNode((MetadataNode)NodeFactory.createMetadataNode(null, (NodeList)varNode.annotations()), null, (NodeList)qualifiers, (TypedBindingPatternNode)varNode.typedBindingPattern(), (Token)varNode.equalsToken().orElse(null), (ExpressionNode)varNode.initializer().orElse(null), (Token)varNode.semicolonToken());
            if (newNode != null) {
                newDclnNode = NodeFactory.createModuleVariableDeclarationNode((MetadataNode)NodeFactory.createMetadataNode(null, (NodeList)newNode.annotations()), null, (NodeList)qualifiers, (TypedBindingPatternNode)newNode.typedBindingPattern(), (Token)newNode.equalsToken().orElse(null), (ExpressionNode)newNode.initializer().orElse(null), (Token)newNode.semicolonToken());
            }
        } else {
            return null;
        }
        if (dclnNode.initializer().isEmpty()) {
            this.addErrorDiagnostic("Variables without initializers are not permitted. Give an initial value for your variable.");
            return null;
        }
        snippets.add(new VariableDeclarationSnippet(dclnNode));
        if (newDclnNode != null) {
            snippets.add(new VariableDeclarationSnippet(newDclnNode));
        }
        return snippets;
    }

    @Override
    public ModuleMemberDeclarationSnippet createModuleMemberDeclarationSnippet(Node node) throws SnippetException {
        if (this.containsIsolated(node)) {
            return null;
        }
        if (node instanceof ModuleMemberDeclarationNode) {
            ModuleMemberDeclarationNode moduleMemberDeclarationNode = (ModuleMemberDeclarationNode)node;
            assert (MODULE_MEM_DCLNS.containsKey(node.getClass()));
            SnippetSubKind subKind = MODULE_MEM_DCLNS.get(node.getClass());
            if (subKind.hasError()) {
                this.addErrorDiagnostic(subKind.getError());
                throw new SnippetException();
            }
            if (subKind.isValid()) {
                return new ModuleMemberDeclarationSnippet(subKind, moduleMemberDeclarationNode);
            }
        }
        return null;
    }

    @Override
    public StatementSnippet createStatementSnippet(Node node) throws SnippetException {
        if (node instanceof StatementNode) {
            assert (STATEMENTS.containsKey(node.getClass()));
            SnippetSubKind subKind = STATEMENTS.get(node.getClass());
            if (subKind.hasError()) {
                this.addErrorDiagnostic(subKind.getError());
                throw new SnippetException();
            }
            if (subKind.isValid()) {
                return new StatementSnippet(subKind, (StatementNode)node);
            }
        } else if (node instanceof NamedWorkerDeclarator) {
            this.addErrorDiagnostic("Named worker declarators cannot be used in the REPL as top level statement.\nPlease use them in a suitable place such as in a function.");
        }
        return null;
    }

    @Override
    public ExpressionSnippet createExpressionSnippet(Node node) {
        if (node instanceof ExpressionNode) {
            ExpressionNode expressionNode = (ExpressionNode)node;
            return new ExpressionSnippet(expressionNode);
        }
        return null;
    }

    private boolean containsIsolated(Node node) {
        if (node instanceof ModuleVariableDeclarationNode) {
            ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)node;
            NodeList nodeList = moduleVariableDeclarationNode.qualifiers();
            return nodeList.stream().anyMatch(token -> token.kind() == SyntaxKind.ISOLATED_KEYWORD);
        }
        if (node instanceof FunctionDefinitionNode) {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            NodeList nodeList = functionDefinitionNode.qualifierList();
            return nodeList.stream().anyMatch(token -> token.kind() == SyntaxKind.ISOLATED_KEYWORD);
        }
        return false;
    }

    private boolean isSupportedAction(SyntaxKind nodeKind) {
        return switch (nodeKind) {
            case SyntaxKind.REMOTE_METHOD_CALL_ACTION, SyntaxKind.BRACED_ACTION, SyntaxKind.CHECK_ACTION, SyntaxKind.START_ACTION, SyntaxKind.TRAP_ACTION, SyntaxKind.FLUSH_ACTION, SyntaxKind.ASYNC_SEND_ACTION, SyntaxKind.SYNC_SEND_ACTION, SyntaxKind.RECEIVE_ACTION, SyntaxKind.WAIT_ACTION, SyntaxKind.QUERY_ACTION, SyntaxKind.COMMIT_ACTION, SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION -> true;
            default -> false;
        };
    }
}

