/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet.types;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.shell.snippet.Snippet;
import io.ballerina.shell.snippet.SnippetKind;
import io.ballerina.shell.snippet.SnippetSubKind;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AbstractSnippet<T extends Node>
implements Snippet {
    protected final SnippetSubKind subKind;
    protected final T rootNode;

    protected AbstractSnippet(SnippetSubKind subKind, T rootNode) {
        this.subKind = subKind;
        this.rootNode = rootNode;
    }

    @Override
    public Set<String> usedImports() {
        HashSet<String> imports = new HashSet<String>();
        this.rootNode.accept((NodeVisitor)new ImportNameFinder(imports));
        return imports;
    }

    @Override
    public SnippetKind getKind() {
        return this.subKind.getKind();
    }

    public String toString() {
        return this.rootNode.toSourceCode();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSnippet that = (AbstractSnippet)o;
        return this.subKind == that.subKind && this.rootNode.equals(that.rootNode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subKind, this.rootNode});
    }

    private static class ImportNameFinder
    extends NodeVisitor {
        private final Set<String> imports;

        public ImportNameFinder(Set<String> imports) {
            this.imports = imports;
        }

        public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
            super.visit(qualifiedNameReferenceNode);
            this.imports.add(qualifiedNameReferenceNode.modulePrefix().text());
        }
    }
}

