/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.utils;

import io.ballerina.shell.utils.Identifier;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class QuotedImport {
    private final String orgName;
    private final List<Identifier> moduleNames;

    public QuotedImport(String orgName, List<String> moduleNames) {
        this.orgName = orgName;
        this.moduleNames = moduleNames.stream().map(Identifier::new).toList();
    }

    public QuotedImport(List<String> moduleNames) {
        this(null, moduleNames);
    }

    public Identifier getDefaultPrefix() {
        return this.moduleNames.get(this.moduleNames.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotedImport that = (QuotedImport)o;
        return Objects.equals(this.orgName, that.orgName) && this.moduleNames.equals(that.moduleNames);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.moduleNames);
    }

    public String toString() {
        StringJoiner moduleName = new StringJoiner(".");
        this.moduleNames.forEach(name -> moduleName.add(name.getName()));
        if (this.orgName == null) {
            return moduleName.toString();
        }
        return String.format("%s/%s", this.orgName, moduleName);
    }
}

