/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.utils;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final int MAX_VAR_STRING_LENGTH = 78;
    private static final String QUOTE = "'";
    private static final String SPACE = " ";
    private static final String CARET = "^";
    private static final String DASH = "-";

    private StringUtils() {
    }

    public static String quoted(String identifier) {
        if (String.valueOf(identifier).startsWith(QUOTE)) {
            return identifier;
        }
        return QUOTE + identifier;
    }

    public static String shortenedString(Object input) {
        String value = String.valueOf(input);
        if ((value = value.replace("\n", "")).length() > 78) {
            int subStrLength = 39;
            return value.substring(0, subStrLength) + "..." + value.substring(value.length() - subStrLength);
        }
        return value;
    }

    public static String highlightDiagnostic(TextDocument textDocument, Diagnostic diagnostic) {
        LineRange lineRange = diagnostic.location().lineRange();
        LinePosition startLine = lineRange.startLine();
        LinePosition endLine = lineRange.endLine();
        if (startLine.line() != endLine.line()) {
            StringJoiner errorMessage = new StringJoiner("\n\t");
            errorMessage.add(diagnostic.message());
            for (int i = startLine.line(); i <= endLine.line(); ++i) {
                errorMessage.add(textDocument.line(i).text().strip());
            }
            return errorMessage.toString();
        }
        int position = startLine.offset();
        int length = Math.max(endLine.offset() - position, 1);
        String caretUnderline = length == 1 ? CARET : CARET + DASH.repeat(length - 2) + CARET;
        String sourceLine = textDocument.line(startLine.line()).text();
        int leadingSpaces = sourceLine.length() - sourceLine.stripLeading().length();
        String strippedSourceLine = sourceLine.substring(leadingSpaces);
        return String.format("error: %s%n\t%s%n\t%s%s", diagnostic.message(), strippedSourceLine, SPACE.repeat(position - leadingSpaces), caretUnderline);
    }

    public static String unescapeUnicodeCodepoints(String identifier) {
        return Utils.unescapeUnicodeCodepoints((String)identifier);
    }

    public static String encodeIdentifier(String string) {
        return string.replace("\\", "\\\\");
    }

    public static String getExpressionStringValue(Object object) {
        return io.ballerina.runtime.api.utils.StringUtils.getExpressionStringValue((Object)object);
    }

    public static String getErrorStringValue(Throwable error) {
        if (error instanceof BError) {
            BError bError = (BError)error;
            return String.valueOf(bError.getErrorMessage()) + SPACE + String.valueOf(bError.getDetails());
        }
        return error.getMessage();
    }

    public static String convertUnicode(char character) {
        return "\\u{" + Integer.toHexString(character) + "}";
    }

    public static String convertUnicodeToCharacter(String toConvert) {
        Matcher matcher = Pattern.compile("\\\\u\\{([\\da-fA-F]*)}").matcher(toConvert);
        StringBuilder stringBuilder = new StringBuilder();
        int currentPosition = 0;
        while (matcher.find()) {
            stringBuilder.append(toConvert, currentPosition, matcher.start());
            int code = Integer.parseInt(matcher.group(1), 16);
            stringBuilder.append(Character.toChars(code));
            currentPosition = matcher.end();
        }
        stringBuilder.append(toConvert.substring(currentPosition));
        return stringBuilder.toString();
    }
}

