/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.pkgsemanticanalyzer;

import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.plugins.CodeAnalysisContext;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.projects.plugins.CompilerPlugin;
import io.ballerina.projects.plugins.CompilerPluginContext;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;

public class PackageSemanticAnalyzerPlugin
extends CompilerPlugin {
    public void init(CompilerPluginContext pluginContext) {
        pluginContext.addCodeAnalyzer((CodeAnalyzer)new PackageSemanticAnalyzer());
    }

    private static TomlNodeLocation getExportValueNodeLocation(CompilationAnalysisContext compilationAnalysisContext, String exportModuleName) {
        Package currentPackage = compilationAnalysisContext.currentPackage();
        if (currentPackage.ballerinaToml().isPresent()) {
            TomlValueNode exportValueNode;
            TomlTableNode rootNode = ((BallerinaToml)currentPackage.ballerinaToml().get()).tomlAstNode();
            TomlTableNode pkgNode = (TomlTableNode)rootNode.entries().get("package");
            TopLevelNode exportNode = (TopLevelNode)pkgNode.entries().get("export");
            if (exportNode != null && exportNode.kind() != TomlType.NONE && (exportValueNode = ((TomlKeyValueNode)exportNode).value()).kind() == TomlType.ARRAY) {
                TomlArrayValueNode exportArrayValueNode = (TomlArrayValueNode)exportValueNode;
                for (TomlValueNode value : exportArrayValueNode.elements()) {
                    if (value.kind() != TomlType.STRING || !exportModuleName.equals(((TomlStringValueNode)value).getValue())) continue;
                    return value.location();
                }
            }
            throw new ProjectException("exported module does not exists in the 'Ballerina.toml': " + exportModuleName);
        }
        throw new ProjectException("'Ballerina.toml' does not exist in the current project");
    }

    private static void reportTomlDiagnostic(CompilationAnalysisContext compilationAnalysisContext, TomlNodeLocation location, String code, String message, DiagnosticSeverity severity) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, severity);
        TomlDiagnostic tomlDiagnostic = new TomlDiagnostic(location, diagnosticInfo, message);
        compilationAnalysisContext.reportDiagnostic((Diagnostic)tomlDiagnostic);
    }

    public static class PackageSemanticAnalyzer
    extends CodeAnalyzer {
        public void init(CodeAnalysisContext analysisContext) {
            analysisContext.addCompilationAnalysisTask(compilationAnalysisContext -> {
                List exportedModules = compilationAnalysisContext.currentPackage().manifest().exportedModules();
                ArrayList<String> packageModules = new ArrayList<String>();
                for (ModuleId moduleId : compilationAnalysisContext.currentPackage().moduleIds()) {
                    Module module = compilationAnalysisContext.currentPackage().module(moduleId);
                    packageModules.add(module.moduleName().toString());
                }
                for (String exportedModule : exportedModules) {
                    if (packageModules.contains(exportedModule)) continue;
                    TomlNodeLocation location = PackageSemanticAnalyzerPlugin.getExportValueNodeLocation(compilationAnalysisContext, exportedModule);
                    PackageSemanticAnalyzerPlugin.reportTomlDiagnostic(compilationAnalysisContext, location, null, "exported module '" + exportedModule + "' is not a module of the package", DiagnosticSeverity.ERROR);
                }
            });
        }
    }
}

